/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DSpaceControlledVocabulary
extends SelfNamedPlugin
implements ChoiceAuthority {
    private static Logger log = Logger.getLogger(DSpaceControlledVocabulary.class);
    protected static String xpathTemplate = "//node[contains(translate(@label,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz'),'%s')]";
    protected static String idTemplate = "//node[@id = '%s']";
    protected static String[] pluginNames = null;
    protected String vocabularyName = null;
    protected InputSource vocabulary = null;
    protected Boolean suggestHierarchy = true;
    protected Boolean storeHierarchy = true;
    protected String hierarchyDelimiter = "::";

    public static String[] getPluginNames() {
        if (pluginNames == null) {
            DSpaceControlledVocabulary.initPluginNames();
        }
        return (String[])ArrayUtils.clone((Object[])pluginNames);
    }

    private static synchronized void initPluginNames() {
        if (pluginNames == null) {
            String vocabulariesPath = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + "/config/controlled-vocabularies/";
            class XmlFilter
            implements FilenameFilter {
                XmlFilter() {
                }

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            }
            String[] xmlFiles = new File(vocabulariesPath).list(new XmlFilter());
            ArrayList<String> names = new ArrayList<String>();
            for (String filename : xmlFiles) {
                names.add(new File(filename).getName().replace(".xml", ""));
            }
            pluginNames = names.toArray(new String[names.size()]);
            log.info((Object)("Got plugin names = " + Arrays.deepToString(pluginNames)));
        }
    }

    protected void init() {
        if (this.vocabulary == null) {
            ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
            log.info((Object)("Initializing " + this.getClass().getName()));
            this.vocabularyName = this.getPluginInstanceName();
            String vocabulariesPath = config.getProperty("dspace.dir") + "/config/controlled-vocabularies/";
            String configurationPrefix = "vocabulary.plugin." + this.vocabularyName;
            this.storeHierarchy = config.getBooleanProperty(configurationPrefix + ".hierarchy.store", this.storeHierarchy.booleanValue());
            this.suggestHierarchy = config.getBooleanProperty(configurationPrefix + ".hierarchy.suggest", this.suggestHierarchy.booleanValue());
            String configuredDelimiter = config.getProperty(configurationPrefix + ".delimiter");
            if (configuredDelimiter != null) {
                this.hierarchyDelimiter = configuredDelimiter.replaceAll("(^\"|\"$)", "");
            }
            String filename = vocabulariesPath + this.vocabularyName + ".xml";
            log.info((Object)("Loading " + filename));
            this.vocabulary = new InputSource(filename);
        }
    }

    protected String buildString(Node node) {
        if (node.getNodeType() == 9) {
            return "";
        }
        String parentValue = this.buildString(node.getParentNode());
        Node currentLabel = node.getAttributes().getNamedItem("label");
        if (currentLabel != null) {
            String currentValue = currentLabel.getNodeValue();
            if (parentValue.equals("")) {
                return currentValue;
            }
            return parentValue + this.hierarchyDelimiter + currentValue;
        }
        return parentValue;
    }

    @Override
    public Choices getMatches(String field, String text, Collection collection, int start, int limit, String locale) {
        Choice[] choices;
        this.init();
        log.debug((Object)("Getting matches for '" + text + "'"));
        String xpathExpression = String.format(xpathTemplate, text.replaceAll("'", "&apos;").toLowerCase());
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList results = (NodeList)xpath.evaluate(xpathExpression, this.vocabulary, XPathConstants.NODESET);
            String[] authorities = new String[results.getLength()];
            String[] values = new String[results.getLength()];
            String[] labels = new String[results.getLength()];
            for (int i = 0; i < results.getLength(); ++i) {
                Node node = results.item(i);
                String hierarchy = this.buildString(node);
                labels[i] = this.suggestHierarchy != false ? hierarchy : node.getAttributes().getNamedItem("label").getNodeValue();
                values[i] = this.storeHierarchy != false ? hierarchy : node.getAttributes().getNamedItem("label").getNodeValue();
                Node idAttr = node.getAttributes().getNamedItem("id");
                if (null == idAttr) continue;
                authorities[i] = idAttr.getNodeValue();
            }
            int resultCount = labels.length - start;
            if (limit > 0 && resultCount > limit) {
                resultCount = limit;
            }
            choices = new Choice[resultCount];
            if (resultCount > 0) {
                for (int i = 0; i < resultCount; ++i) {
                    choices[i] = new Choice(authorities[start + i], values[start + i], labels[start + i]);
                }
            }
        }
        catch (XPathExpressionException e) {
            choices = new Choice[]{};
        }
        return new Choices(choices, 0, choices.length, 400, false);
    }

    @Override
    public Choices getBestMatch(String field, String text, Collection collection, String locale) {
        this.init();
        log.debug((Object)("Getting best match for '" + text + "'"));
        return this.getMatches(field, text, collection, 0, 2, locale);
    }

    @Override
    public String getLabel(String field, String key, String locale) {
        this.init();
        String xpathExpression = String.format(idTemplate, key);
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node node = (Node)xpath.evaluate(xpathExpression, this.vocabulary, XPathConstants.NODE);
            return node.getAttributes().getNamedItem("label").getNodeValue();
        }
        catch (XPathExpressionException e) {
            return "";
        }
    }
}

