/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sort.OrderFormat;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceMetadataBrowseIndexingPlugin
implements SolrServiceIndexPlugin {
    private static final Logger log = Logger.getLogger(SolrServiceMetadataBrowseIndexingPlugin.class);
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected MetadataAuthorityService metadataAuthorityService;
    @Autowired(required=true)
    protected ChoiceAuthorityService choiceAuthorityService;

    @Override
    public void additionalIndex(Context context, DSpaceObject dso, SolrInputDocument document) {
        BrowseIndex[] bis;
        if (!(dso instanceof Item)) {
            return;
        }
        Item item = (Item)dso;
        try {
            bis = BrowseIndex.getBrowseIndices();
        }
        catch (BrowseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        for (BrowseIndex bi : bis) {
            log.debug((Object)("Indexing for item " + item.getID() + ", for index: " + bi.getTableName()));
            if (!bi.isMetadataIndex()) continue;
            bi.generateMdBits();
            HashSet<String> distFValues = new HashSet<String>();
            HashSet<String> distFVal = new HashSet<String>();
            HashSet<String> distFAuths = new HashSet<String>();
            HashSet<String> distValuesForAC = new HashSet<String>();
            if (item.isArchived() || item.isWithdrawn()) {
                for (int mdIdx = 0; mdIdx < bi.getMetadataCount(); ++mdIdx) {
                    String[] md = bi.getMdBits(mdIdx);
                    List<MetadataValue> values = this.itemService.getMetadata(item, md[0], md[1], md[2], "*");
                    if (values == null || values.size() <= 0) continue;
                    int minConfidence = this.metadataAuthorityService.getMinConfidence(values.get(0).getMetadataField());
                    boolean ignoreAuthority = (Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore." + bi.getName(), DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore", (Object)new Boolean(false)), true);
                    for (int x = 0; x < values.size(); ++x) {
                        if (StringUtils.isEmpty((String)values.get(x).getValue())) {
                            log.error((Object)("Null metadata value for item " + item.getID() + ", field: " + values.get(x).getMetadataField().toString()));
                            continue;
                        }
                        if (bi.isAuthorityIndex() && (values.get(x).getAuthority() == null || values.get(x).getConfidence() < minConfidence)) {
                            log.debug((Object)("Skipping item=" + item.getID() + ", field=" + values.get(x).getMetadataField().toString() + ", value=" + values.get(x).getValue() + ", authority=" + values.get(x).getAuthority() + ", confidence=" + values.get(x).getConfidence() + " (BAD AUTHORITY)"));
                            continue;
                        }
                        if (ignoreAuthority && !bi.isAuthorityIndex() || values.get(x).getAuthority() != null && values.get(x).getConfidence() >= minConfidence) {
                            distFAuths.add(values.get(x).getAuthority());
                            distValuesForAC.add(values.get(x).getValue());
                            String preferedLabel = null;
                            boolean ignorePrefered = (Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-prefered." + bi.getName(), DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-prefered", (Object)new Boolean(false)), true);
                            if (!ignorePrefered) {
                                preferedLabel = this.choiceAuthorityService.getLabel(values.get(x), values.get(x).getLanguage());
                            }
                            List<String> variants = null;
                            boolean ignoreVariants = (Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-variants." + bi.getName(), DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-variants", (Object)new Boolean(false)), true);
                            if (!ignoreVariants) {
                                variants = this.choiceAuthorityService.getVariants(values.get(x));
                            }
                            if (StringUtils.isNotBlank((String)preferedLabel)) {
                                String nLabel = OrderFormat.makeSortString(preferedLabel, values.get(x).getLanguage(), bi.getDataType());
                                distFValues.add(nLabel + "\n|||\n" + preferedLabel + "###" + values.get(x).getAuthority());
                                distValuesForAC.add(preferedLabel);
                            }
                            if (variants == null) continue;
                            for (String var : variants) {
                                String nVal = OrderFormat.makeSortString(var, values.get(x).getLanguage(), bi.getDataType());
                                distFValues.add(nVal + "\n|||\n" + var + "###" + values.get(x).getAuthority());
                                distValuesForAC.add(var);
                            }
                            continue;
                        }
                        String nVal = OrderFormat.makeSortString(values.get(x).getValue(), values.get(x).getLanguage(), bi.getDataType());
                        distFValues.add(nVal + "\n|||\n" + values.get(x).getValue());
                        distFVal.add(values.get(x).getValue());
                        distValuesForAC.add(values.get(x).getValue());
                    }
                }
            }
            for (String facet : distFValues) {
                document.addField(bi.getDistinctTableName() + "_filter", (Object)facet);
            }
            for (String facet : distFAuths) {
                document.addField(bi.getDistinctTableName() + "_authority_filter", (Object)facet);
            }
            for (String facet : distValuesForAC) {
                document.addField(bi.getDistinctTableName() + "_partial", (Object)facet);
            }
            for (String facet : distFVal) {
                document.addField(bi.getDistinctTableName() + "_value_filter", (Object)facet);
            }
        }
        try {
            for (SortOption so : SortOption.getSortOptions()) {
                List<MetadataValue> dcvalue = this.itemService.getMetadataByMetadataString(item, so.getMetadata());
                if (dcvalue == null || dcvalue.size() <= 0) continue;
                String nValue = OrderFormat.makeSortString(dcvalue.get(0).getValue(), dcvalue.get(0).getLanguage(), so.getType());
                document.addField("bi_sort_" + so.getNumber() + "_sort", (Object)nValue);
            }
        }
        catch (SortException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

