/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.dao.SubscriptionDAO;
import org.dspace.eperson.service.SubscribeService;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscribeServiceImpl
implements SubscribeService {
    private Logger log = Logger.getLogger(SubscribeServiceImpl.class);
    @Autowired(required=true)
    protected SubscriptionDAO subscriptionDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected CollectionService collectionService;

    protected SubscribeServiceImpl() {
    }

    @Override
    public List<Subscription> findAll(Context context) throws SQLException {
        return this.subscriptionDAO.findAllOrderedByEPerson(context);
    }

    @Override
    public void subscribe(Context context, EPerson eperson, Collection collection) throws SQLException, AuthorizeException {
        if (this.authorizeService.isAdmin(context) || context.getCurrentUser() != null && context.getCurrentUser().getID().equals(eperson.getID())) {
            if (!this.isSubscribed(context, eperson, collection)) {
                Subscription subscription = this.subscriptionDAO.create(context, new Subscription());
                subscription.setCollection(collection);
                subscription.setePerson(eperson);
            }
        } else {
            throw new AuthorizeException("Only admin or e-person themselves can subscribe");
        }
    }

    @Override
    public void unsubscribe(Context context, EPerson eperson, Collection collection) throws SQLException, AuthorizeException {
        if (this.authorizeService.isAdmin(context) || context.getCurrentUser() != null && context.getCurrentUser().getID().equals(eperson.getID())) {
            if (collection == null) {
                this.subscriptionDAO.deleteByEPerson(context, eperson);
            } else {
                this.subscriptionDAO.deleteByCollectionAndEPerson(context, collection, eperson);
                this.log.info((Object)LogManager.getHeader(context, "unsubscribe", "eperson_id=" + eperson.getID() + ",collection_id=" + collection.getID()));
            }
        } else {
            throw new AuthorizeException("Only admin or e-person themselves can unsubscribe");
        }
    }

    @Override
    public List<Subscription> getSubscriptions(Context context, EPerson eperson) throws SQLException {
        return this.subscriptionDAO.findByEPerson(context, eperson);
    }

    @Override
    public List<Collection> getAvailableSubscriptions(Context context) throws SQLException {
        return this.getAvailableSubscriptions(context, null);
    }

    @Override
    public List<Collection> getAvailableSubscriptions(Context context, EPerson eperson) throws SQLException {
        if (eperson != null) {
            context.setCurrentUser(eperson);
        }
        List<Collection> collections = this.collectionService.findAuthorized(context, null, 3);
        return collections;
    }

    @Override
    public boolean isSubscribed(Context context, EPerson eperson, Collection collection) throws SQLException {
        return this.subscriptionDAO.findByCollectionAndEPerson(context, eperson, collection) != null;
    }

    @Override
    public void deleteByCollection(Context context, Collection collection) throws SQLException {
        this.subscriptionDAO.deleteByCollection(context, collection);
    }

    @Override
    public void deleteByEPerson(Context context, EPerson ePerson) throws SQLException {
        this.subscriptionDAO.deleteByEPerson(context, ePerson);
    }
}

