/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.ConfigurationManager;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;

public class GoogleRecorderEventListener
extends AbstractUsageEventListener {
    private String analyticsKey;
    private CloseableHttpClient httpclient;
    private String GoogleURL = "https://www.google-analytics.com/collect";
    private static Logger log = Logger.getLogger(GoogleRecorderEventListener.class);
    protected ContentServiceFactory contentServiceFactory = ContentServiceFactory.getInstance();

    public GoogleRecorderEventListener() {
        this.httpclient = HttpClients.createDefault();
    }

    public void receiveEvent(Event event) {
        if (event instanceof UsageEvent) {
            log.debug((Object)("Usage event received " + event.getName()));
            this.analyticsKey = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("jspui.google.analytics.key");
            if (this.analyticsKey == null) {
                this.analyticsKey = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("xmlui.google.analytics.key");
            }
            if (this.analyticsKey != null) {
                try {
                    UsageEvent ue = (UsageEvent)event;
                    if (ue.getAction() == UsageEvent.Action.VIEW && ue.getObject().getType() == 0) {
                        this.logEvent(ue, "bitstream", "download");
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
    }

    private void logEvent(UsageEvent ue, String category, String action) throws IOException, SQLException {
        HttpPost httpPost = new HttpPost(this.GoogleURL);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("v", "1"));
        nvps.add(new BasicNameValuePair("tid", this.analyticsKey));
        if (ue.getRequest().getSession(false) != null) {
            nvps.add(new BasicNameValuePair("cid", ue.getRequest().getSession().getId()));
        } else {
            nvps.add(new BasicNameValuePair("cid", UUID.randomUUID().toString()));
        }
        nvps.add(new BasicNameValuePair("t", "event"));
        nvps.add(new BasicNameValuePair("uip", this.getIPAddress(ue.getRequest())));
        nvps.add(new BasicNameValuePair("ua", ue.getRequest().getHeader("USER-AGENT")));
        nvps.add(new BasicNameValuePair("dr", ue.getRequest().getHeader("referer")));
        nvps.add(new BasicNameValuePair("dp", ue.getRequest().getRequestURI()));
        nvps.add(new BasicNameValuePair("dt", this.getObjectName(ue)));
        nvps.add(new BasicNameValuePair("ec", category));
        nvps.add(new BasicNameValuePair("ea", action));
        if (ue.getObject().getType() == 0) {
            nvps.add(new BasicNameValuePair("el", this.getParentType(ue)));
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        try (CloseableHttpResponse response2 = this.httpclient.execute((HttpUriRequest)httpPost);){
            log.debug((Object)("Google Analytics response is " + response2.getStatusLine()));
        }
        log.debug((Object)("Posted to Google Analytics - " + ue.getRequest().getRequestURI()));
    }

    private String getParentType(UsageEvent ue) {
        try {
            int parentType = this.contentServiceFactory.getDSpaceObjectService(ue.getObject()).getParentObject(ue.getContext(), ue.getObject()).getType();
            if (parentType == 2) {
                return "item";
            }
            if (parentType == 3) {
                return "collection";
            }
            if (parentType == 4) {
                return "community";
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error in Google Analytics recording - can't determine ParentObjectType for bitstream " + ue.getObject().getID()));
            e.printStackTrace();
        }
        return null;
    }

    private String getObjectName(UsageEvent ue) {
        try {
            if (ue.getObject().getType() == 0) {
                return this.contentServiceFactory.getDSpaceObjectService(ue.getObject()).getParentObject(ue.getContext(), ue.getObject()).getName();
            }
            return ue.getObject().getName();
        }
        catch (SQLException e) {
            log.error((Object)("Error in Google Analytics recording - can't determine ParentObjectName for bitstream " + ue.getObject().getID()));
            e.printStackTrace();
            return null;
        }
    }

    private String getIPAddress(HttpServletRequest request) {
        String clientIP = request.getRemoteAddr();
        if (ConfigurationManager.getBooleanProperty("useProxies", false) && request.getHeader("X-Forwarded-For") != null) {
            for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                if (request.getHeader("X-Forwarded-For").contains(clientIP)) continue;
                clientIP = xfip.trim();
            }
        }
        return clientIP;
    }
}

