/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.dspace.content.Collection;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.dao.HarvestedCollectionDAO;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.springframework.beans.factory.annotation.Autowired;

public class HarvestedCollectionServiceImpl
implements HarvestedCollectionService {
    @Autowired(required=true)
    protected HarvestedCollectionDAO harvestedCollectionDAO;

    protected HarvestedCollectionServiceImpl() {
    }

    @Override
    public HarvestedCollection find(Context context, Collection collection) throws SQLException {
        return this.harvestedCollectionDAO.findByCollection(context, collection);
    }

    @Override
    public HarvestedCollection create(Context context, Collection collection) throws SQLException {
        HarvestedCollection harvestedCollection = this.harvestedCollectionDAO.create(context, new HarvestedCollection());
        harvestedCollection.setCollection(collection);
        harvestedCollection.setHarvestType(0);
        this.update(context, harvestedCollection);
        return harvestedCollection;
    }

    @Override
    public boolean isHarvestable(Context context, Collection collection) throws SQLException {
        HarvestedCollection hc = this.find(context, collection);
        return hc != null && hc.getHarvestType() > 0 && hc.getOaiSource() != null && hc.getOaiSetId() != null && hc.getHarvestStatus() != -1;
    }

    @Override
    public boolean isHarvestable(HarvestedCollection harvestedCollection) throws SQLException {
        return harvestedCollection.getHarvestType() > 0 && harvestedCollection.getOaiSource() != null && harvestedCollection.getOaiSetId() != null && harvestedCollection.getHarvestStatus() != -1;
    }

    @Override
    public boolean isReady(Context context, Collection collection) throws SQLException {
        HarvestedCollection hc = this.find(context, collection);
        return this.isReady(hc);
    }

    @Override
    public boolean isReady(HarvestedCollection harvestedCollection) throws SQLException {
        return this.isHarvestable(harvestedCollection) && (harvestedCollection.getHarvestStatus() == 0 || harvestedCollection.getHarvestStatus() == 3);
    }

    @Override
    public List<HarvestedCollection> findAll(Context context) throws SQLException {
        return this.harvestedCollectionDAO.findAll(context, HarvestedCollection.class);
    }

    @Override
    public List<HarvestedCollection> findReady(Context context) throws SQLException {
        int expirationInterval;
        int harvestInterval = ConfigurationManager.getIntProperty("oai", "harvester.harvestFrequency");
        if (harvestInterval == 0) {
            harvestInterval = 720;
        }
        if ((expirationInterval = ConfigurationManager.getIntProperty("oai", "harvester.threadTimeout")) == 0) {
            expirationInterval = 24;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(12, -1 * harvestInterval);
        Date startTime = calendar.getTime();
        calendar.setTime(startTime);
        calendar.add(10, -2 * expirationInterval);
        Date expirationTime = calendar.getTime();
        int[] statuses = new int[]{0, 3};
        return this.harvestedCollectionDAO.findByLastHarvestedAndHarvestTypeAndHarvestStatusesAndHarvestTime(context, startTime, 0, statuses, 1, expirationTime);
    }

    @Override
    public List<HarvestedCollection> findByStatus(Context context, int status) throws SQLException {
        return this.harvestedCollectionDAO.findByStatus(context, status);
    }

    @Override
    public HarvestedCollection findOldestHarvest(Context context) throws SQLException {
        return this.harvestedCollectionDAO.findByStatusAndMinimalTypeOrderByLastHarvestedAsc(context, 0, 0, 1);
    }

    @Override
    public HarvestedCollection findNewestHarvest(Context context) throws SQLException {
        return this.harvestedCollectionDAO.findByStatusAndMinimalTypeOrderByLastHarvestedDesc(context, 0, 0, 1);
    }

    @Override
    public void delete(Context context, HarvestedCollection harvestedCollection) throws SQLException {
        this.harvestedCollectionDAO.delete(context, harvestedCollection);
    }

    @Override
    public void update(Context context, HarvestedCollection harvestedCollection) throws SQLException {
        this.harvestedCollectionDAO.save(context, harvestedCollection);
    }

    @Override
    public boolean exists(Context context) throws SQLException {
        return 0 < this.harvestedCollectionDAO.count(context);
    }
}

