/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.license;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.license.CCLookup;

public class LicenseMetadataValue {
    protected final ItemService itemService;
    protected static final String ccShib = "creativecommons";
    private String[] params = new String[4];

    public LicenseMetadataValue(String fieldName) {
        if (fieldName != null && fieldName.length() > 0) {
            String[] fParams = fieldName.split("\\.");
            for (int i = 0; i < fParams.length; ++i) {
                this.params[i] = fParams[i];
            }
            this.params[3] = "*";
        }
        this.itemService = ContentServiceFactory.getInstance().getItemService();
    }

    public String ccItemValue(Item item) {
        List<MetadataValue> dcvalues = this.itemService.getMetadata(item, this.params[0], this.params[1], this.params[2], this.params[3]);
        for (MetadataValue dcvalue : dcvalues) {
            if (dcvalue.getValue().indexOf(ccShib) == -1) continue;
            return dcvalue.getValue();
        }
        return null;
    }

    public String keyedItemValue(Item item, String key) throws AuthorizeException, IOException, SQLException {
        CCLookup ccLookup = new CCLookup();
        ccLookup.issue(key);
        String matchValue = ccLookup.getLicenseName();
        List<MetadataValue> dcvalues = this.itemService.getMetadata(item, this.params[0], this.params[1], this.params[2], this.params[3]);
        for (MetadataValue dcvalue : dcvalues) {
            if (!dcvalue.getValue().equals(matchValue)) continue;
            return dcvalue.getValue();
        }
        return null;
    }

    public void removeItemValue(Context context, Item item, String value) throws AuthorizeException, IOException, SQLException {
        if (value != null) {
            List<MetadataValue> dcvalues = this.itemService.getMetadata(item, this.params[0], this.params[1], this.params[2], this.params[3]);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MetadataValue dcvalue : dcvalues) {
                if (dcvalue.getValue().equals(value)) continue;
                arrayList.add(dcvalue.getValue());
            }
            this.itemService.clearMetadata(context, item, this.params[0], this.params[1], this.params[2], this.params[3]);
            this.itemService.addMetadata(context, item, this.params[0], this.params[1], this.params[2], this.params[3], arrayList);
        }
    }

    public void addItemValue(Context context, Item item, String value) throws SQLException {
        this.itemService.addMetadata(context, item, this.params[0], this.params[1], this.params[2], this.params[3], value);
    }
}

