/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.itemupdate.BitstreamFilter;
import org.dspace.app.itemupdate.BitstreamFilterException;
import org.dspace.app.itemupdate.DtoMetadata;
import org.dspace.app.itemupdate.ItemArchive;
import org.dspace.app.itemupdate.ItemUpdate;
import org.dspace.app.itemupdate.MetadataUtilities;
import org.dspace.app.itemupdate.UpdateBitstreamsAction;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.core.Context;

public class DeleteBitstreamsByFilterAction
extends UpdateBitstreamsAction {
    protected BitstreamFilter filter;

    public void setBitstreamFilter(BitstreamFilter filter) {
        this.filter = filter;
    }

    public BitstreamFilter getBitstreamFilter() {
        return this.filter;
    }

    @Override
    public void execute(Context context, ItemArchive itarch, boolean isTest, boolean suppressUndo) throws AuthorizeException, BitstreamFilterException, IOException, ParseException, SQLException {
        ArrayList<String> deleted = new ArrayList<String>();
        Item item = itarch.getItem();
        List<Bundle> bundles = item.getBundles();
        for (Bundle b : bundles) {
            List<Bitstream> bitstreams = b.getBitstreams();
            String bundleName = b.getName();
            for (Bitstream bs : bitstreams) {
                if (!this.filter.accept(bs)) continue;
                if (isTest) {
                    ItemUpdate.pr("Delete from bundle " + bundleName + " bitstream " + bs.getName() + " with id = " + bs.getID());
                    continue;
                }
                if (!bundleName.equals("THUMBNAIL") && !bundleName.equals("TEXT")) {
                    deleted.add(bs.getName());
                }
                this.bundleService.removeBitstream(context, b, bs);
                ItemUpdate.pr("Deleted " + bundleName + " bitstream " + bs.getName() + " with id = " + bs.getID());
            }
        }
        if (this.alterProvenance && !deleted.isEmpty()) {
            StringBuilder sb = new StringBuilder("  Bitstreams deleted on ");
            sb.append(DCDate.getCurrent()).append(": ");
            for (String s : deleted) {
                sb.append(s).append(", ");
            }
            DtoMetadata dtom = DtoMetadata.create("dc.description.provenance", "en", "");
            ItemUpdate.pr("Append provenance with: " + sb.toString());
            if (!isTest) {
                MetadataUtilities.appendMetadata(context, item, dtom, false, sb.toString());
            }
        }
    }
}

