/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.content.Item;

public class ExcelFilter
extends MediaFilter {
    private static Logger log = Logger.getLogger(ExcelFilter.class);

    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".txt";
    }

    @Override
    public String getBundleName() {
        return "TEXT";
    }

    @Override
    public String getFormatString() {
        return "Text";
    }

    @Override
    public String getDescription() {
        return "Extracted text";
    }

    @Override
    public InputStream getDestinationStream(Item item, InputStream source, boolean verbose) throws Exception {
        String extractedText = null;
        try {
            POITextExtractor theExtractor = ExtractorFactory.createExtractor((InputStream)source);
            if (theExtractor instanceof ExcelExtractor) {
                extractedText = theExtractor.getText();
            } else if (theExtractor instanceof XSSFExcelExtractor) {
                extractedText = theExtractor.getText();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error filtering bitstream: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        if (extractedText != null) {
            return IOUtils.toInputStream((String)extractedText, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }
}

