/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class Configuration {
    public static void main(String[] argv) {
        Options options = new Options();
        options.addOption("p", "property", true, "name of the desired property");
        options.addOption("m", "module", true, "optional name of the module in which 'property' exists");
        options.addOption("r", "raw", false, "do not do property substitution on the value");
        options.addOption("?", "Get help");
        options.addOption("h", "help", false, "Get help");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, argv);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        if (cmd.hasOption('?') || cmd.hasOption('h')) {
            new HelpFormatter().printHelp("dsprop [options]", "Display the value of a DSpace configuration property", options, "If --module is omitted, then --property gives the entire name of the property.  Otherwise the name is composed of module.property.");
            System.exit(0);
        }
        if (!cmd.hasOption('p')) {
            System.err.println("Error:  -p is required");
            System.exit(1);
        }
        StringBuilder propNameBuilder = new StringBuilder(1024);
        if (cmd.hasOption('m')) {
            propNameBuilder.append(cmd.getOptionValue('m')).append('.');
        }
        propNameBuilder.append(cmd.getOptionValue('p'));
        String propName = propNameBuilder.toString();
        ConfigurationService cfg = DSpaceServicesFactory.getInstance().getConfigurationService();
        if (!cfg.hasProperty(propName)) {
            System.out.println();
        } else {
            String val = cmd.hasOption('r') ? cfg.getPropertyValue(propName).toString() : cfg.getProperty(propName);
            System.out.println(val);
        }
        System.exit(0);
    }
}

