/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.log4j.Logger;
import org.dspace.services.factory.DSpaceServicesFactory;

public class ConfigurationManager {
    private static final Logger log = Logger.getLogger(ConfigurationManager.class);

    protected ConfigurationManager() {
    }

    public static boolean isConfigured() {
        return DSpaceServicesFactory.getInstance().getConfigurationService() != null;
    }

    public static Properties getProperties() {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getProperties();
    }

    public static Properties getProperties(String module) {
        Configuration subset = DSpaceServicesFactory.getInstance().getConfigurationService().getConfiguration().subset(module);
        return ConfigurationConverter.getProperties((Configuration)subset);
    }

    public static String getProperty(String property) {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getProperty(property);
    }

    public static String getProperty(String module, String property) {
        if (module == null) {
            return ConfigurationManager.getProperty(property);
        }
        return ConfigurationManager.getProperty(module + "." + property);
    }

    public static int getIntProperty(String property) {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getIntProperty(property);
    }

    public static int getIntProperty(String module, String property) {
        if (module == null) {
            return ConfigurationManager.getIntProperty(property);
        }
        return ConfigurationManager.getIntProperty(module + "." + property);
    }

    public static int getIntProperty(String property, int defaultValue) {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getIntProperty(property, defaultValue);
    }

    public static int getIntProperty(String module, String property, int defaultValue) {
        if (module == null) {
            return ConfigurationManager.getIntProperty(property, defaultValue);
        }
        return ConfigurationManager.getIntProperty(module + "." + property, defaultValue);
    }

    public static long getLongProperty(String property) {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getLongProperty(property);
    }

    public static long getLongProperty(String module, String property) {
        if (module == null) {
            return ConfigurationManager.getLongProperty(property);
        }
        return ConfigurationManager.getLongProperty(module + "." + property);
    }

    public static long getLongProperty(String property, int defaultValue) {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getLongProperty(property, (long)defaultValue);
    }

    public static long getLongProperty(String module, String property, int defaultValue) {
        if (module == null) {
            return ConfigurationManager.getLongProperty(property, defaultValue);
        }
        return ConfigurationManager.getLongProperty(module + "." + property, defaultValue);
    }

    public static boolean getBooleanProperty(String property) {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty(property);
    }

    public static boolean getBooleanProperty(String module, String property) {
        if (module == null) {
            return ConfigurationManager.getBooleanProperty(property);
        }
        return ConfigurationManager.getBooleanProperty(module + "." + property);
    }

    public static boolean getBooleanProperty(String property, boolean defaultValue) {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty(property, defaultValue);
    }

    public static boolean getBooleanProperty(String module, String property, boolean defaultValue) {
        if (module == null) {
            return ConfigurationManager.getBooleanProperty(property, defaultValue);
        }
        return ConfigurationManager.getBooleanProperty(module + "." + property, defaultValue);
    }

    public static Enumeration<?> propertyNames() {
        return Collections.enumeration(DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyKeys());
    }

    public static Enumeration<?> propertyNames(String module) {
        return Collections.enumeration(DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyKeys(module));
    }
}

