/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dspace.core.DBConnection;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.event.Dispatcher;
import org.dspace.event.Event;
import org.dspace.event.factory.EventServiceFactory;
import org.dspace.event.service.EventService;
import org.dspace.storage.rdbms.DatabaseConfigVO;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.dspace.utils.DSpace;
import org.springframework.util.CollectionUtils;

public class Context {
    private static final Logger log = Logger.getLogger(Context.class);
    public static final short READ_ONLY = 1;
    private EPerson currentUser;
    private Locale currentLocale;
    private String extraLogInfo;
    private boolean ignoreAuth;
    private Stack<Boolean> authStateChangeHistory;
    private Stack<String> authStateClassCallHistory;
    private List<UUID> specialGroups;
    private LinkedList<Event> events = null;
    private String dispName = null;
    private short options = 0;
    protected EventService eventService;
    private DBConnection dbConnection;

    protected Context(EventService eventService, DBConnection dbConnection) {
        this.eventService = eventService;
        this.dbConnection = dbConnection;
        this.init();
    }

    public Context() {
        this.init();
    }

    public Context(short options) {
        this.options = options;
        this.init();
    }

    private void init() {
        if (this.eventService == null) {
            this.eventService = EventServiceFactory.getInstance().getEventService();
        }
        if (this.dbConnection == null) {
            this.dbConnection = (DBConnection)new DSpace().getSingletonService(DBConnection.class);
            if (this.dbConnection == null) {
                log.fatal((Object)"Cannot obtain the bean which provides a database connection. Check previous entries in the dspace.log to find why the db failed to initialize.");
            }
        }
        this.currentUser = null;
        this.currentLocale = I18nUtil.DEFAULTLOCALE;
        this.extraLogInfo = "";
        this.ignoreAuth = false;
        this.specialGroups = new ArrayList<UUID>();
        this.authStateChangeHistory = new Stack();
        this.authStateClassCallHistory = new Stack();
    }

    DBConnection getDBConnection() {
        return this.dbConnection;
    }

    public DatabaseConfigVO getDBConfig() throws SQLException {
        return this.dbConnection.getDatabaseConfig();
    }

    public String getDbType() {
        return this.dbConnection.getType();
    }

    public void setCurrentUser(EPerson user) {
        this.currentUser = user;
    }

    public EPerson getCurrentUser() {
        return this.currentUser;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void setCurrentLocale(Locale locale) {
        this.currentLocale = locale;
    }

    public boolean ignoreAuthorization() {
        return this.ignoreAuth;
    }

    public void turnOffAuthorisationSystem() {
        this.authStateChangeHistory.push(this.ignoreAuth);
        if (log.isDebugEnabled()) {
            Thread currThread = Thread.currentThread();
            StackTraceElement[] stackTrace = currThread.getStackTrace();
            String caller = stackTrace[stackTrace.length - 1].getClassName();
            this.authStateClassCallHistory.push(caller);
        }
        this.ignoreAuth = true;
    }

    public void restoreAuthSystemState() {
        Boolean previousState;
        try {
            previousState = this.authStateChangeHistory.pop();
        }
        catch (EmptyStackException ex) {
            log.warn((Object)LogManager.getHeader(this, "restore_auth_sys_state", "not previous state info available " + ex.getLocalizedMessage()));
            previousState = Boolean.FALSE;
        }
        if (log.isDebugEnabled()) {
            Thread currThread = Thread.currentThread();
            StackTraceElement[] stackTrace = currThread.getStackTrace();
            String caller = stackTrace[stackTrace.length - 1].getClassName();
            String previousCaller = this.authStateClassCallHistory.pop();
            if (!previousCaller.equals(caller)) {
                log.warn((Object)LogManager.getHeader(this, "restore_auth_sys_state", "Class: " + caller + " call restore but previous state change made by " + previousCaller));
            }
        }
        this.ignoreAuth = previousState;
    }

    public void setExtraLogInfo(String info) {
        this.extraLogInfo = info;
    }

    public String getExtraLogInfo() {
        return this.extraLogInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() throws SQLException {
        if (!this.isValid()) {
            log.info((Object)"complete() was called on a closed Context object. No changes to commit.");
        }
        try {
            this.commit();
        }
        finally {
            if (this.dbConnection != null) {
                this.dbConnection.closeDBConnection();
                this.dbConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        if (!this.isValid()) {
            log.info((Object)"commit() was called on a closed Context object. No changes to commit.");
        }
        try {
            if (this.isValid() && !this.isReadOnly()) {
                this.dispatchEvents();
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache size on commit is " + this.getCacheSize()));
            }
            if (this.dbConnection != null) {
                this.dbConnection.commit();
                this.reloadContextBoundEntities();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvents() {
        Dispatcher dispatcher = null;
        try {
            if (this.events != null) {
                if (this.dispName == null) {
                    this.dispName = "default";
                }
                dispatcher = this.eventService.getDispatcher(this.dispName);
                dispatcher.dispatch(this);
            }
        }
        finally {
            this.events = null;
            if (dispatcher != null) {
                this.eventService.returnDispatcher(this.dispName, dispatcher);
            }
        }
    }

    public void setDispatcher(String dispatcher) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.toString() + ": setDispatcher(\"" + dispatcher + "\")"));
        }
        this.dispName = dispatcher;
    }

    public void addEvent(Event event) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Attempt to mutate object in read-only context");
        }
        if (this.events == null) {
            this.events = new LinkedList();
        }
        this.events.add(event);
    }

    public LinkedList<Event> getEvents() {
        return this.events;
    }

    public boolean hasEvents() {
        return !CollectionUtils.isEmpty(this.events);
    }

    public Event pollEvent() {
        if (this.hasEvents()) {
            return this.events.poll();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (!this.isValid()) {
            log.info((Object)"abort() was called on a closed Context object. No changes to abort.");
        }
        try {
            if (this.isValid() && !this.isReadOnly()) {
                this.dbConnection.rollback();
            }
        }
        catch (SQLException se) {
            log.error((Object)se.getMessage(), (Throwable)se);
        }
        finally {
            try {
                if (!this.dbConnection.isSessionAlive()) {
                    this.dbConnection.closeDBConnection();
                }
            }
            catch (Exception ex) {
                log.error((Object)"Exception aborting context", (Throwable)ex);
            }
            this.events = null;
        }
    }

    public boolean isValid() {
        return this.dbConnection != null && this.dbConnection.isTransActionAlive();
    }

    public boolean isReadOnly() {
        return (this.options & 1) > 0;
    }

    public void setSpecialGroup(UUID groupID) {
        this.specialGroups.add(groupID);
    }

    public boolean inSpecialGroup(UUID groupID) {
        return this.specialGroups.contains(groupID);
    }

    public List<Group> getSpecialGroups() throws SQLException {
        ArrayList<Group> myGroups = new ArrayList<Group>();
        for (UUID groupId : this.specialGroups) {
            myGroups.add((Group)EPersonServiceFactory.getInstance().getGroupService().find(this, groupId));
        }
        return myGroups;
    }

    protected void finalize() throws Throwable {
        if (this.dbConnection != null && this.dbConnection.isTransActionAlive()) {
            this.abort();
        }
        super.finalize();
    }

    public void shutDownDatabase() throws SQLException {
        this.dbConnection.shutdown();
    }

    public long getCacheSize() throws SQLException {
        return this.getDBConnection().getCacheSize();
    }

    public void enableBatchMode(boolean batchModeEnabled) throws SQLException {
        this.dbConnection.setOptimizedForBatchProcessing(batchModeEnabled);
    }

    public boolean isBatchModeEnabled() {
        return this.dbConnection.isOptimizedForBatchProcessing();
    }

    public <E extends ReloadableEntity> E reloadEntity(E entity) throws SQLException {
        return this.dbConnection.reloadEntity(entity);
    }

    public <E extends ReloadableEntity> void uncacheEntity(E entity) throws SQLException {
        this.dbConnection.uncacheEntity(entity);
    }

    private void reloadContextBoundEntities() throws SQLException {
        this.currentUser = this.reloadEntity(this.currentUser);
    }

    static {
        try {
            DatabaseUtils.updateDatabase();
        }
        catch (SQLException sqle) {
            log.fatal((Object)"Cannot initialize database via Flyway!", (Throwable)sqle);
        }
    }
}

