/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.apache.solr.common.util.ContentStreamBase;
import org.dspace.content.Bitstream;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;

public class BitstreamContentStream
extends ContentStreamBase {
    private static final Logger log = Logger.getLogger(BitstreamContentStream.class);
    protected final Context context;
    protected final Bitstream file;
    protected BitstreamService bitstreamService;

    public BitstreamContentStream(Context context, Bitstream f) throws SQLException {
        this.file = f;
        this.context = context;
        this.contentType = f.getFormat(context).getMIMEType();
        this.name = this.file.getName();
        this.size = this.file.getSize();
        this.sourceInfo = this.file.getName();
        this.bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentType() {
        if (this.contentType == null) {
            InputStream stream = null;
            try {
                stream = this.bitstreamService.retrieve(this.context, this.file);
                char first = (char)stream.read();
                if (first == '<') {
                    String string = "application/xml";
                    return string;
                }
                if (first == '{') {
                    String string = "application/json";
                    return string;
                }
            }
            catch (Exception ex) {
                log.error((Object)("Error determining content type for bitstream:" + this.file.getID()), (Throwable)ex);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ioe) {
                        log.error((Object)("Error closing stream:" + this.file.getID()), (Throwable)ioe);
                    }
                }
            }
        }
        return this.contentType;
    }

    public InputStream getStream() throws IOException {
        try {
            return this.bitstreamService.retrieve(this.context, this.file);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new ByteArrayInputStream(e.getMessage().getBytes(StandardCharsets.UTF_8));
        }
    }
}

