/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.embargo;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.embargo.EmbargoSetter;
import org.dspace.embargo.factory.EmbargoServiceFactory;
import org.dspace.embargo.service.EmbargoService;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.services.factory.DSpaceServicesFactory;

public class DefaultEmbargoSetter
implements EmbargoSetter {
    protected AuthorizeService authorizeService;
    protected ResourcePolicyService resourcePolicyService;

    @Override
    public DCDate parseTerms(Context context, Item item, String terms) throws SQLException, AuthorizeException {
        String termsOpen = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("embargo.terms.open");
        if (terms != null && terms.length() > 0) {
            if (termsOpen.equals(terms)) {
                return EmbargoService.FOREVER;
            }
            return new DCDate(terms);
        }
        return null;
    }

    @Override
    public void setEmbargo(Context context, Item item) throws SQLException, AuthorizeException {
        DCDate liftDate = EmbargoServiceFactory.getInstance().getEmbargoService().getEmbargoTermsAsDate(context, item);
        for (Bundle bn : item.getBundles()) {
            String bnn = bn.getName();
            if (bnn.equals("LICENSE") || bnn.equals("METADATA") || bnn.equals("CC-LICENSE")) continue;
            this.generatePolicies(context, liftDate.toDate(), null, bn, item.getOwningCollection());
            for (Bitstream bs : bn.getBitstreams()) {
                this.generatePolicies(context, liftDate.toDate(), null, bs, item.getOwningCollection());
            }
        }
    }

    protected void generatePolicies(Context context, Date embargoDate, String reason, DSpaceObject dso, Collection owningCollection) throws SQLException, AuthorizeException {
        if (embargoDate != null) {
            List<Group> authorizedGroups = this.getAuthorizeService().getAuthorizedGroups(context, owningCollection, 10);
            boolean isAnonymousInPlace = false;
            for (Group g : authorizedGroups) {
                if (!StringUtils.equals((String)g.getName(), (String)"Anonymous")) continue;
                isAnonymousInPlace = true;
            }
            if (!isAnonymousInPlace) {
                for (Group g : authorizedGroups) {
                    ResourcePolicy rp = this.getAuthorizeService().createOrModifyPolicy(null, context, null, g, null, embargoDate, 0, reason, dso);
                    if (rp == null) continue;
                    this.getResourcePolicyService().update(context, rp);
                }
            } else {
                ResourcePolicy rp = this.getAuthorizeService().createOrModifyPolicy(null, context, null, EPersonServiceFactory.getInstance().getGroupService().findByName(context, "Anonymous"), null, embargoDate, 0, reason, dso);
                if (rp != null) {
                    this.getResourcePolicyService().update(context, rp);
                }
            }
        }
    }

    @Override
    public void checkEmbargo(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        for (Bundle bn : item.getBundles()) {
            String bnn = bn.getName();
            if (bnn.equals("LICENSE") || bnn.equals("METADATA") || bnn.equals("CC-LICENSE")) continue;
            if (!bnn.equals("TEXT") && !bnn.equals("THUMBNAIL")) {
                for (ResourcePolicy rp : this.getAuthorizeService().getPoliciesActionFilter(context, bn, 0)) {
                    System.out.println("CHECK WARNING: Item " + item.getHandle() + ", Bundle " + bn.getName() + " allows READ by " + (rp.getEPerson() != null ? "Group " + rp.getGroup().getName() : "EPerson " + rp.getEPerson().getFullName()));
                }
            }
            for (Bitstream bs : bn.getBitstreams()) {
                for (ResourcePolicy rp : this.getAuthorizeService().getPoliciesActionFilter(context, bs, 0)) {
                    System.out.println("CHECK WARNING: Item " + item.getHandle() + ", Bitstream " + bs.getName() + " (in Bundle " + bn.getName() + ") allows READ by " + (rp.getEPerson() != null ? "Group " + rp.getGroup().getName() : "EPerson " + rp.getEPerson().getFullName()));
                }
            }
        }
    }

    private AuthorizeService getAuthorizeService() {
        if (this.authorizeService == null) {
            this.authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        }
        return this.authorizeService;
    }

    private ResourcePolicyService getResourcePolicyService() {
        if (this.resourcePolicyService == null) {
            this.resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
        }
        return this.resourcePolicyService;
    }
}

