/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.SupervisorService;
import org.springframework.beans.factory.annotation.Autowired;

public class SupervisorServiceImpl
implements SupervisorService {
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected ResourcePolicyService resourcePolicyService;

    protected SupervisorServiceImpl() {
    }

    @Override
    public boolean isOrder(Context context, WorkspaceItem workspaceItem, Group group) throws SQLException {
        return workspaceItem.getSupervisorGroups().contains(group);
    }

    @Override
    public void remove(Context context, WorkspaceItem workspaceItem, Group group) throws SQLException, AuthorizeException {
        workspaceItem.getSupervisorGroups().remove(group);
        Item item = workspaceItem.getItem();
        this.itemService.removeGroupPolicies(context, item, group);
    }

    @Override
    public void add(Context context, Group group, WorkspaceItem workspaceItem, int policy) throws SQLException, AuthorizeException {
        workspaceItem.getSupervisorGroups().add(group);
        group.getSupervisedItems().add(workspaceItem);
        if (policy != 0) {
            Item item = workspaceItem.getItem();
            if (policy == 1) {
                ResourcePolicy r = (ResourcePolicy)this.resourcePolicyService.create(context);
                r.setdSpaceObject(item);
                r.setGroup(group);
                r.setAction(0);
                this.resourcePolicyService.update(context, r);
                r = (ResourcePolicy)this.resourcePolicyService.create(context);
                r.setdSpaceObject(item);
                r.setGroup(group);
                r.setAction(1);
                this.resourcePolicyService.update(context, r);
                r = (ResourcePolicy)this.resourcePolicyService.create(context);
                r.setdSpaceObject(item);
                r.setGroup(group);
                r.setAction(3);
                this.resourcePolicyService.update(context, r);
            } else if (policy == 2) {
                ResourcePolicy r = (ResourcePolicy)this.resourcePolicyService.create(context);
                r.setdSpaceObject(item);
                r.setGroup(group);
                r.setAction(0);
                this.resourcePolicyService.update(context, r);
            }
        }
    }
}

