/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.dspace.content.DSpaceObject;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.handle.Handle;
import org.dspace.handle.dao.HandleDAO;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.dialect.Dialect;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.service.jdbc.dialect.internal.StandardDialectResolver;

public class HandleDAOImpl
extends AbstractHibernateDAO<Handle>
implements HandleDAO {
    private static final String HANDLE_SEQUENCE = "handle_seq";

    protected HandleDAOImpl() {
    }

    @Override
    public List<Handle> getHandlesByDSpaceObject(Context context, DSpaceObject dso) throws SQLException {
        if (dso == null) {
            return Collections.emptyList();
        }
        Query query = this.createQuery(context, "SELECT h FROM Handle h LEFT JOIN FETCH h.dso WHERE h.dso.id = :id ");
        query.setParameter("id", (Object)dso.getID());
        query.setCacheable(true);
        return this.list(query);
    }

    @Override
    public Handle findByHandle(Context context, String handle) throws SQLException {
        Query query = this.createQuery(context, "SELECT h FROM Handle h LEFT JOIN FETCH h.dso WHERE h.handle = :handle ");
        query.setParameter("handle", (Object)handle);
        query.setCacheable(true);
        return (Handle)this.uniqueResult(query);
    }

    @Override
    public List<Handle> findByPrefix(Context context, String prefix) throws SQLException {
        Criteria criteria = this.createCriteria(context, Handle.class);
        criteria.add((Criterion)Restrictions.like((String)"handle", (Object)(prefix + "%")));
        return this.list(criteria);
    }

    @Override
    public long countHandlesByPrefix(Context context, String prefix) throws SQLException {
        Criteria criteria = this.createCriteria(context, Handle.class);
        criteria.add((Criterion)Restrictions.like((String)"handle", (Object)(prefix + "%")));
        return this.countLong(criteria);
    }

    @Override
    public int updateHandlesWithNewPrefix(Context context, String newPrefix, String oldPrefix) throws SQLException {
        String hql = "UPDATE Handle set handle = concat(:newPrefix,'/',id) WHERE handle like concat(:oldPrefix,'%')";
        Query query = this.createQuery(context, hql);
        query.setString("newPrefix", newPrefix);
        query.setString("oldPrefix", oldPrefix);
        return query.executeUpdate();
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Handle"));
    }

    @Override
    public Long getNextHandleSuffix(Context context) throws SQLException {
        ReturningWork<Long> nextValReturningWork = new ReturningWork<Long>(){

            public Long execute(Connection connection) throws SQLException {
                Long nextVal = 0L;
                StandardDialectResolver dialectResolver = new StandardDialectResolver();
                Dialect dialect = dialectResolver.resolveDialect(connection.getMetaData());
                try (PreparedStatement preparedStatement = connection.prepareStatement(dialect.getSequenceNextValString(HandleDAOImpl.HANDLE_SEQUENCE));
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        nextVal = resultSet.getLong(1);
                    }
                }
                return nextVal;
            }
        };
        return (Long)this.getHibernateSession(context).doReturningWork((ReturningWork)nextValReturningWork);
    }
}

