/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import java.util.UUID;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.HarvestedItem;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.dspace.harvest.service.HarvestedItemService;

public class HarvestConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(HarvestConsumer.class);
    protected HarvestedCollectionService harvestedCollectionService;
    protected HarvestedItemService harvestedItemService;

    @Override
    public void initialize() throws Exception {
        this.harvestedItemService = HarvestServiceFactory.getInstance().getHarvestedItemService();
    }

    @Override
    public void consume(Context context, Event event) throws Exception {
        int st = event.getSubjectType();
        int et = event.getEventType();
        UUID id = event.getSubjectID();
        switch (st) {
            case 2: {
                if (et != 32) break;
                HarvestedItem hi = this.harvestedItemService.find(context, (Item)event.getSubject(context));
                if (hi != null) {
                    log.debug((Object)("Deleted item '" + id + "', also deleting associated harvested_item '" + hi.getOaiID() + "'."));
                    this.harvestedItemService.delete(context, hi);
                    break;
                }
                log.debug((Object)("Deleted item '" + id + "' and the associated harvested_item."));
                break;
            }
            case 3: {
                if (et == 32) {
                    HarvestedCollection hc = this.harvestedCollectionService.find(context, (Collection)event.getSubject(context));
                    if (hc != null) {
                        log.debug((Object)("Deleted collection '" + id + "', also deleting associated harvested_collection '" + hc.getOaiSource() + ":" + hc.getOaiSetId() + "'."));
                        this.harvestedCollectionService.delete(context, hc);
                    } else {
                        log.debug((Object)("Deleted collection '" + id + "' and the associated harvested_collection."));
                    }
                }
            }
            default: {
                log.warn((Object)("consume() got unrecognized event: " + event.toString()));
            }
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
    }

    @Override
    public void finish(Context ctx) {
    }
}

