/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.negotiation;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MediaRange {
    public static final double DEFAULT_QVALUE = 1.0;
    public static final String separators = "()<>@,;:\\\\\"/\\[\\]?={} \\t";
    public static final String token = "[\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+";
    public static final String quotedPair = "(?:\\\\[\\00-\\0177])";
    public static final String qdtext = "(?:[\\040\\041\\043-\\0176\\0178-\\0377]|(?:\\r\\n)?[ \\t]+)";
    public static final String quotedString = "(?:\"(?:(?:[\\040\\041\\043-\\0176\\0178-\\0377]|(?:\\r\\n)?[ \\t]+)|(?:\\\\[\\00-\\0177]))*\")";
    public static final String nonQualityParam = "(?:\\s*;\\s*(?!q\\s*=)([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+)=([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+|(?:\"(?:(?:[\\040\\041\\043-\\0176\\0178-\\0377]|(?:\\r\\n)?[ \\t]+)|(?:\\\\[\\00-\\0177]))*\")))";
    public static final String qualityParam = "(?:;\\s*q\\s*=\\s*(0(?:\\.\\d{0,3})?|1(?:\\.0{0,3})?))";
    public static final String mediaRangeRegex = "(?:([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+)/([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+?)((?:\\s*;\\s*(?!q\\s*=)([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+)=([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+|(?:\"(?:(?:[\\040\\041\\043-\\0176\\0178-\\0377]|(?:\\r\\n)?[ \\t]+)|(?:\\\\[\\00-\\0177]))*\")))*)(?:;\\s*q\\s*=\\s*(0(?:\\.\\d{0,3})?|1(?:\\.0{0,3})?))?((?:\\s*;\\s*(?!q\\s*=)([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+)=([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+|(?:\"(?:(?:[\\040\\041\\043-\\0176\\0178-\\0377]|(?:\\r\\n)?[ \\t]+)|(?:\\\\[\\00-\\0177]))*\")))*))";
    private static final Logger log = Logger.getLogger(MediaRange.class);
    protected final String type;
    protected final String subtype;
    protected final double qvalue;
    protected final List<String> parameterNames;
    protected final List<String> parameterValues;

    private MediaRange() {
        throw new RuntimeException("Default constructor of MediaRange must not be called. Use static methods instead.");
    }

    public MediaRange(String mediarange) throws IllegalArgumentException, IllegalStateException {
        Pattern mediaRangePattern = Pattern.compile("^(?:([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+)/([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+?)((?:\\s*;\\s*(?!q\\s*=)([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+)=([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+|(?:\"(?:(?:[\\040\\041\\043-\\0176\\0178-\\0377]|(?:\\r\\n)?[ \\t]+)|(?:\\\\[\\00-\\0177]))*\")))*)(?:;\\s*q\\s*=\\s*(0(?:\\.\\d{0,3})?|1(?:\\.0{0,3})?))?((?:\\s*;\\s*(?!q\\s*=)([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+)=([\\040-\\0176&&[^()<>@,;:\\\\\"/\\[\\]?={} \\t]]+|(?:\"(?:(?:[\\040\\041\\043-\\0176\\0178-\\0377]|(?:\\r\\n)?[ \\t]+)|(?:\\\\[\\00-\\0177]))*\")))*))$");
        Matcher rangeMatcher = mediaRangePattern.matcher(mediarange.trim());
        if (!rangeMatcher.matches()) {
            log.warn((Object)("Provided media range ('" + mediarange.trim() + "') " + "does not comply with RFC 2616."));
            throw new IllegalArgumentException("Provided media range ('" + mediarange + "') does not comply with RFC 2616.");
        }
        String type = rangeMatcher.group(1);
        String subtype = rangeMatcher.group(2);
        if (StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)subtype)) {
            throw new IllegalArgumentException("A media range had an unparsable type or subtype.");
        }
        type = type.trim().toLowerCase();
        subtype = subtype.trim().toLowerCase();
        if (type.equals("*") && !subtype.equals("*")) {
            throw new IllegalArgumentException("A media range's type cannot be wildcarded if its subtype isn't as well.");
        }
        double qvalue = 1.0;
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList<String> parameterValues = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)rangeMatcher.group(6))) {
            try {
                qvalue = Double.parseDouble(rangeMatcher.group(6));
            }
            catch (NumberFormatException ex) {
                log.fatal((Object)("A quality value ('" + rangeMatcher.group(6) + "') " + "was unparsable. We probably have a problem with our " + "regex!"), (Throwable)ex);
                throw new IllegalStateException(ex);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)rangeMatcher.group(3))) {
            sb.append(rangeMatcher.group(3));
        }
        if (!StringUtils.isEmpty((String)rangeMatcher.group(7))) {
            sb.append(rangeMatcher.group(7));
        }
        if (sb.length() > 0) {
            String unparsedParameters = sb.toString();
            Pattern paramPattern = Pattern.compile(nonQualityParam);
            Matcher m = paramPattern.matcher(unparsedParameters);
            if (!m.matches()) {
                log.fatal((Object)("Unable to parse the parameters ('" + unparsedParameters + "') of a previously parsed media " + "range!"));
                throw new IllegalStateException("Run into problems while parsing a substring of a previuosly succesfully parsed string.");
            }
            while (m.find()) {
                if (StringUtils.isEmpty((String)m.group(1))) continue;
                parameterNames.add(m.group(1).trim().toLowerCase());
                parameterValues.add(StringUtils.isEmpty((String)m.group(2)) ? "" : m.group(2).trim());
            }
        }
        this.type = type;
        this.subtype = subtype;
        this.qvalue = qvalue;
        this.parameterNames = parameterNames;
        this.parameterValues = parameterValues;
    }

    public double getQvalue() {
        return this.qvalue;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public List<String> getParameterValues() {
        return this.parameterValues;
    }

    public boolean typeIsWildcard() {
        return StringUtils.equals((String)this.type, (String)"*");
    }

    public boolean subtypeIsWildcard() {
        return StringUtils.equals((String)this.subtype, (String)"*");
    }
}

