/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.mail.MessagingException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.curate.service.WorkflowCuratorService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageWorkflowEvent;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.TaskListItem;
import org.dspace.workflowbasic.service.BasicWorkflowItemService;
import org.dspace.workflowbasic.service.BasicWorkflowService;
import org.dspace.workflowbasic.service.TaskListItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class BasicWorkflowServiceImpl
implements BasicWorkflowService {
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected InstallItemService installItemService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected TaskListItemService taskListItemService;
    @Autowired(required=true)
    protected WorkflowCuratorService workflowCuratorService;
    @Autowired(required=true)
    protected BasicWorkflowItemService workflowItemService;
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;
    protected final String[] workflowText = new String[]{"SUBMIT", "STEP1POOL", "STEP1", "STEP2POOL", "STEP2", "STEP3POOL", "STEP3", "ARCHIVE"};
    protected Map<UUID, Boolean> noEMail = new HashMap<UUID, Boolean>();
    private final Logger log = Logger.getLogger(BasicWorkflowServiceImpl.class);

    protected BasicWorkflowServiceImpl() {
    }

    @Override
    public int getWorkflowID(String state) {
        for (int i = 0; i < this.workflowText.length; ++i) {
            if (!state.equalsIgnoreCase(this.workflowText[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addInitialWorkspaceItemPolicies(Context context, WorkspaceItem workspaceItem) throws SQLException, AuthorizeException {
        Collection collection = workspaceItem.getCollection();
        Group step1group = this.collectionService.getWorkflowGroup(collection, 1);
        Group step2group = this.collectionService.getWorkflowGroup(collection, 2);
        Group step3group = this.collectionService.getWorkflowGroup(collection, 3);
        Item item = workspaceItem.getItem();
        if (step1group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 0, step1group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step2group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 0, step2group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step3group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 0, step3group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step1group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 1, step1group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step2group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 1, step2group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step3group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 1, step3group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step1group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 3, step1group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step2group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 3, step2group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step3group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 3, step3group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step1group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 4, step1group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step2group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 4, step2group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step3group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 4, step3group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step1group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 2, step1group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step2group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 2, step2group, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (step3group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 2, step3group, ResourcePolicy.TYPE_WORKFLOW);
        }
    }

    @Override
    public BasicWorkflowItem start(Context context, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException {
        Item myitem = wsi.getItem();
        Collection collection = wsi.getCollection();
        this.log.info((Object)LogManager.getHeader(context, "start_workflow", "workspace_item_id=" + wsi.getID() + "item_id=" + myitem.getID() + "collection_id=" + collection.getID()));
        this.recordStart(context, myitem);
        BasicWorkflowItem wfi = (BasicWorkflowItem)this.workflowItemService.create(context, myitem, collection);
        wfi.setMultipleFiles(wsi.hasMultipleFiles());
        wfi.setMultipleTitles(wsi.hasMultipleTitles());
        wfi.setPublishedBefore(wsi.isPublishedBefore());
        this.workspaceItemService.deleteWrapper(context, wsi);
        wfi.setState(0);
        this.advance(context, wfi, null);
        return wfi;
    }

    @Override
    public BasicWorkflowItem startWithoutNotify(Context c, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException {
        this.noEMail.put(wsi.getItem().getID(), Boolean.TRUE);
        return this.start(c, wsi);
    }

    @Override
    public List<BasicWorkflowItem> getOwnedTasks(Context context, EPerson e) throws SQLException {
        return this.workflowItemService.findByOwner(context, e);
    }

    @Override
    public List<BasicWorkflowItem> getPooledTasks(Context context, EPerson e) throws SQLException {
        return this.workflowItemService.findPooledTasks(context, e);
    }

    @Override
    public void claim(Context context, BasicWorkflowItem workflowItem, EPerson e) throws SQLException, IOException, AuthorizeException {
        int taskstate = workflowItem.getState();
        switch (taskstate) {
            case 1: {
                this.doState(context, workflowItem, 2, e);
                break;
            }
            case 3: {
                this.doState(context, workflowItem, 4, e);
                break;
            }
            case 5: {
                this.doState(context, workflowItem, 6, e);
            }
        }
        this.log.info((Object)LogManager.getHeader(context, "claim_task", "workflow_item_id=" + workflowItem.getID() + "item_id=" + workflowItem.getItem().getID() + "collection_id=" + workflowItem.getCollection().getID() + "newowner_id=" + workflowItem.getOwner().getID() + "old_state=" + taskstate + "new_state=" + workflowItem.getState()));
    }

    @Override
    public void advance(Context context, BasicWorkflowItem workflowItem, EPerson e) throws SQLException, IOException, AuthorizeException {
        this.advance(context, workflowItem, e, true, true);
    }

    @Override
    public boolean advance(Context context, BasicWorkflowItem workflowItem, EPerson e, boolean curate, boolean record) throws SQLException, IOException, AuthorizeException {
        int taskstate = workflowItem.getState();
        boolean archived = false;
        if (curate && this.workflowCuratorService.needsCuration(workflowItem) && !this.workflowCuratorService.doCuration(context, workflowItem)) {
            this.log.info((Object)LogManager.getHeader(context, "advance_workflow", "workflow_item_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID() + ",collection_id=" + workflowItem.getCollection().getID() + ",old_state=" + taskstate + ",doCuration=false"));
            return false;
        }
        switch (taskstate) {
            case 0: {
                archived = this.doState(context, workflowItem, 1, e);
                break;
            }
            case 2: {
                if (record) {
                    this.recordApproval(context, workflowItem, e);
                }
                archived = this.doState(context, workflowItem, 3, e);
                break;
            }
            case 4: {
                if (record) {
                    this.recordApproval(context, workflowItem, e);
                }
                archived = this.doState(context, workflowItem, 5, e);
                break;
            }
            case 6: {
                archived = this.doState(context, workflowItem, 7, e);
            }
        }
        this.log.info((Object)LogManager.getHeader(context, "advance_workflow", "workflow_item_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID() + ",collection_id=" + workflowItem.getCollection().getID() + ",old_state=" + taskstate + ",new_state=" + workflowItem.getState()));
        return archived;
    }

    @Override
    public void unclaim(Context context, BasicWorkflowItem workflowItem, EPerson e) throws SQLException, IOException, AuthorizeException {
        int taskstate = workflowItem.getState();
        switch (taskstate) {
            case 2: {
                this.doState(context, workflowItem, 1, e);
                break;
            }
            case 4: {
                this.doState(context, workflowItem, 3, e);
                break;
            }
            case 6: {
                this.doState(context, workflowItem, 5, e);
            }
        }
        this.log.info((Object)LogManager.getHeader(context, "unclaim_workflow", "workflow_item_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID() + ",collection_id=" + workflowItem.getCollection().getID() + ",old_state=" + taskstate + ",new_state=" + workflowItem.getState()));
    }

    @Override
    public WorkspaceItem abort(Context context, BasicWorkflowItem workflowItem, EPerson e) throws SQLException, AuthorizeException, IOException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to abort a workflow");
        }
        this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
        this.log.info((Object)LogManager.getHeader(context, "abort_workflow", "workflow_item_id=" + workflowItem.getID() + "item_id=" + workflowItem.getItem().getID() + "collection_id=" + workflowItem.getCollection().getID() + "eperson_id=" + e.getID()));
        return this.returnToWorkspace(context, workflowItem);
    }

    protected boolean doState(Context context, BasicWorkflowItem workflowItem, int newstate, EPerson newowner) throws SQLException, IOException, AuthorizeException {
        Collection mycollection = workflowItem.getCollection();
        Group mygroup = null;
        boolean archived = false;
        int oldState = workflowItem.getState();
        EPerson oldOwner = workflowItem.getOwner();
        workflowItem.setState(newstate);
        switch (newstate) {
            case 1: {
                workflowItem.setOwner(null);
                mygroup = this.collectionService.getWorkflowGroup(mycollection, 1);
                if (mygroup != null && !this.groupService.isEmpty(mygroup)) {
                    List<EPerson> epa = this.groupService.allMembers(context, mygroup);
                    this.createTasks(context, workflowItem, epa);
                    this.workflowItemService.update(context, workflowItem);
                    if (!ConfigurationManager.getBooleanProperty("workflow", "notify.returned.tasks", true) && oldState == 2 && oldOwner != null) break;
                    this.notifyGroupOfTask(context, workflowItem, mygroup, epa);
                    break;
                }
                workflowItem.setState(2);
                archived = this.advance(context, workflowItem, null, true, false);
                break;
            }
            case 2: {
                this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
                workflowItem.setOwner(newowner);
                break;
            }
            case 3: {
                workflowItem.setOwner(null);
                mygroup = this.collectionService.getWorkflowGroup(mycollection, 2);
                if (mygroup != null && !this.groupService.isEmpty(mygroup)) {
                    List<EPerson> epa = this.groupService.allMembers(context, mygroup);
                    this.createTasks(context, workflowItem, epa);
                    if (!ConfigurationManager.getBooleanProperty("workflow", "notify.returned.tasks", true) && oldState == 4 && oldOwner != null) break;
                    this.notifyGroupOfTask(context, workflowItem, mygroup, epa);
                    break;
                }
                workflowItem.setState(4);
                archived = this.advance(context, workflowItem, null, true, false);
                break;
            }
            case 4: {
                this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
                workflowItem.setOwner(newowner);
                break;
            }
            case 5: {
                workflowItem.setOwner(null);
                mygroup = this.collectionService.getWorkflowGroup(mycollection, 3);
                if (mygroup != null && !this.groupService.isEmpty(mygroup)) {
                    List<EPerson> epa = this.groupService.allMembers(context, mygroup);
                    this.createTasks(context, workflowItem, epa);
                    if (!ConfigurationManager.getBooleanProperty("workflow", "notify.returned.tasks", true) && oldState == 6 && oldOwner != null) break;
                    this.notifyGroupOfTask(context, workflowItem, mygroup, epa);
                    break;
                }
                workflowItem.setState(6);
                archived = this.advance(context, workflowItem, null, true, false);
                break;
            }
            case 6: {
                this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
                workflowItem.setOwner(newowner);
                break;
            }
            case 7: {
                this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
                mycollection = workflowItem.getCollection();
                Item myitem = this.archive(context, workflowItem);
                this.notifyOfArchive(context, myitem, mycollection);
                archived = true;
            }
        }
        this.logWorkflowEvent(context, workflowItem.getItem(), workflowItem, context.getCurrentUser(), newstate, newowner, mycollection, oldState, mygroup);
        if (!archived) {
            this.workflowItemService.update(context, workflowItem);
        }
        return archived;
    }

    protected void logWorkflowEvent(Context context, Item item, BasicWorkflowItem workflowItem, EPerson actor, int newstate, EPerson newOwner, Collection mycollection, int oldState, Group newOwnerGroup) {
        if (newstate == 7 || newstate == 1 || newstate == 3 || newstate == 5) {
            newOwner = null;
        }
        UsageWorkflowEvent usageWorkflowEvent = new UsageWorkflowEvent(context, item, workflowItem, this.workflowText[newstate], this.workflowText[oldState], mycollection, actor);
        if (newOwner != null) {
            usageWorkflowEvent.setEpersonOwners(newOwner);
        }
        if (newOwnerGroup != null) {
            usageWorkflowEvent.setGroupOwners(newOwnerGroup);
        }
        DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)usageWorkflowEvent);
    }

    @Override
    public String getWorkflowText(int state) {
        if (state > -1 && state < this.workflowText.length) {
            return this.workflowText[state];
        }
        throw new IllegalArgumentException("Invalid workflow state passed");
    }

    @Override
    public Item archive(Context context, BasicWorkflowItem workflowItem) throws SQLException, IOException, AuthorizeException {
        Item item = workflowItem.getItem();
        Collection collection = workflowItem.getCollection();
        this.log.info((Object)LogManager.getHeader(context, "archive_item", "workflow_item_id=" + workflowItem.getID() + "item_id=" + item.getID() + "collection_id=" + collection.getID()));
        this.installItemService.installItem(context, workflowItem);
        this.log.info((Object)LogManager.getHeader(context, "install_item", "workflow_id=" + workflowItem.getID() + ", item_id=" + item.getID() + "handle=FIXME"));
        return item;
    }

    protected void notifyOfArchive(Context context, Item item, Collection coll) throws SQLException, IOException {
        try {
            EPerson ep = item.getSubmitter();
            Locale supportedLocale = I18nUtil.getEPersonLocale(ep);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_archive"));
            String handle = this.handleService.findHandle(context, item);
            String title = item.getName();
            if (StringUtils.isBlank((String)title)) {
                try {
                    title = I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled");
                }
                catch (MissingResourceException e) {
                    title = "Untitled";
                }
            }
            email.addRecipient(ep.getEmail());
            email.addArgument(title);
            email.addArgument(coll.getName());
            email.addArgument(this.handleService.getCanonicalForm(handle));
            email.send();
        }
        catch (MessagingException e) {
            this.log.warn((Object)LogManager.getHeader(context, "notifyOfArchive", "cannot email user; item_id=" + item.getID() + ":  " + e.getMessage()));
        }
    }

    protected WorkspaceItem returnToWorkspace(Context c, BasicWorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        WorkspaceItem workspaceItem = this.workspaceItemService.create(c, wfi);
        workspaceItem.setMultipleFiles(wfi.hasMultipleFiles());
        workspaceItem.setMultipleTitles(wfi.hasMultipleTitles());
        workspaceItem.setPublishedBefore(wfi.isPublishedBefore());
        this.workspaceItemService.update(c, workspaceItem);
        this.log.info((Object)LogManager.getHeader(c, "return_to_workspace", "workflow_item_id=" + wfi.getID() + "workspace_item_id=" + workspaceItem.getID()));
        this.workflowItemService.deleteWrapper(c, wfi);
        return workspaceItem;
    }

    @Override
    public WorkspaceItem sendWorkflowItemBackSubmission(Context context, BasicWorkflowItem workflowItem, EPerson ePerson, String provenancePrefix, String rejection_message) throws SQLException, AuthorizeException, IOException {
        int oldState = workflowItem.getState();
        this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
        Item myitem = workflowItem.getItem();
        String now = DCDate.getCurrent().toString();
        String usersName = this.getEPersonName(ePerson);
        String provDescription = "Rejected by " + usersName + ", reason: " + rejection_message + " on " + now + " (GMT) ";
        this.itemService.addMetadata(context, myitem, "dc", "description", "provenance", "en", provDescription);
        this.itemService.update(context, myitem);
        WorkspaceItem wsi = this.returnToWorkspace(context, workflowItem);
        this.notifyOfReject(context, workflowItem, ePerson, rejection_message);
        this.log.info((Object)LogManager.getHeader(context, "reject_workflow", "workflow_item_id=" + workflowItem.getID() + "item_id=" + workflowItem.getItem().getID() + "collection_id=" + workflowItem.getCollection().getID() + "eperson_id=" + ePerson.getID()));
        this.logWorkflowEvent(context, wsi.getItem(), workflowItem, ePerson, 0, null, wsi.getCollection(), oldState, null);
        return wsi;
    }

    protected void createTasks(Context c, BasicWorkflowItem wi, List<EPerson> epa) throws SQLException {
        for (EPerson anEpa : epa) {
            this.taskListItemService.create(c, wi, anEpa);
        }
    }

    @Override
    public void notifyOfCuration(Context c, BasicWorkflowItem wi, List<EPerson> ePeople, String taskName, String action, String message) throws SQLException, IOException {
        try {
            String title = this.getItemTitle(wi);
            String submitter = this.getSubmitterName(wi);
            Collection coll = wi.getCollection();
            for (EPerson epa : ePeople) {
                Locale supportedLocale = I18nUtil.getEPersonLocale(epa);
                Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "flowtask_notify"));
                email.addArgument(title);
                email.addArgument(coll.getName());
                email.addArgument(submitter);
                email.addArgument(taskName);
                email.addArgument(message);
                email.addArgument(action);
                email.addRecipient(epa.getEmail());
                email.send();
            }
        }
        catch (MessagingException e) {
            this.log.warn((Object)LogManager.getHeader(c, "notifyOfCuration", "cannot email users of workflow_item_id " + wi.getID() + ":  " + e.getMessage()));
        }
    }

    protected void notifyGroupOfTask(Context c, BasicWorkflowItem wi, Group mygroup, List<EPerson> epa) throws SQLException, IOException {
        UUID myID = wi.getItem().getID();
        if (this.noEMail.containsKey(myID)) {
            this.noEMail.remove(myID);
        } else {
            try {
                String title = this.getItemTitle(wi);
                String submitter = this.getSubmitterName(wi);
                Collection coll = wi.getCollection();
                String message = "";
                for (EPerson anEpa : epa) {
                    Locale supportedLocale = I18nUtil.getEPersonLocale(anEpa);
                    Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_task"));
                    email.addArgument(title);
                    email.addArgument(coll.getName());
                    email.addArgument(submitter);
                    ResourceBundle messages = ResourceBundle.getBundle("Messages", supportedLocale);
                    switch (wi.getState()) {
                        case 1: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step1");
                            break;
                        }
                        case 3: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step2");
                            break;
                        }
                        case 5: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step3");
                        }
                    }
                    email.addArgument(message);
                    email.addArgument(this.getMyDSpaceLink());
                    email.addRecipient(anEpa.getEmail());
                    email.send();
                }
            }
            catch (MessagingException e) {
                String gid = mygroup != null ? String.valueOf(mygroup.getID()) : "none";
                this.log.warn((Object)LogManager.getHeader(c, "notifyGroupofTask", "cannot email user group_id=" + gid + " workflow_item_id=" + wi.getID() + ":  " + e.getMessage()));
            }
        }
    }

    @Override
    public String getMyDSpaceLink() {
        return ConfigurationManager.getProperty("dspace.url") + "/mydspace";
    }

    protected void notifyOfReject(Context context, BasicWorkflowItem workflowItem, EPerson e, String reason) {
        try {
            String title = this.getItemTitle(workflowItem);
            Collection coll = workflowItem.getCollection();
            String rejector = this.getEPersonName(e);
            Locale supportedLocale = I18nUtil.getEPersonLocale(e);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_reject"));
            email.addRecipient(workflowItem.getSubmitter().getEmail());
            email.addArgument(title);
            email.addArgument(coll.getName());
            email.addArgument(rejector);
            email.addArgument(reason);
            email.addArgument(this.getMyDSpaceLink());
            email.send();
        }
        catch (RuntimeException re) {
            this.log.warn((Object)LogManager.getHeader(context, "notify_of_reject", "cannot email user eperson_id=" + e.getID() + " eperson_email=" + e.getEmail() + " workflow_item_id=" + workflowItem.getID() + ":  " + re.getMessage()));
            throw re;
        }
        catch (Exception ex) {
            this.log.warn((Object)LogManager.getHeader(context, "notify_of_reject", "cannot email user eperson_id=" + e.getID() + " eperson_email=" + e.getEmail() + " workflow_item_id=" + workflowItem.getID() + ":  " + ex.getMessage()));
        }
    }

    @Override
    public String getItemTitle(BasicWorkflowItem wi) throws SQLException {
        Item myitem = wi.getItem();
        String title = myitem.getName();
        if (StringUtils.isNotBlank((String)title)) {
            return title;
        }
        return I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled ");
    }

    @Override
    public String getSubmitterName(BasicWorkflowItem wi) throws SQLException {
        EPerson e = wi.getSubmitter();
        return this.getEPersonName(e);
    }

    protected String getEPersonName(EPerson e) throws SQLException {
        String submitter = e.getFullName();
        submitter = submitter + " (" + e.getEmail() + ")";
        return submitter;
    }

    protected void recordApproval(Context context, BasicWorkflowItem workflowItem, EPerson e) throws SQLException, IOException, AuthorizeException {
        Item item = workflowItem.getItem();
        String usersName = this.getEPersonName(e);
        String now = DCDate.getCurrent().toString();
        String provDescription = "Approved for entry into archive by " + usersName + " on " + now + " (GMT) ";
        provDescription = provDescription + this.installItemService.getBitstreamProvenanceMessage(context, item);
        this.itemService.addMetadata(context, item, "dc", "description", "provenance", "en", provDescription);
        this.itemService.update(context, item);
    }

    protected void recordStart(Context context, Item myitem) throws SQLException, IOException, AuthorizeException {
        DCDate now = DCDate.getCurrent();
        String provmessage = myitem.getSubmitter() != null ? "Submitted by " + myitem.getSubmitter().getFullName() + " (" + myitem.getSubmitter().getEmail() + ") on " + now.toString() + "\n" : "Submitted by unknown (probably automated) on" + now.toString() + "\n";
        provmessage = provmessage + this.installItemService.getBitstreamProvenanceMessage(context, myitem);
        this.itemService.addMetadata(context, myitem, "dc", "description", "provenance", "en", provmessage);
        this.itemService.update(context, myitem);
    }

    @Override
    public void deleteCollection(Context context, Collection collection) throws SQLException, IOException, AuthorizeException {
        collection.setWorkflowGroup(1, null);
        collection.setWorkflowGroup(2, null);
        collection.setWorkflowGroup(3, null);
        this.workflowItemService.deleteByCollection(context, collection);
    }

    @Override
    public List<String> getEPersonDeleteConstraints(Context context, EPerson ePerson) throws SQLException {
        List<TaskListItem> taskListItems;
        ArrayList<String> resultList = new ArrayList<String>();
        List<BasicWorkflowItem> workflowItems = this.workflowItemService.findByOwner(context, ePerson);
        if (CollectionUtils.isNotEmpty(workflowItems)) {
            resultList.add("workflowitem");
        }
        if (CollectionUtils.isNotEmpty(taskListItems = this.taskListItemService.findByEPerson(context, ePerson))) {
            resultList.add("tasklistitem");
        }
        return resultList;
    }

    @Override
    public Group getWorkflowRoleGroup(Context context, Collection collection, String roleName, Group roleGroup) throws SQLException, AuthorizeException {
        if ("WF_STEP1".equals(roleName)) {
            roleGroup = collection.getWorkflowStep1();
            if (roleGroup == null) {
                roleGroup = this.collectionService.createWorkflowGroup(context, collection, 1);
            }
        } else if ("WF_STEP2".equals(roleName)) {
            roleGroup = collection.getWorkflowStep2();
            if (roleGroup == null) {
                roleGroup = this.collectionService.createWorkflowGroup(context, collection, 2);
            }
        } else if ("WF_STEP3".equals(roleName) && (roleGroup = collection.getWorkflowStep3()) == null) {
            roleGroup = this.collectionService.createWorkflowGroup(context, collection, 3);
        }
        return roleGroup;
    }

    @Override
    public List<String> getFlywayMigrationLocations() {
        return Collections.emptyList();
    }
}

