/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.migration;

import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class RestartWorkflow {
    private static Logger log = Logger.getLogger(RestartWorkflow.class);
    public static boolean useWorkflowSendEmail = false;
    private static final EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    public static void main(String[] args) {
        try {
            System.out.println("All workflowitems will be sent back to the first workflow step.");
            Context context = new Context();
            context.turnOffAuthorisationSystem();
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("e", "eperson", true, "email of eperson doing importing");
            options.addOption("n", "notify", false, "if sending submissions through the workflow, send notification emails");
            options.addOption("p", "provenance", true, "the provenance description to be added to the item");
            options.addOption("h", "help", false, "help");
            CommandLine line = parser.parse(options, args);
            String eperson = null;
            if (line.hasOption('h')) {
                HelpFormatter myhelp = new HelpFormatter();
                myhelp.printHelp("RestartWorkflow\n", options);
                System.exit(0);
            }
            if (line.hasOption('n')) {
                useWorkflowSendEmail = true;
            }
            if (line.hasOption('e')) {
                eperson = line.getOptionValue('e');
            } else {
                System.out.println("The -e (eperson) option is mandatory !");
                System.exit(1);
            }
            EPerson myEPerson = null;
            myEPerson = eperson.indexOf(64) != -1 ? ePersonService.findByEmail(context, eperson) : (EPerson)ePersonService.find(context, UUID.fromString(eperson));
            if (myEPerson == null) {
                System.out.println("Error, eperson cannot be found: " + eperson);
                System.exit(1);
            }
            String provenance = null;
            if (line.hasOption('p')) {
                provenance = line.getOptionValue('p');
            }
            context.setCurrentUser(myEPerson);
            System.out.println("Sending all workflow items back to the workspace");
            WorkflowServiceFactory workflowServiceFactory = WorkflowServiceFactory.getInstance();
            List workflowItems = workflowServiceFactory.getWorkflowItemService().findAll(context);
            WorkflowService workflowService = workflowServiceFactory.getWorkflowService();
            int i = 0;
            for (WorkflowItem workflowItem : workflowItems) {
                System.out.println("Processing workflow item " + i + " of " + workflowItems.size());
                System.out.println("Removing pooled tasks");
                Item myitem = workflowItem.getItem();
                WorkspaceItem wsi = workflowService.sendWorkflowItemBackSubmission(context, workflowItem, myEPerson, provenance, "");
                log.info((Object)LogManager.getHeader(context, "restart_workflow", "workflow_item_id=" + workflowItem.getID() + "item_id=" + workflowItem.getItem().getID() + "collection_id=" + workflowItem.getCollection().getID()));
                if (useWorkflowSendEmail) {
                    workflowService.start(context, wsi);
                } else {
                    workflowService.startWithoutNotify(context, wsi);
                }
                ++i;
            }
            System.out.println("All done, committing context");
            context.complete();
            System.exit(0);
        }
        catch (Exception e) {
            log.error((Object)"Error while sending all workflow items back to the workspace", (Throwable)e);
            e.printStackTrace();
        }
    }
}

