/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

public class CommunityFiliator {
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public static void main(String[] argv) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("s", "set", false, "set a parent/child relationship");
        options.addOption("r", "remove", false, "remove a parent/child relationship");
        options.addOption("p", "parent", true, "parent community (handle or database ID)");
        options.addOption("c", "child", true, "child community (handle or databaseID)");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, argv);
        String command = null;
        String parentID = null;
        String childID = null;
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("CommunityFiliator\n", options);
            System.out.println("\nestablish a relationship: CommunityFiliator -s -p parentID -c childID");
            System.out.println("remove a relationship: CommunityFiliator -r -p parentID -c childID");
            System.exit(0);
        }
        if (line.hasOption('s')) {
            command = "set";
        }
        if (line.hasOption('r')) {
            command = "remove";
        }
        if (line.hasOption('p')) {
            parentID = line.getOptionValue('p');
        }
        if (line.hasOption('c')) {
            childID = line.getOptionValue('c');
        }
        if (command == null) {
            System.out.println("Error - must run with either set or remove (run with -h flag for details)");
            System.exit(1);
        }
        if ("set".equals(command) || "remove".equals(command)) {
            if (parentID == null) {
                System.out.println("Error - a parentID must be specified (run with -h flag for details)");
                System.exit(1);
            }
            if (childID == null) {
                System.out.println("Error - a childID must be specified (run with -h flag for details)");
                System.exit(1);
            }
        }
        CommunityFiliator filiator = new CommunityFiliator();
        Context c = new Context();
        c.turnOffAuthorisationSystem();
        try {
            Community parent = filiator.resolveCommunity(c, parentID);
            Community child = filiator.resolveCommunity(c, childID);
            if (parent == null) {
                System.out.println("Error, parent community cannot be found: " + parentID);
                System.exit(1);
            }
            if (child == null) {
                System.out.println("Error, child community cannot be found: " + childID);
                System.exit(1);
            }
            if ("set".equals(command)) {
                filiator.filiate(c, parent, child);
            } else {
                filiator.defiliate(c, parent, child);
            }
        }
        catch (SQLException sqlE) {
            System.out.println("Error - SQL exception: " + sqlE.toString());
        }
        catch (AuthorizeException authE) {
            System.out.println("Error - Authorize exception: " + authE.toString());
        }
        catch (IOException ioE) {
            System.out.println("Error - IO exception: " + ioE.toString());
        }
    }

    public void filiate(Context c, Community parent, Community child) throws SQLException, AuthorizeException, IOException {
        Community childDad;
        Community community = childDad = CollectionUtils.isNotEmpty(child.getParentCommunities()) ? child.getParentCommunities().iterator().next() : null;
        if (childDad != null) {
            System.out.println("Error, child community: " + child.getID() + " already a child of: " + childDad.getID());
            System.exit(1);
        }
        List<Community> parentDads = parent.getParentCommunities();
        for (int i = 0; i < parentDads.size(); ++i) {
            if (!parentDads.get(i).getID().equals(child.getID())) continue;
            System.out.println("Error, circular parentage - child is parent of parent");
            System.exit(1);
        }
        this.communityService.addSubcommunity(c, parent, child);
        c.complete();
        System.out.println("Filiation complete. Community: '" + parent.getID() + "' is parent of community: '" + child.getID() + "'");
    }

    public void defiliate(Context c, Community parent, Community child) throws SQLException, AuthorizeException, IOException {
        List<Community> parentKids = parent.getSubcommunities();
        boolean isChild = false;
        for (int i = 0; i < parentKids.size(); ++i) {
            if (!parentKids.get(i).getID().equals(child.getID())) continue;
            isChild = true;
            break;
        }
        if (!isChild) {
            System.out.println("Error, child community not a child of parent community");
            System.exit(1);
        }
        child.getParentCommunities().remove(parent);
        parent.getSubcommunities().remove(child);
        this.communityService.update(c, child);
        this.communityService.update(c, parent);
        c.complete();
        System.out.println("Defiliation complete. Community: '" + child.getID() + "' is no longer a child of community: '" + parent.getID() + "'");
    }

    protected Community resolveCommunity(Context c, String communityID) throws SQLException {
        Community community = null;
        if (communityID.indexOf(47) != -1) {
            community = (Community)this.handleService.resolveToObject(c, communityID);
            if (community == null || community.getType() != 4) {
                community = null;
            }
        } else {
            community = (Community)this.communityService.find(c, UUID.fromString(communityID));
        }
        return community;
    }
}

