/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.opensearch.OpenSearchModule;
import com.sun.syndication.feed.module.opensearch.entity.OSQuery;
import com.sun.syndication.feed.module.opensearch.impl.OpenSearchModuleImpl;
import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.app.util.SyndicationFeed;
import org.dspace.app.util.service.OpenSearchService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class OpenSearchServiceImpl
implements OpenSearchService,
InitializingBean {
    private static final Logger log = Logger.getLogger(OpenSearchServiceImpl.class);
    protected boolean enabled = false;
    protected List<String> formats = null;
    protected final String osNs = "http://a9.com/-/spec/opensearch/1.1/";
    protected String uiUrl = null;
    protected String svcUrl = null;
    @Autowired(required=true)
    protected HandleService handleService;

    protected OpenSearchServiceImpl() {
    }

    public void afterPropertiesSet() throws Exception {
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.enabled = config.getBooleanProperty("websvc.opensearch.enable");
        this.svcUrl = config.getProperty("dspace.url") + "/" + config.getProperty("websvc.opensearch.svccontext");
        this.uiUrl = config.getProperty("dspace.url") + "/" + config.getProperty("websvc.opensearch.uicontext");
        this.formats = new ArrayList<String>();
        if (this.enabled) {
            String[] fmts = config.getArrayProperty("websvc.opensearch.formats");
            this.formats = Arrays.asList(fmts);
        }
    }

    @Override
    public List<String> getFormats() {
        return this.formats;
    }

    @Override
    public String getContentType(String format) {
        return "html".equals(format) ? "text/html" : "application/" + format + "+xml; charset=UTF-8";
    }

    @Override
    public org.w3c.dom.Document getDescriptionDoc(String scope) throws IOException {
        return this.jDomToW3(this.getServiceDocument(scope));
    }

    @Override
    public String getDescription(String scope) {
        return new XMLOutputter().outputString(this.getServiceDocument(scope));
    }

    @Override
    public String getResultsString(Context context, String format, String query, int totalResults, int start, int pageSize, DSpaceObject scope, List<DSpaceObject> results, Map<String, String> labels) throws IOException {
        try {
            return this.getResults(context, format, query, totalResults, start, pageSize, scope, results, labels).outputString();
        }
        catch (FeedException e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw new IOException("Unable to generate feed", e);
        }
    }

    @Override
    public org.w3c.dom.Document getResultsDoc(Context context, String format, String query, int totalResults, int start, int pageSize, DSpaceObject scope, List<DSpaceObject> results, Map<String, String> labels) throws IOException {
        try {
            return this.getResults(context, format, query, totalResults, start, pageSize, scope, results, labels).outputW3CDom();
        }
        catch (FeedException e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw new IOException("Unable to generate feed", e);
        }
    }

    protected SyndicationFeed getResults(Context context, String format, String query, int totalResults, int start, int pageSize, DSpaceObject scope, List<DSpaceObject> results, Map<String, String> labels) {
        if ("rss".equals(format)) {
            format = "rss_2.0";
        } else if ("atom".equals(format)) {
            format = "atom_1.0";
        }
        SyndicationFeed feed = new SyndicationFeed(labels.get("ui.type"));
        feed.populate(null, context, scope, results, labels);
        feed.setType(format);
        feed.addModule((Module)this.openSearchMarkup(query, totalResults, start, pageSize));
        return feed;
    }

    protected OpenSearchModule openSearchMarkup(String query, int totalResults, int start, int pageSize) {
        OpenSearchModuleImpl osMod = new OpenSearchModuleImpl();
        osMod.setTotalResults(totalResults);
        osMod.setStartIndex(start);
        osMod.setItemsPerPage(pageSize);
        OSQuery osq = new OSQuery();
        osq.setRole("request");
        try {
            osq.setSearchTerms(URLEncoder.encode(query, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        osq.setStartPage(1 + start / pageSize);
        osMod.addQuery(osq);
        return osMod;
    }

    protected Document getServiceDocument(String scope) {
        String faviconUrl;
        String contact;
        String tags;
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        Namespace ns = Namespace.getNamespace((String)"http://a9.com/-/spec/opensearch/1.1/");
        Element root = new Element("OpenSearchDescription", ns);
        root.addContent((Content)new Element("ShortName", ns).setText(config.getProperty("websvc.opensearch.shortname")));
        root.addContent((Content)new Element("LongName", ns).setText(config.getProperty("websvc.opensearch.longname")));
        root.addContent((Content)new Element("Description", ns).setText(config.getProperty("websvc.opensearch.description")));
        root.addContent((Content)new Element("InputEncoding", ns).setText("UTF-8"));
        root.addContent((Content)new Element("OutputEncoding", ns).setText("UTF-8"));
        String sample = config.getProperty("websvc.opensearch.samplequery");
        if (sample != null && sample.length() > 0) {
            Element sq = new Element("Query", ns).setAttribute("role", "example");
            root.addContent((Content)sq.setAttribute("searchTerms", sample));
        }
        if ((tags = config.getProperty("websvc.opensearch.tags")) != null && tags.length() > 0) {
            root.addContent((Content)new Element("Tags", ns).setText(tags));
        }
        if ((contact = config.getProperty("mail.admin")) != null && contact.length() > 0) {
            root.addContent((Content)new Element("Contact", ns).setText(contact));
        }
        if ((faviconUrl = config.getProperty("websvc.opensearch.faviconurl")) != null && faviconUrl.length() > 0) {
            String dim = String.valueOf(16);
            String type = faviconUrl.endsWith("ico") ? "image/vnd.microsoft.icon" : "image/png";
            Element fav = new Element("Image", ns).setAttribute("height", dim).setAttribute("width", dim).setAttribute("type", type).setText(faviconUrl);
            root.addContent((Content)fav);
        }
        for (String format : this.formats) {
            Element url = new Element("Url", ns).setAttribute("type", this.getContentType(format));
            StringBuilder template = new StringBuilder();
            if ("html".equals(format)) {
                template.append(this.uiUrl);
            } else {
                template.append(this.svcUrl);
            }
            template.append("?query={searchTerms}");
            if (!"html".equals(format)) {
                template.append("&start={startIndex?}&rpp={count?}&format=");
                template.append(format);
            }
            if (scope != null) {
                template.append("&scope=");
                template.append(scope);
            }
            url.setAttribute("template", template.toString());
            root.addContent((Content)url);
        }
        return new Document(root);
    }

    protected org.w3c.dom.Document jDomToW3(Document jdomDoc) throws IOException {
        DOMOutputter domOut = new DOMOutputter();
        try {
            return domOut.output(jdomDoc);
        }
        catch (JDOMException jde) {
            throw new IOException("JDOM output exception", jde);
        }
    }

    @Override
    public DSpaceObject resolveScope(Context context, String scope) throws SQLException {
        if (scope == null || "".equals(scope)) {
            return null;
        }
        DSpaceObject dso = this.handleService.resolveToObject(context, scope);
        if (dso == null || dso.getType() == 2) {
            throw new IllegalArgumentException("Scope handle " + scope + " should point to a valid Community or Collection");
        }
        return dso;
    }
}

