/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.InProgressSubmission;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.workflow.WorkflowItem;

public class SubmissionInfo
extends HashMap {
    private static Logger log = Logger.getLogger(SubmissionInfo.class);
    private InProgressSubmission submissionItem = null;
    private SubmissionConfig submissionConfig = null;
    private String collectionHandle = null;
    private Map<String, String> progressBar = null;
    private String moreBoxesFor;
    private String jumpToField;
    private List<String> missingFields;
    private Bundle bundle;
    private Bitstream bitstream;
    private static SubmissionConfigReader submissionConfigReader;

    private SubmissionInfo() {
    }

    public static SubmissionInfo load(HttpServletRequest request, InProgressSubmission subItem) throws ServletException {
        boolean forceReload = false;
        SubmissionInfo subInfo = new SubmissionInfo();
        if (submissionConfigReader == null) {
            submissionConfigReader = new SubmissionConfigReader();
            forceReload = true;
        }
        subInfo.setSubmissionItem(subItem);
        String collectionHandle = "default";
        if (subItem != null) {
            collectionHandle = subItem.getCollection().getHandle();
        }
        subInfo.setCollectionHandle(collectionHandle);
        SubmissionInfo.loadSubmissionConfig(request, subInfo, forceReload);
        return subInfo;
    }

    public boolean isInWorkflow() {
        return this.submissionItem != null && this.submissionItem instanceof WorkflowItem;
    }

    public InProgressSubmission getSubmissionItem() {
        return this.submissionItem;
    }

    public void setSubmissionItem(InProgressSubmission subItem) {
        this.submissionItem = subItem;
    }

    public SubmissionConfig getSubmissionConfig() {
        return this.submissionConfig;
    }

    public void reloadSubmissionConfig(HttpServletRequest request) throws ServletException {
        String collectionHandle = "default";
        if (this.submissionItem != null) {
            collectionHandle = this.submissionItem.getCollection().getHandle();
        }
        this.setCollectionHandle(collectionHandle);
        SubmissionInfo.loadSubmissionConfig(request, this, true);
    }

    public SubmissionStepConfig getStepConfig(String stepID) throws ServletException {
        return submissionConfigReader.getStepConfig(stepID);
    }

    public String getSubmissionLogInfo() {
        String info = "";
        info = this.isInWorkflow() ? info + "workflow_id=" + this.getSubmissionItem().getID() : info + "workspace_item_id" + this.getSubmissionItem().getID();
        if (this.getBundle() != null) {
            info = info + ",bundle_id=" + this.getBundle().getID();
        }
        if (this.getBitstream() != null) {
            info = info + ",bitstream_id=" + this.getBitstream().getID();
        }
        return info;
    }

    public String getCollectionHandle() {
        return this.collectionHandle;
    }

    public void setCollectionHandle(String handle) {
        this.collectionHandle = handle;
    }

    public Map<String, String> getProgressBarInfo() {
        return this.progressBar;
    }

    public Bitstream getBitstream() {
        return this.bitstream;
    }

    public void setBitstream(Bitstream bits) {
        this.bitstream = bits;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bund) {
        this.bundle = bund;
    }

    public List<String> getMissingFields() {
        return this.missingFields;
    }

    public void setMissingFields(List<String> missing) {
        this.missingFields = missing;
    }

    public String getMoreBoxesFor() {
        return this.moreBoxesFor;
    }

    public void setMoreBoxesFor(String fieldname) {
        this.moreBoxesFor = fieldname;
    }

    public String getJumpToField() {
        return this.jumpToField;
    }

    public void setJumpToField(String fieldname) {
        this.jumpToField = fieldname;
    }

    private static void loadProgressBar(HttpServletRequest request, SubmissionInfo subInfo, boolean forceReload) {
        Map<String, String> progressBarInfo = null;
        log.debug((Object)"Loading Progress Bar Info");
        if (!forceReload) {
            progressBarInfo = SubmissionInfo.loadProgressBarFromCache(request.getSession());
        }
        if (progressBarInfo != null && log.isDebugEnabled()) {
            log.debug((Object)("Found Progress Bar Info in cache: " + progressBarInfo.size() + " pages to display in progress bar"));
        } else {
            progressBarInfo = new LinkedHashMap<String, String>();
            for (int i = 0; i < subInfo.submissionConfig.getNumberOfSteps(); ++i) {
                SubmissionStepConfig currentStep = subInfo.submissionConfig.getStep(i);
                String stepNumber = Integer.toString(currentStep.getStepNumber());
                String stepHeading = currentStep.getHeading();
                if (!currentStep.isVisible()) continue;
                int numPages = 1;
                try {
                    ClassLoader loader = subInfo.getClass().getClassLoader();
                    Class<?> stepClass = loader.loadClass(currentStep.getProcessingClassName());
                    AbstractProcessingStep step = (AbstractProcessingStep)stepClass.newInstance();
                    numPages = step.getNumberOfPages(request, subInfo);
                }
                catch (Exception e) {
                    log.error((Object)("Error loading progress bar information from Step Class '" + currentStep.getProcessingClassName() + "' Error:"), (Throwable)e);
                }
                for (int j = 1; j <= numPages; ++j) {
                    String pageNumber = Integer.toString(j);
                    progressBarInfo.put(stepNumber + "." + pageNumber, stepHeading);
                }
            }
            log.debug((Object)("Loaded Progress Bar Info from scratch: " + progressBarInfo.size() + " pages to display in progress bar"));
            SubmissionInfo.saveProgressBarToCache(request.getSession(), progressBarInfo);
        }
        subInfo.progressBar = progressBarInfo;
    }

    private static void saveProgressBarToCache(HttpSession session, Map<String, String> progressBarInfo) {
        session.setAttribute("submission.progressbar", progressBarInfo);
    }

    private static Map<String, String> loadProgressBarFromCache(HttpSession session) {
        return (Map)session.getAttribute("submission.progressbar");
    }

    private static void loadSubmissionConfig(HttpServletRequest request, SubmissionInfo subInfo, boolean forceReload) throws ServletException {
        log.debug((Object)"Loading Submission Config information");
        if (!forceReload) {
            subInfo.submissionConfig = SubmissionInfo.loadSubmissionConfigFromCache(request.getSession(), subInfo.getCollectionHandle(), subInfo.isInWorkflow());
        }
        if (subInfo.submissionConfig == null || forceReload) {
            subInfo.submissionConfig = submissionConfigReader.getSubmissionConfig(subInfo.getCollectionHandle(), subInfo.isInWorkflow());
            SubmissionInfo.saveSubmissionConfigToCache(request.getSession(), subInfo.submissionConfig, subInfo.getCollectionHandle(), subInfo.isInWorkflow());
            SubmissionInfo.loadProgressBar(request, subInfo, true);
        } else {
            log.debug((Object)"Found Submission Config in session cache!");
            SubmissionInfo.loadProgressBar(request, subInfo, false);
        }
    }

    private static void saveSubmissionConfigToCache(HttpSession session, SubmissionConfig subConfig, String collectionHandle, boolean isWorkflow) {
        session.setAttribute("submission.config", (Object)subConfig);
        session.setAttribute("submission.config.collection", (Object)collectionHandle);
        session.setAttribute("submission.config.isWorkflow", (Object)isWorkflow);
    }

    private static SubmissionConfig loadSubmissionConfigFromCache(HttpSession session, String collectionHandle, boolean isWorkflow) {
        String cachedHandle = (String)session.getAttribute("submission.config.collection");
        Boolean cachedIsWorkflow = (Boolean)session.getAttribute("submission.config.isWorkflow");
        if (collectionHandle.equals(cachedHandle) && isWorkflow == cachedIsWorkflow) {
            return (SubmissionConfig)session.getAttribute("submission.config");
        }
        return null;
    }
}

