/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.indexer;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.factory.AuthorityServiceFactory;
import org.dspace.authority.indexer.AuthorityIndexerInterface;
import org.dspace.authority.indexer.AuthorityIndexingService;
import org.dspace.authority.service.AuthorityService;
import org.dspace.core.Context;

public class AuthorityIndexClient {
    private static Logger log = Logger.getLogger(AuthorityIndexClient.class);
    protected static final AuthorityService authorityService = AuthorityServiceFactory.getInstance().getAuthorityService();
    protected static final AuthorityIndexingService indexingService = AuthorityServiceFactory.getInstance().getAuthorityIndexingService();
    protected static final List<AuthorityIndexerInterface> indexers = AuthorityServiceFactory.getInstance().getAuthorityIndexers();

    public static void main(String[] args) throws Exception {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        if (!authorityService.isConfigurationValid()) {
            System.out.println("Cannot index authority values since the configuration isn't valid. Check dspace logs for more information.");
            return;
        }
        System.out.println("Retrieving all data");
        log.info((Object)"Retrieving all data");
        HashMap<String, AuthorityValue> toIndexValues = new HashMap<String, AuthorityValue>();
        for (AuthorityIndexerInterface indexerInterface : indexers) {
            log.info((Object)("Initialize " + indexerInterface.getClass().getName()));
            System.out.println("Initialize " + indexerInterface.getClass().getName());
            indexerInterface.init(context, true);
            while (indexerInterface.hasMore()) {
                AuthorityValue authorityValue = indexerInterface.nextValue();
                if (authorityValue == null) continue;
                toIndexValues.put(authorityValue.getId(), authorityValue);
            }
            indexerInterface.close();
        }
        log.info((Object)"Cleaning the old index");
        System.out.println("Cleaning the old index");
        indexingService.cleanIndex();
        log.info((Object)"Writing new data");
        System.out.println("Writing new data");
        for (String id : toIndexValues.keySet()) {
            indexingService.indexContent((AuthorityValue)toIndexValues.get(id), true);
            indexingService.commit();
        }
        indexingService.commit();
        context.complete();
        System.out.println("All done !");
        log.info((Object)"All done !");
    }
}

