/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.dao.BitstreamDAO;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class BitstreamDAOImpl
extends AbstractHibernateDSODAO<Bitstream>
implements BitstreamDAO {
    protected BitstreamDAOImpl() {
    }

    @Override
    public List<Bitstream> findDeletedBitstreams(Context context) throws SQLException {
        Criteria criteria = this.createCriteria(context, Bitstream.class);
        criteria.add((Criterion)Restrictions.eq((String)"deleted", (Object)true));
        return this.list(criteria);
    }

    @Override
    public List<Bitstream> findDuplicateInternalIdentifier(Context context, Bitstream bitstream) throws SQLException {
        Criteria criteria = this.createCriteria(context, Bitstream.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"internalId", (Object)bitstream.getInternalId()), (Criterion)Restrictions.not((Criterion)Restrictions.eq((String)"id", (Object)bitstream.getID()))));
        return this.list(criteria);
    }

    @Override
    public List<Bitstream> findBitstreamsWithNoRecentChecksum(Context context) throws SQLException {
        Query query = this.createQuery(context, "select b from Bitstream b where b not in (select c.bitstream from MostRecentChecksum c)");
        return query.list();
    }

    @Override
    public Iterator<Bitstream> findByCommunity(Context context, Community community) throws SQLException {
        Query query = this.createQuery(context, "select b from Bitstream b join b.bundles bitBundles join bitBundles.items item join item.collections itemColl join itemColl.communities community WHERE :community IN community");
        query.setParameter("community", (Object)community);
        return this.iterate(query);
    }

    @Override
    public Iterator<Bitstream> findByCollection(Context context, Collection collection) throws SQLException {
        Query query = this.createQuery(context, "select b from Bitstream b join b.bundles bitBundles join bitBundles.items item join item.collections c WHERE :collection IN c");
        query.setParameter("collection", (Object)collection);
        return this.iterate(query);
    }

    @Override
    public Iterator<Bitstream> findByItem(Context context, Item item) throws SQLException {
        Query query = this.createQuery(context, "select b from Bitstream b join b.bundles bitBundles join bitBundles.items item WHERE :item IN item");
        query.setParameter("item", (Object)item);
        return this.iterate(query);
    }

    @Override
    public Iterator<Bitstream> findByStoreNumber(Context context, Integer storeNumber) throws SQLException {
        Query query = this.createQuery(context, "select b from Bitstream b where b.storeNumber = :storeNumber");
        query.setParameter("storeNumber", (Object)storeNumber);
        return this.iterate(query);
    }

    @Override
    public Long countByStoreNumber(Context context, Integer storeNumber) throws SQLException {
        Criteria criteria = this.createCriteria(context, Bitstream.class);
        criteria.add((Criterion)Restrictions.eq((String)"storeNumber", (Object)storeNumber));
        return this.countLong(criteria);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) from Bitstream"));
    }

    @Override
    public int countDeleted(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Bitstream b WHERE b.deleted=true"));
    }

    @Override
    public int countWithNoPolicy(Context context) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(bit.id) from Bitstream bit where bit.deleted<>true and bit.id not in (select res.dSpaceObject from ResourcePolicy res where res.resourceTypeId = :typeId )");
        query.setParameter("typeId", (Object)0);
        return this.count(query);
    }

    @Override
    public List<Bitstream> getNotReferencedBitstreams(Context context) throws SQLException {
        return this.list(this.createQuery(context, "select bit from Bitstream bit where bit.deleted != true and bit.id not in (select bit2.id from Bundle bun join bun.bitstreams bit2) and bit.id not in (select com.logo.id from Community com) and bit.id not in (select col.logo.id from Collection col) and bit.id not in (select bun.primaryBitstream.id from Bundle bun)"));
    }
}

