/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.DBConnection;
import org.dspace.core.ReloadableEntity;
import org.dspace.core.Utils;
import org.dspace.handle.Handle;
import org.dspace.storage.rdbms.DatabaseConfigVO;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.proxy.HibernateProxyHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate4.SessionFactoryUtils;

public class HibernateDBConnection
implements DBConnection<Session> {
    @Autowired(required=true)
    @Qualifier(value="sessionFactory")
    private SessionFactory sessionFactory;
    private boolean batchModeEnabled = false;
    private boolean readOnlyEnabled = false;

    @Override
    public Session getSession() throws SQLException {
        if (!this.isTransActionAlive()) {
            this.sessionFactory.getCurrentSession().beginTransaction();
            this.configureDatabaseMode();
        }
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    public boolean isTransActionAlive() {
        Transaction transaction = this.getTransaction();
        return transaction != null && transaction.isActive();
    }

    protected Transaction getTransaction() {
        return this.sessionFactory.getCurrentSession().getTransaction();
    }

    @Override
    public boolean isSessionAlive() {
        return this.sessionFactory.getCurrentSession() != null && this.sessionFactory.getCurrentSession().getTransaction() != null && this.sessionFactory.getCurrentSession().getTransaction().isActive();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.isTransActionAlive()) {
            this.getTransaction().rollback();
        }
    }

    @Override
    public void closeDBConnection() throws SQLException {
        if (this.sessionFactory.getCurrentSession() != null && this.sessionFactory.getCurrentSession().isOpen()) {
            this.sessionFactory.getCurrentSession().close();
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.isTransActionAlive() && !this.getTransaction().wasRolledBack()) {
            this.getSession().flush();
            this.getTransaction().commit();
        }
    }

    @Override
    public synchronized void shutdown() {
        this.sessionFactory.close();
    }

    @Override
    public String getType() {
        return ((SessionFactoryImplementor)this.sessionFactory).getDialect().toString();
    }

    @Override
    public DataSource getDataSource() {
        return SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory);
    }

    @Override
    public DatabaseConfigVO getDatabaseConfig() throws SQLException {
        DatabaseConfigVO databaseConfigVO = new DatabaseConfigVO();
        try (Connection connection = this.getDataSource().getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            databaseConfigVO.setDatabaseDriver(metaData.getDriverName());
            databaseConfigVO.setDatabaseUrl(metaData.getURL());
            databaseConfigVO.setSchema(metaData.getSchemaTerm());
            databaseConfigVO.setMaxConnections(metaData.getMaxConnections());
            databaseConfigVO.setUserName(metaData.getUserName());
        }
        return databaseConfigVO;
    }

    @Override
    public long getCacheSize() throws SQLException {
        return this.getSession().getStatistics().getEntityCount();
    }

    @Override
    public <E extends ReloadableEntity> E reloadEntity(E entity) throws SQLException {
        if (entity == null) {
            return null;
        }
        if (this.getSession().contains(entity)) {
            return entity;
        }
        return (E)((ReloadableEntity)this.getSession().get(HibernateProxyHelper.getClassWithoutInitializingProxy(entity), entity.getID()));
    }

    @Override
    public void setConnectionMode(boolean batchOptimized, boolean readOnlyOptimized) throws SQLException {
        this.batchModeEnabled = batchOptimized;
        this.readOnlyEnabled = readOnlyOptimized;
        this.configureDatabaseMode();
    }

    @Override
    public boolean isOptimizedForBatchProcessing() {
        return this.batchModeEnabled;
    }

    private void configureDatabaseMode() throws SQLException {
        if (this.batchModeEnabled) {
            this.getSession().setFlushMode(FlushMode.ALWAYS);
        } else if (this.readOnlyEnabled) {
            this.getSession().setFlushMode(FlushMode.MANUAL);
        } else {
            this.getSession().setFlushMode(FlushMode.AUTO);
        }
    }

    @Override
    public <E extends ReloadableEntity> void uncacheEntity(E entity) throws SQLException {
        if (entity != null) {
            if (entity instanceof DSpaceObject) {
                DSpaceObject dso = (DSpaceObject)entity;
                if (Hibernate.isInitialized(dso.getHandles())) {
                    for (Handle handle : Utils.emptyIfNull(dso.getHandles())) {
                        this.uncacheEntity(handle);
                    }
                }
                if (Hibernate.isInitialized(dso.getResourcePolicies())) {
                    for (ResourcePolicy policy : Utils.emptyIfNull(dso.getResourcePolicies())) {
                        this.uncacheEntity(policy);
                    }
                }
            }
            if (entity instanceof Item) {
                Item item = (Item)entity;
                if (Hibernate.isInitialized((Object)item.getSubmitter())) {
                    this.uncacheEntity(item.getSubmitter());
                }
                if (Hibernate.isInitialized(item.getBundles())) {
                    for (Bundle bundle : Utils.emptyIfNull(item.getBundles())) {
                        this.uncacheEntity(bundle);
                    }
                }
            } else if (entity instanceof Bundle) {
                Bundle bundle = (Bundle)entity;
                if (Hibernate.isInitialized(bundle.getBitstreams())) {
                    for (Bitstream bitstream : Utils.emptyIfNull(bundle.getBitstreams())) {
                        this.uncacheEntity(bitstream);
                    }
                }
            } else if (entity instanceof Community) {
                Community community = (Community)entity;
                if (Hibernate.isInitialized((Object)community.getAdministrators())) {
                    this.uncacheEntity(community.getAdministrators());
                }
                if (Hibernate.isInitialized((Object)community.getLogo())) {
                    this.uncacheEntity(community.getLogo());
                }
            } else if (entity instanceof Collection) {
                Collection collection = (Collection)entity;
                if (Hibernate.isInitialized((Object)collection.getLogo())) {
                    this.uncacheEntity(collection.getLogo());
                }
                if (Hibernate.isInitialized((Object)collection.getAdministrators())) {
                    this.uncacheEntity(collection.getAdministrators());
                }
                if (Hibernate.isInitialized((Object)collection.getSubmitters())) {
                    this.uncacheEntity(collection.getSubmitters());
                }
                if (Hibernate.isInitialized((Object)collection.getTemplateItem())) {
                    this.uncacheEntity(collection.getTemplateItem());
                }
                if (Hibernate.isInitialized((Object)collection.getWorkflowStep1())) {
                    this.uncacheEntity(collection.getWorkflowStep1());
                }
                if (Hibernate.isInitialized((Object)collection.getWorkflowStep2())) {
                    this.uncacheEntity(collection.getWorkflowStep2());
                }
                if (Hibernate.isInitialized((Object)collection.getWorkflowStep3())) {
                    this.uncacheEntity(collection.getWorkflowStep3());
                }
            }
            this.getSession().evict(entity);
        }
    }
}

