/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverFilterQuery;
import org.dspace.discovery.DiscoverHitHighlightingField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.FullTextContentStreams;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.SolrServiceSearchPlugin;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.discovery.configuration.DiscoveryHitHighlightFieldConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightingConfiguration;
import org.dspace.discovery.configuration.DiscoveryMoreLikeThisConfiguration;
import org.dspace.discovery.configuration.DiscoveryRecentSubmissionsConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.discovery.configuration.HierarchicalSidebarFacetConfiguration;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.dspace.util.MultiFormatDateParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SolrServiceImpl
implements SearchService,
IndexingService {
    private static final Logger log = Logger.getLogger(SolrServiceImpl.class);
    protected static final String LAST_INDEXED_FIELD = "SolrIndexer.lastIndexed";
    protected static final String HANDLE_FIELD = "handle";
    protected static final String RESOURCE_TYPE_FIELD = "search.resourcetype";
    protected static final String RESOURCE_ID_FIELD = "search.resourceid";
    public static final String FILTER_SEPARATOR = "\n|||\n";
    public static final String AUTHORITY_SEPARATOR = "###";
    public static final String STORE_SEPARATOR = "\n|||\n";
    public static final String VARIANTS_STORE_SEPARATOR = "###";
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;
    @Autowired(required=true)
    protected ChoiceAuthorityService choiceAuthorityService;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected MetadataAuthorityService metadataAuthorityService;
    private HttpSolrServer solr = null;

    protected SolrServiceImpl() {
    }

    protected HttpSolrServer getSolr() {
        if (this.solr == null) {
            UrlValidator urlValidator = new UrlValidator(8L);
            String solrService = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.search.server");
            if (urlValidator.isValid(solrService) || ConfigurationManager.getBooleanProperty("discovery", "solr.url.validation.enabled", true)) {
                try {
                    log.debug((Object)("Solr URL: " + solrService));
                    this.solr = new HttpSolrServer(solrService);
                    this.solr.setBaseURL(solrService);
                    this.solr.setUseMultiPartPost(true);
                    SolrQuery solrQuery = new SolrQuery().setQuery("search.resourcetype:2 AND search.resourceid:1");
                    solrQuery.setFields(new String[]{RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD});
                    this.solr.query((SolrParams)solrQuery);
                    DatabaseUtils.checkReindexDiscovery(this);
                }
                catch (SolrServerException e) {
                    log.error((Object)"Error while initializing solr server", (Throwable)e);
                }
            } else {
                log.error((Object)("Error while initializing solr, invalid url: " + solrService));
            }
        }
        return this.solr;
    }

    @Override
    public void indexContent(Context context, DSpaceObject dso) throws SQLException {
        this.indexContent(context, dso, false);
    }

    @Override
    public void indexContent(Context context, DSpaceObject dso, boolean force) throws SQLException {
        String handle = dso.getHandle();
        if (handle == null) {
            handle = this.handleService.findHandle(context, dso);
        }
        try {
            switch (dso.getType()) {
                case 2: {
                    Item item = (Item)dso;
                    if (item.isArchived() || item.isWithdrawn()) {
                        if (this.requiresIndexing(handle, ((Item)dso).getLastModified()) || force) {
                            this.unIndexContent(context, handle);
                            this.buildDocument(context, (Item)dso);
                        }
                        break;
                    }
                    this.unIndexContent(context, item);
                    log.info((Object)("Removed Item: " + handle + " from Index"));
                    break;
                }
                case 3: {
                    this.buildDocument(context, (org.dspace.content.Collection)dso);
                    log.info((Object)("Wrote Collection: " + handle + " to Index"));
                    break;
                }
                case 4: {
                    this.buildDocument(context, (Community)dso);
                    log.info((Object)("Wrote Community: " + handle + " to Index"));
                    break;
                }
                default: {
                    log.error((Object)"Only Items, Collections and Communities can be Indexed");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void unIndexContent(Context context, DSpaceObject dso) throws SQLException, IOException {
        this.unIndexContent(context, dso, false);
    }

    @Override
    public void unIndexContent(Context context, DSpaceObject dso, boolean commit) throws SQLException, IOException {
        try {
            if (dso == null) {
                return;
            }
            String uniqueID = dso.getType() + "-" + dso.getID();
            this.getSolr().deleteById(uniqueID);
            if (commit) {
                this.getSolr().commit();
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.emailException(exception);
        }
    }

    @Override
    public void unIndexContent(Context context, String handle) throws IOException, SQLException {
        this.unIndexContent(context, handle, false);
    }

    @Override
    public void unIndexContent(Context context, String handle, boolean commit) throws SQLException, IOException {
        try {
            if (this.getSolr() != null) {
                this.getSolr().deleteByQuery("handle:\"" + handle + "\"");
                if (commit) {
                    this.getSolr().commit();
                }
            }
        }
        catch (SolrServerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void reIndexContent(Context context, DSpaceObject dso) throws SQLException, IOException {
        try {
            this.indexContent(context, dso);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.emailException(exception);
        }
    }

    @Override
    public void createIndex(Context c) throws SQLException, IOException {
        this.updateIndex(c, true);
    }

    @Override
    public void updateIndex(Context context) {
        this.updateIndex(context, false);
    }

    @Override
    public void updateIndex(Context context, boolean force) {
        try {
            Iterator<Item> items = null;
            items = this.itemService.findAllUnfiltered(context);
            while (items.hasNext()) {
                Item item = items.next();
                this.indexContent(context, item, force);
                context.uncacheEntity(item);
            }
            List<org.dspace.content.Collection> collections = this.collectionService.findAll(context);
            for (org.dspace.content.Collection collection : collections) {
                this.indexContent(context, collection, force);
            }
            List<Community> communities = this.communityService.findAll(context);
            for (Community community : communities) {
                this.indexContent(context, community, force);
            }
            if (this.getSolr() != null) {
                this.getSolr().commit();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void cleanIndex(boolean force) throws IOException, SQLException, SearchServiceException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        try {
            if (this.getSolr() == null) {
                return;
            }
            if (force) {
                this.getSolr().deleteByQuery("search.resourcetype:[2 TO 4]");
            } else {
                SolrQuery query = new SolrQuery();
                query.setFields(new String[]{HANDLE_FIELD});
                query.setQuery("search.resourcetype:[2 TO 4]");
                QueryResponse rsp = this.getSolr().query((SolrParams)query);
                SolrDocumentList docs = rsp.getResults();
                for (SolrDocument doc : docs) {
                    String handle = (String)doc.getFieldValue(HANDLE_FIELD);
                    DSpaceObject o = this.handleService.resolveToObject(context, handle);
                    if (o == null) {
                        log.info((Object)("Deleting: " + handle));
                        this.unIndexContent(context, handle);
                        continue;
                    }
                    log.debug((Object)("Keeping: " + handle));
                }
            }
        }
        catch (Exception e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
        finally {
            context.abort();
        }
    }

    @Override
    public void optimize() {
        try {
            if (this.getSolr() == null) {
                return;
            }
            long start = System.currentTimeMillis();
            System.out.println("SOLR Search Optimize -- Process Started:" + start);
            this.getSolr().optimize();
            long finish = System.currentTimeMillis();
            System.out.println("SOLR Search Optimize -- Process Finished:" + finish);
            System.out.println("SOLR Search Optimize -- Total time taken:" + (finish - start) + " (ms).");
        }
        catch (SolrServerException sse) {
            System.err.println(sse.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    @Override
    public void buildSpellCheck() throws SearchServiceException {
        try {
            if (this.getSolr() == null) {
                return;
            }
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.set("spellcheck", true);
            solrQuery.set("spellcheck.build", true);
            this.getSolr().query((SolrParams)solrQuery);
        }
        catch (SolrServerException e) {
            log.error((Object)e, (Throwable)e);
            throw new SearchServiceException(e);
        }
    }

    protected void emailException(Exception exception) {
        try {
            String recipient = ConfigurationManager.getProperty("alert.recipient");
            if (StringUtils.isNotBlank((String)recipient)) {
                String stackTrace;
                Email email = Email.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "internal_error"));
                email.addRecipient(recipient);
                email.addArgument(ConfigurationManager.getProperty("dspace.url"));
                email.addArgument(new Date());
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument(stackTrace);
                email.send();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to send email alert", (Throwable)e);
        }
    }

    protected boolean requiresIndexing(String handle, Date lastModified) throws SQLException, IOException, SearchServiceException {
        QueryResponse rsp;
        boolean reindexItem = false;
        boolean inIndex = false;
        SolrQuery query = new SolrQuery();
        query.setQuery("handle:" + handle);
        query.setFields(new String[]{LAST_INDEXED_FIELD});
        try {
            if (this.getSolr() == null) {
                return false;
            }
            rsp = this.getSolr().query((SolrParams)query);
        }
        catch (SolrServerException e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
        for (SolrDocument doc : rsp.getResults()) {
            Date lastIndexed;
            inIndex = true;
            Object value = doc.getFieldValue(LAST_INDEXED_FIELD);
            if (!(value instanceof Date) || !(lastIndexed = (Date)value).before(lastModified)) continue;
            reindexItem = true;
        }
        return reindexItem || !inIndex;
    }

    protected List<String> getItemLocations(Context context, Item myitem) throws SQLException {
        Vector<String> locations = new Vector<String>();
        List<Community> communities = this.itemService.getCommunities(context, myitem);
        List<org.dspace.content.Collection> collections = myitem.getCollections();
        int i = 0;
        for (i = 0; i < communities.size(); ++i) {
            locations.add("m" + communities.get(i).getID());
        }
        for (i = 0; i < collections.size(); ++i) {
            locations.add("l" + collections.get(i).getID());
        }
        return locations;
    }

    protected List<String> getCollectionLocations(Context context, org.dspace.content.Collection target) throws SQLException {
        Vector<String> locations = new Vector<String>();
        List<Community> communities = this.communityService.getAllParents(context, target);
        for (Community community : communities) {
            locations.add("m" + community.getID());
        }
        return locations;
    }

    @Override
    public String createLocationQueryForAdministrableItems(Context context) throws SQLException {
        StringBuilder locationQuery = new StringBuilder();
        if (context.getCurrentUser() != null) {
            List<Group> groupList = EPersonServiceFactory.getInstance().getGroupService().allMemberGroups(context, context.getCurrentUser());
            List<ResourcePolicy> communitiesPolicies = AuthorizeServiceFactory.getInstance().getResourcePolicyService().find(context, context.getCurrentUser(), groupList, 11, 4);
            List<ResourcePolicy> collectionsPolicies = AuthorizeServiceFactory.getInstance().getResourcePolicyService().find(context, context.getCurrentUser(), groupList, 11, 3);
            ArrayList<org.dspace.content.Collection> allCollections = new ArrayList<org.dspace.content.Collection>();
            for (ResourcePolicy rp : collectionsPolicies) {
                org.dspace.content.Collection collection = (org.dspace.content.Collection)ContentServiceFactory.getInstance().getCollectionService().find(context, rp.getdSpaceObject().getID());
                allCollections.add(collection);
            }
            if (CollectionUtils.isNotEmpty(communitiesPolicies) || CollectionUtils.isNotEmpty(allCollections)) {
                locationQuery.append("location:( ");
                for (int i = 0; i < communitiesPolicies.size(); ++i) {
                    ResourcePolicy rp;
                    rp = communitiesPolicies.get(i);
                    Community community = (Community)ContentServiceFactory.getInstance().getCommunityService().find(context, rp.getdSpaceObject().getID());
                    locationQuery.append("m").append(community.getID());
                    if (i != communitiesPolicies.size() - 1) {
                        locationQuery.append(" OR ");
                    }
                    allCollections.addAll(ContentServiceFactory.getInstance().getCommunityService().getAllCollections(context, community));
                }
                Iterator collIter = allCollections.iterator();
                if (communitiesPolicies.size() > 0 && allCollections.size() > 0) {
                    locationQuery.append(" OR ");
                }
                while (collIter.hasNext()) {
                    locationQuery.append("l").append(((org.dspace.content.Collection)collIter.next()).getID());
                    if (!collIter.hasNext()) continue;
                    locationQuery.append(" OR ");
                }
                locationQuery.append(")");
            } else {
                log.warn((Object)("We have a collection or community admin with ID: " + context.getCurrentUser().getID() + " without any administrable collection or community!"));
            }
        }
        return locationQuery.toString();
    }

    protected void writeDocument(SolrInputDocument doc, FullTextContentStreams streams) throws IOException {
        try {
            if (this.getSolr() != null) {
                if (streams != null && !streams.isEmpty()) {
                    ContentStreamUpdateRequest req = new ContentStreamUpdateRequest("/update/extract");
                    req.addContentStream((ContentStream)streams);
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    for (String name : doc.getFieldNames()) {
                        for (Object val : doc.getFieldValues(name)) {
                            params.add("literal." + name, new String[]{val.toString()});
                        }
                    }
                    req.setParams(params);
                    req.setParam("uprefix", "attr_");
                    req.setParam("fmap.content", "fulltext");
                    req.setParam("extractFormat", "text");
                    req.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
                    req.process((SolrServer)this.getSolr());
                } else {
                    this.getSolr().add(doc);
                }
            }
        }
        catch (SolrServerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void buildDocument(Context context, Community community) throws SQLException, IOException {
        SolrInputDocument doc = this.buildDocument(4, community.getID(), community.getHandle(), null);
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration(community);
        DiscoveryHitHighlightingConfiguration highlightingConfiguration = discoveryConfiguration.getHitHighlightingConfiguration();
        ArrayList<String> highlightedMetadataFields = new ArrayList<String>();
        if (highlightingConfiguration != null) {
            for (DiscoveryHitHighlightFieldConfiguration configuration : highlightingConfiguration.getMetadataFields()) {
                highlightedMetadataFields.add(configuration.getField());
            }
        }
        String description = this.communityService.getMetadata(community, "introductory_text");
        String description_abstract = this.communityService.getMetadata(community, "short_description");
        String description_table = this.communityService.getMetadata(community, "side_bar_text");
        String rights = this.communityService.getMetadata(community, "copyright_text");
        String title = this.communityService.getMetadata(community, "name");
        List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(community.getType());
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description", description);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.abstract", description_abstract);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.tableofcontents", description_table);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.rights", rights);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.title", title);
        List solrServiceIndexPlugins = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrServiceIndexPlugin.class);
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : solrServiceIndexPlugins) {
            solrServiceIndexPlugin.additionalIndex(context, community, doc);
        }
        this.writeDocument(doc, null);
    }

    protected void buildDocument(Context context, org.dspace.content.Collection collection) throws SQLException, IOException {
        List<String> locations = this.getCollectionLocations(context, collection);
        SolrInputDocument doc = this.buildDocument(3, collection.getID(), collection.getHandle(), locations);
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration(collection);
        DiscoveryHitHighlightingConfiguration highlightingConfiguration = discoveryConfiguration.getHitHighlightingConfiguration();
        ArrayList<String> highlightedMetadataFields = new ArrayList<String>();
        if (highlightingConfiguration != null) {
            for (DiscoveryHitHighlightFieldConfiguration configuration : highlightingConfiguration.getMetadataFields()) {
                highlightedMetadataFields.add(configuration.getField());
            }
        }
        String description = this.collectionService.getMetadata(collection, "introductory_text");
        String description_abstract = this.collectionService.getMetadata(collection, "short_description");
        String description_table = this.collectionService.getMetadata(collection, "side_bar_text");
        String provenance = this.collectionService.getMetadata(collection, "provenance_description");
        String rights = this.collectionService.getMetadata(collection, "copyright_text");
        String rights_license = this.collectionService.getMetadata(collection, "license");
        String title = this.collectionService.getMetadata(collection, "name");
        List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(collection.getType());
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description", description);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.abstract", description_abstract);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.tableofcontents", description_table);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.provenance", provenance);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.rights", rights);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.rights.license", rights_license);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.title", title);
        List solrServiceIndexPlugins = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrServiceIndexPlugin.class);
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : solrServiceIndexPlugins) {
            solrServiceIndexPlugin.additionalIndex(context, collection, doc);
        }
        this.writeDocument(doc, null);
    }

    protected void addContainerMetadataField(SolrInputDocument doc, List<String> highlightedMetadataFields, List<String> toIgnoreMetadataFields, String metadataField, String value) {
        if ((toIgnoreMetadataFields == null || !toIgnoreMetadataFields.contains(metadataField)) && StringUtils.isNotBlank((String)value)) {
            doc.addField(metadataField, (Object)value);
            if (highlightedMetadataFields.contains(metadataField)) {
                doc.addField(metadataField + "_hl", (Object)value);
            }
        }
    }

    protected void buildDocument(Context context, Item item) throws SQLException, IOException {
        String handle = item.getHandle();
        if (handle == null) {
            handle = this.handleService.findHandle(context, item);
        }
        List<String> locations = this.getItemLocations(context, item);
        SolrInputDocument doc = this.buildDocument(2, item.getID(), handle, locations);
        log.debug((Object)("Building Item: " + handle));
        doc.addField("archived", (Object)item.isArchived());
        doc.addField("withdrawn", (Object)item.isWithdrawn());
        doc.addField("discoverable", (Object)item.isDiscoverable());
        doc.addField("lastModified", (Object)item.getLastModified());
        ArrayList<String> sortFieldsAdded = new ArrayList<String>();
        HashSet<String> hitHighlightingFields = new HashSet<String>();
        try {
            List<DiscoveryConfiguration> discoveryConfigurations = SearchUtils.getAllDiscoveryConfigurations(item);
            HashMap<String, Object> searchFilters = new HashMap<String, Object>();
            HashMap<String, DiscoverySortFieldConfiguration> sortFields = new HashMap<String, DiscoverySortFieldConfiguration>();
            HashMap<String, DiscoveryRecentSubmissionsConfiguration> recentSubmissionsConfigurationMap = new HashMap<String, DiscoveryRecentSubmissionsConfiguration>();
            HashSet<String> moreLikeThisFields = new HashSet<String>();
            for (DiscoveryConfiguration discoveryConfiguration : discoveryConfigurations) {
                DiscoveryMoreLikeThisConfiguration moreLikeThisConfiguration;
                DiscoveryHitHighlightingConfiguration hitHighlightingConfiguration;
                DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration;
                for (int i = 0; i < discoveryConfiguration.getSearchFilters().size(); ++i) {
                    DiscoverySearchFilter discoverySearchFilter = discoveryConfiguration.getSearchFilters().get(i);
                    for (int j = 0; j < discoverySearchFilter.getMetadataFields().size(); ++j) {
                        String metadataField = discoverySearchFilter.getMetadataFields().get(j);
                        List resultingList = searchFilters.get(metadataField) != null ? (List)searchFilters.get(metadataField) : new ArrayList();
                        resultingList.add(discoverySearchFilter);
                        searchFilters.put(metadataField, resultingList);
                    }
                }
                DiscoverySortConfiguration sortConfiguration = discoveryConfiguration.getSearchSortConfiguration();
                if (sortConfiguration != null) {
                    for (DiscoverySortFieldConfiguration discoverySortConfiguration : sortConfiguration.getSortFields()) {
                        sortFields.put(discoverySortConfiguration.getMetadataField(), discoverySortConfiguration);
                    }
                }
                if ((recentSubmissionConfiguration = discoveryConfiguration.getRecentSubmissionConfiguration()) != null) {
                    recentSubmissionsConfigurationMap.put(recentSubmissionConfiguration.getMetadataSortField(), recentSubmissionConfiguration);
                }
                if ((hitHighlightingConfiguration = discoveryConfiguration.getHitHighlightingConfiguration()) != null) {
                    List<DiscoveryHitHighlightFieldConfiguration> fieldConfigurations = hitHighlightingConfiguration.getMetadataFields();
                    for (DiscoveryHitHighlightFieldConfiguration fieldConfiguration : fieldConfigurations) {
                        hitHighlightingFields.add(fieldConfiguration.getField());
                    }
                }
                if ((moreLikeThisConfiguration = discoveryConfiguration.getMoreLikeThisConfiguration()) == null) continue;
                for (String metadataField : moreLikeThisConfiguration.getSimilarityMetadataFields()) {
                    moreLikeThisFields.add(metadataField);
                }
            }
            ArrayList<String> toProjectionFields = new ArrayList<String>();
            String[] projectionFields = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("discovery.index.projection");
            if (projectionFields != null) {
                for (String field : projectionFields) {
                    toProjectionFields.add(field.trim());
                }
            }
            List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(item.getType());
            List<MetadataValue> mydc = this.itemService.getMetadata(item, "*", "*", "*", "*");
            for (MetadataValue meta : mydc) {
                boolean ignoreAuthority;
                int minConfidence;
                String field;
                MetadataField metadataField = meta.getMetadataField();
                MetadataSchema metadataSchema = metadataField.getMetadataSchema();
                String unqualifiedField = field = metadataSchema.getName() + "." + metadataField.getElement();
                String value = meta.getValue();
                if (value == null) continue;
                if (metadataField.getQualifier() != null && !metadataField.getQualifier().trim().equals("")) {
                    field = field + "." + metadataField.getQualifier();
                }
                if (toIgnoreMetadataFields != null && (toIgnoreMetadataFields.contains(field) || toIgnoreMetadataFields.contains(unqualifiedField + "." + "*"))) continue;
                String authority = null;
                String preferedLabel = null;
                List<String> variants = null;
                boolean isAuthorityControlled = this.metadataAuthorityService.isAuthorityControlled(metadataField);
                int n = minConfidence = isAuthorityControlled ? this.metadataAuthorityService.getMinConfidence(metadataField) : 600;
                if (isAuthorityControlled && meta.getAuthority() != null && meta.getConfidence() >= minConfidence && !(ignoreAuthority = ((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore." + field, DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore", (Object)new Boolean(false)), true)).booleanValue())) {
                    boolean ignoreVariants;
                    authority = meta.getAuthority();
                    boolean ignorePrefered = (Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-prefered." + field, DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-prefered", (Object)new Boolean(false)), true);
                    if (!ignorePrefered) {
                        preferedLabel = this.choiceAuthorityService.getLabel(meta, meta.getLanguage());
                    }
                    if (!(ignoreVariants = ((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-variants." + field, DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-variants", (Object)new Boolean(false)), true)).booleanValue())) {
                        variants = this.choiceAuthorityService.getVariants(meta);
                    }
                }
                if (searchFilters.get(field) != null || searchFilters.get(unqualifiedField + "." + "*") != null) {
                    List searchFilterConfigs = (List)searchFilters.get(field);
                    if (searchFilterConfigs == null) {
                        searchFilterConfigs = (List)searchFilters.get(unqualifiedField + "." + "*");
                    }
                    for (DiscoverySearchFilter searchFilter : searchFilterConfigs) {
                        Date date = null;
                        String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
                        if (separator == null) {
                            separator = "\n|||\n";
                        }
                        if (searchFilter.getType().equals("date") && (date = MultiFormatDateParser.parse(value)) != null) {
                            value = DateFormatUtils.formatUTC((Date)date, (String)"yyyy-MM-dd");
                        }
                        doc.addField(searchFilter.getIndexFieldName(), (Object)value);
                        doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)value);
                        if (authority != null && preferedLabel == null) {
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)(value + "###" + authority));
                            doc.addField(searchFilter.getIndexFieldName() + "_authority", (Object)authority);
                            doc.addField(searchFilter.getIndexFieldName() + "_acid", (Object)(value.toLowerCase() + separator + value + "###" + authority));
                        }
                        if (preferedLabel != null) {
                            doc.addField(searchFilter.getIndexFieldName(), preferedLabel);
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)preferedLabel);
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)(preferedLabel + "###" + authority));
                            doc.addField(searchFilter.getIndexFieldName() + "_authority", (Object)authority);
                            doc.addField(searchFilter.getIndexFieldName() + "_acid", (Object)(preferedLabel.toLowerCase() + separator + preferedLabel + "###" + authority));
                        }
                        if (variants != null) {
                            for (String var : variants) {
                                doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)var);
                                doc.addField(searchFilter.getIndexFieldName() + "_acid", (Object)(var.toLowerCase() + separator + var + "###" + authority));
                            }
                        }
                        doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)(value.toLowerCase() + separator + value));
                        if (preferedLabel != null) {
                            doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)(preferedLabel.toLowerCase() + separator + preferedLabel));
                        }
                        if (variants != null) {
                            for (String var : variants) {
                                doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)(var.toLowerCase() + separator + var));
                            }
                        }
                        if (!searchFilter.getFilterType().equals("facet")) continue;
                        if (searchFilter.getType().equals("text")) {
                            if (authority != null) {
                                String facetValue = preferedLabel != null ? preferedLabel : value;
                                doc.addField(searchFilter.getIndexFieldName() + "_filter", (Object)(facetValue.toLowerCase() + separator + facetValue + "###" + authority));
                                continue;
                            }
                            doc.addField(searchFilter.getIndexFieldName() + "_filter", (Object)(value.toLowerCase() + separator + value));
                            continue;
                        }
                        if (searchFilter.getType().equals("date")) {
                            if (date == null) continue;
                            String indexField = searchFilter.getIndexFieldName() + ".year";
                            String yearUTC = DateFormatUtils.formatUTC((Date)date, (String)"yyyy");
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)yearUTC);
                            doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)yearUTC);
                            doc.addField(indexField, (Object)yearUTC);
                            if (yearUTC.startsWith("0")) {
                                doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)yearUTC.replaceFirst("0*", ""));
                                doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)yearUTC.replaceFirst("0*", ""));
                                doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)value.replaceFirst("0*", ""));
                                doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)value.replaceFirst("0*", ""));
                            }
                            if (doc.getField(indexField + "_sort") != null) continue;
                            doc.addField(indexField + "_sort", (Object)yearUTC);
                            continue;
                        }
                        if (!searchFilter.getType().equals("hierarchical")) continue;
                        HierarchicalSidebarFacetConfiguration hierarchicalSidebarFacetConfiguration = (HierarchicalSidebarFacetConfiguration)searchFilter;
                        Object[] subValues = value.split(hierarchicalSidebarFacetConfiguration.getSplitter());
                        if (hierarchicalSidebarFacetConfiguration.isSkipFirstNodeLevel() && 1 < subValues.length) {
                            subValues = (String[])ArrayUtils.subarray((Object[])subValues, (int)1, (int)subValues.length);
                        }
                        for (int i = 0; i < subValues.length; ++i) {
                            StringBuilder valueBuilder = new StringBuilder();
                            for (int j = 0; j <= i; ++j) {
                                valueBuilder.append((String)subValues[j]);
                                if (j >= i) continue;
                                valueBuilder.append(hierarchicalSidebarFacetConfiguration.getSplitter());
                            }
                            String indexValue = valueBuilder.toString().trim();
                            doc.addField(searchFilter.getIndexFieldName() + "_tax_" + i + "_filter", (Object)(indexValue.toLowerCase() + separator + indexValue));
                            for (int j = i; j < subValues.length; ++j) {
                                doc.addField(searchFilter.getIndexFieldName() + "_filter", (Object)(indexValue.toLowerCase() + separator + indexValue));
                                doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)indexValue);
                            }
                        }
                    }
                }
                if (!(sortFields.get(field) == null && recentSubmissionsConfigurationMap.get(field) == null || sortFieldsAdded.contains(field))) {
                    String type = sortFields.get(field) != null ? ((DiscoverySortFieldConfiguration)sortFields.get(field)).getType() : ((DiscoveryRecentSubmissionsConfiguration)recentSubmissionsConfigurationMap.get(field)).getType();
                    if (type.equals("date")) {
                        Date date = MultiFormatDateParser.parse(value);
                        if (date != null) {
                            doc.addField(field + "_dt", (Object)date);
                        } else {
                            log.warn((Object)("Error while indexing sort date field, item: " + item.getHandle() + " metadata field: " + field + " date value: " + date));
                        }
                    } else {
                        doc.addField(field + "_sort", (Object)value);
                    }
                    sortFieldsAdded.add(field);
                }
                if (hitHighlightingFields.contains(field) || hitHighlightingFields.contains("*") || hitHighlightingFields.contains(unqualifiedField + "." + "*")) {
                    doc.addField(field + "_hl", (Object)value);
                }
                if (moreLikeThisFields.contains(field) || moreLikeThisFields.contains(unqualifiedField + "." + "*")) {
                    doc.addField(field + "_mlt", (Object)value);
                }
                doc.addField(field, (Object)value);
                if (toProjectionFields.contains(field) || toProjectionFields.contains(unqualifiedField + "." + "*")) {
                    StringBuffer variantsToStore = new StringBuffer();
                    if (variants != null) {
                        for (String var : variants) {
                            variantsToStore.append("###");
                            variantsToStore.append(var);
                        }
                    }
                    doc.addField(field + "_stored", (Object)(value + "\n|||\n" + preferedLabel + "\n|||\n" + (variantsToStore.length() > "###".length() ? variantsToStore.substring("###".length()) : "null") + "\n|||\n" + authority + "\n|||\n" + meta.getLanguage()));
                }
                if (meta.getLanguage() == null || meta.getLanguage().trim().equals("")) continue;
                String langField = field + "." + meta.getLanguage();
                doc.addField(langField, (Object)value);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.debug((Object)"  Added Metadata");
        try {
            List<MetadataValue> values = this.itemService.getMetadataByMetadataString(item, "dc.relation.ispartof");
            if (values != null && values.size() > 0 && values.get(0) != null && values.get(0).getValue() != null) {
                Object handlePrefix = ConfigurationManager.getProperty("handle.canonical.prefix");
                if (handlePrefix == null || ((String)handlePrefix).length() == 0) {
                    handlePrefix = "http://hdl.handle.net/";
                }
                doc.addField("publication_grp", (Object)values.get(0).getValue().replaceFirst((String)handlePrefix, ""));
            } else {
                doc.addField("publication_grp", (Object)item.getHandle());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.debug((Object)"  Added Grouping");
        List solrServiceIndexPlugins = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrServiceIndexPlugin.class);
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : solrServiceIndexPlugins) {
            solrServiceIndexPlugin.additionalIndex(context, item, doc);
        }
        try {
            this.writeDocument(doc, new FullTextContentStreams(context, item));
            log.info((Object)("Wrote Item: " + handle + " to Index"));
        }
        catch (RuntimeException e) {
            log.error((Object)("Error while writing item to discovery index: " + handle + " message:" + e.getMessage()), (Throwable)e);
        }
    }

    protected SolrInputDocument buildDocument(int type, UUID id, String handle, List<String> locations) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField(LAST_INDEXED_FIELD, (Object)new Date());
        doc.addField("search.uniqueid", (Object)(type + "-" + id));
        doc.addField(RESOURCE_TYPE_FIELD, (Object)Integer.toString(type));
        doc.addField(RESOURCE_ID_FIELD, (Object)id.toString());
        if (handle != null) {
            doc.addField(HANDLE_FIELD, (Object)handle);
        }
        if (locations != null) {
            for (String location : locations) {
                doc.addField("location", (Object)location);
                if (location.startsWith("m")) {
                    doc.addField("location.comm", (Object)location.substring(1));
                    continue;
                }
                doc.addField("location.coll", (Object)location.substring(1));
            }
        }
        return doc;
    }

    public Date toDate(String t) {
        SimpleDateFormat[] dfArr;
        switch (t.length()) {
            case 1: {
                t = "0" + t;
            }
            case 2: {
                t = "0" + t;
            }
            case 3: {
                t = "0" + t;
            }
            case 4: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy")};
                break;
            }
            case 6: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMM")};
                break;
            }
            case 7: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM")};
                break;
            }
            case 8: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy MMM")};
                break;
            }
            case 10: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd")};
                break;
            }
            case 11: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy MMM dd")};
                break;
            }
            case 20: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")};
                break;
            }
            default: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")};
            }
        }
        for (SimpleDateFormat df : dfArr) {
            try {
                df.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                df.setLenient(false);
                return df.parse(t);
            }
            catch (ParseException pe) {
                log.error((Object)"Unable to parse date format", (Throwable)pe);
            }
        }
        return null;
    }

    public String locationToName(Context context, String field, String value) throws SQLException {
        if ("location.comm".equals(field) || "location.coll".equals(field)) {
            int type = "location.comm".equals(field) ? 4 : 3;
            DSpaceObject commColl = null;
            if (StringUtils.isNotBlank((String)value)) {
                commColl = this.contentServiceFactory.getDSpaceObjectService(type).find(context, UUID.fromString(value));
            }
            if (commColl != null) {
                return commColl.getName();
            }
        }
        return value;
    }

    @Override
    public DiscoverResult search(Context context, DiscoverQuery query) throws SearchServiceException {
        return this.search(context, query, false);
    }

    @Override
    public DiscoverResult search(Context context, DSpaceObject dso, DiscoverQuery query) throws SearchServiceException {
        return this.search(context, dso, query, false);
    }

    @Override
    public DiscoverResult search(Context context, DSpaceObject dso, DiscoverQuery discoveryQuery, boolean includeUnDiscoverable) throws SearchServiceException {
        if (dso != null) {
            if (dso instanceof Community) {
                discoveryQuery.addFilterQueries("location:m" + dso.getID());
            } else if (dso instanceof org.dspace.content.Collection) {
                discoveryQuery.addFilterQueries("location:l" + dso.getID());
            } else if (dso instanceof Item) {
                discoveryQuery.addFilterQueries("handle:" + dso.getHandle());
            }
        }
        return this.search(context, discoveryQuery, includeUnDiscoverable);
    }

    @Override
    public DiscoverResult search(Context context, DiscoverQuery discoveryQuery, boolean includeUnDiscoverable) throws SearchServiceException {
        try {
            if (this.getSolr() == null) {
                return new DiscoverResult();
            }
            SolrQuery solrQuery = this.resolveToSolrQuery(context, discoveryQuery, includeUnDiscoverable);
            QueryResponse queryResponse = this.getSolr().query((SolrParams)solrQuery);
            return this.retrieveResult(context, discoveryQuery, queryResponse);
        }
        catch (Exception e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
    }

    protected SolrQuery resolveToSolrQuery(Context context, DiscoverQuery discoveryQuery, boolean includeUnDiscoverable) {
        int i;
        SolrQuery solrQuery = new SolrQuery();
        String query = "*:*";
        if (discoveryQuery.getQuery() != null) {
            query = discoveryQuery.getQuery();
        }
        solrQuery.setQuery(query);
        for (String string : discoveryQuery.getSearchFields()) {
            solrQuery.addField(string);
        }
        solrQuery.addField(HANDLE_FIELD);
        solrQuery.addField(RESOURCE_TYPE_FIELD);
        solrQuery.addField(RESOURCE_ID_FIELD);
        if (discoveryQuery.isSpellCheck()) {
            solrQuery.setParam("spellcheck.q", new String[]{query});
            solrQuery.setParam("spellcheck.collate", Boolean.TRUE.booleanValue());
            solrQuery.setParam("spellcheck", Boolean.TRUE.booleanValue());
        }
        if (!includeUnDiscoverable) {
            solrQuery.addFilterQuery(new String[]{"NOT(withdrawn:true)"});
            solrQuery.addFilterQuery(new String[]{"NOT(discoverable:false)"});
        }
        for (i = 0; i < discoveryQuery.getFilterQueries().size(); ++i) {
            String string = discoveryQuery.getFilterQueries().get(i);
            solrQuery.addFilterQuery(new String[]{string});
        }
        if (discoveryQuery.getDSpaceObjectFilter() != -1) {
            solrQuery.addFilterQuery(new String[]{"search.resourcetype:" + discoveryQuery.getDSpaceObjectFilter()});
        }
        for (i = 0; i < discoveryQuery.getFieldPresentQueries().size(); ++i) {
            String string = discoveryQuery.getFieldPresentQueries().get(i);
            solrQuery.addFilterQuery(new String[]{string + ":[* TO *]"});
        }
        if (discoveryQuery.getStart() != -1) {
            solrQuery.setStart(Integer.valueOf(discoveryQuery.getStart()));
        }
        if (discoveryQuery.getMaxResults() != -1) {
            solrQuery.setRows(Integer.valueOf(discoveryQuery.getMaxResults()));
        }
        if (discoveryQuery.getSortField() != null) {
            SolrQuery.ORDER order = SolrQuery.ORDER.asc;
            if (discoveryQuery.getSortOrder().equals((Object)DiscoverQuery.SORT_ORDER.desc)) {
                order = SolrQuery.ORDER.desc;
            }
            solrQuery.addSortField(discoveryQuery.getSortField(), order);
        }
        for (String string : discoveryQuery.getProperties().keySet()) {
            List<String> list = discoveryQuery.getProperties().get(string);
            solrQuery.add(string, list.toArray(new String[list.size()]));
        }
        List<DiscoverFacetField> facetFields = discoveryQuery.getFacetFields();
        if (0 < facetFields.size()) {
            for (DiscoverFacetField discoverFacetField : facetFields) {
                String field = this.transformFacetField(discoverFacetField, discoverFacetField.getField(), false);
                solrQuery.addFacetField(new String[]{field});
                solrQuery.add("f." + field + "." + "facet.limit", new String[]{String.valueOf(discoverFacetField.getLimit())});
                String facetSort = DiscoveryConfigurationParameters.SORT.COUNT.equals((Object)discoverFacetField.getSortOrder()) ? "count" : "index";
                solrQuery.add("f." + field + "." + "facet.sort", new String[]{facetSort});
                if (discoverFacetField.getOffset() != -1) {
                    solrQuery.setParam("f." + field + "." + "facet.offset", new String[]{String.valueOf(discoverFacetField.getOffset())});
                }
                if (discoverFacetField.getPrefix() == null) continue;
                solrQuery.setFacetPrefix(field, discoverFacetField.getPrefix());
            }
            List<String> list = discoveryQuery.getFacetQueries();
            for (String facetQuery : list) {
                solrQuery.addFacetQuery(facetQuery);
            }
            if (discoveryQuery.getFacetMinCount() != -1) {
                solrQuery.setFacetMinCount(discoveryQuery.getFacetMinCount());
            }
            solrQuery.setParam("facet.offset", new String[]{String.valueOf(discoveryQuery.getFacetOffset())});
        }
        if (0 < discoveryQuery.getHitHighlightingFields().size()) {
            solrQuery.setHighlight(true);
            solrQuery.add("hl.usePhraseHighlighter", new String[]{Boolean.TRUE.toString()});
            for (DiscoverHitHighlightingField discoverHitHighlightingField : discoveryQuery.getHitHighlightingFields()) {
                solrQuery.addHighlightField(discoverHitHighlightingField.getField() + "_hl");
                solrQuery.add("f." + discoverHitHighlightingField.getField() + "_hl." + "hl.fragsize", new String[]{String.valueOf(discoverHitHighlightingField.getMaxChars())});
                solrQuery.add("f." + discoverHitHighlightingField.getField() + "_hl." + "hl.snippets", new String[]{String.valueOf(discoverHitHighlightingField.getMaxSnippets())});
            }
        }
        List list = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrServiceSearchPlugin.class);
        for (SolrServiceSearchPlugin searchPlugin : list) {
            searchPlugin.additionalSearchParameters(context, discoveryQuery, solrQuery);
        }
        return solrQuery;
    }

    @Override
    public InputStream searchJSON(Context context, DiscoverQuery query, DSpaceObject dso, String jsonIdentifier) throws SearchServiceException {
        if (dso != null) {
            if (dso instanceof Community) {
                query.addFilterQueries("location:m" + dso.getID());
            } else if (dso instanceof org.dspace.content.Collection) {
                query.addFilterQueries("location:l" + dso.getID());
            } else if (dso instanceof Item) {
                query.addFilterQueries("handle:" + dso.getHandle());
            }
        }
        return this.searchJSON(context, query, jsonIdentifier);
    }

    @Override
    public InputStream searchJSON(Context context, DiscoverQuery discoveryQuery, String jsonIdentifier) throws SearchServiceException {
        if (this.getSolr() == null) {
            return null;
        }
        SolrQuery solrQuery = this.resolveToSolrQuery(context, discoveryQuery, false);
        solrQuery.setParam("json.nl", new String[]{"map"});
        solrQuery.setParam("json.wrf", new String[]{jsonIdentifier});
        solrQuery.setParam("wt", new String[]{"json"});
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getSolr().getBaseURL()).append("/select?");
        urlBuilder.append(solrQuery.toString());
        try {
            HttpGet get = new HttpGet(urlBuilder.toString());
            CloseableHttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)get);
            return response.getEntity().getContent();
        }
        catch (Exception e) {
            log.error((Object)"Error while getting json solr result for discovery search recommendation", (Throwable)e);
            return null;
        }
    }

    protected DiscoverResult retrieveResult(Context context, DiscoverQuery query, QueryResponse solrQueryResponse) throws SQLException {
        DiscoverResult result = new DiscoverResult();
        if (solrQueryResponse != null) {
            String recommendedQuery;
            result.setSearchTime(solrQueryResponse.getQTime());
            result.setStart(query.getStart());
            result.setMaxResults(query.getMaxResults());
            result.setTotalSearchResults(solrQueryResponse.getResults().getNumFound());
            List<String> searchFields = query.getSearchFields();
            for (SolrDocument doc : solrQueryResponse.getResults()) {
                Map highlightedFields;
                DSpaceObject dso = this.findDSpaceObject(context, doc);
                if (dso == null) {
                    log.error((Object)LogManager.getHeader(context, "Error while retrieving DSpace object from discovery index", "Handle: " + doc.getFirstValue(HANDLE_FIELD)));
                    continue;
                }
                result.addDSpaceObject(dso);
                DiscoverResult.SearchDocument resultDoc = new DiscoverResult.SearchDocument();
                for (String field : searchFields) {
                    ArrayList<String> valuesAsString = new ArrayList<String>();
                    for (Object o : doc.getFieldValues(field)) {
                        valuesAsString.add(String.valueOf(o));
                    }
                    resultDoc.addSearchField(field, valuesAsString.toArray(new String[valuesAsString.size()]));
                }
                result.addSearchDocument(dso, resultDoc);
                if (solrQueryResponse.getHighlighting() == null || !MapUtils.isNotEmpty((Map)(highlightedFields = (Map)solrQueryResponse.getHighlighting().get(dso.getType() + "-" + dso.getID())))) continue;
                HashMap resultMap = new HashMap();
                for (String key : highlightedFields.keySet()) {
                    resultMap.put(key.substring(0, key.lastIndexOf("_hl")), highlightedFields.get(key));
                }
                result.addHighlightedResult(dso, new DiscoverResult.DSpaceObjectHighlightResult(dso, resultMap));
            }
            List facetFields = solrQueryResponse.getFacetFields();
            if (facetFields != null) {
                for (int i = 0; i < facetFields.size(); ++i) {
                    FacetField facetField = (FacetField)facetFields.get(i);
                    DiscoverFacetField facetFieldConfig = query.getFacetFields().get(i);
                    List facetValues = facetField.getValues();
                    if (facetValues == null) continue;
                    if (facetFieldConfig.getType().equals("date") && facetFieldConfig.getSortOrder().equals((Object)DiscoveryConfigurationParameters.SORT.VALUE)) {
                        Collections.reverse(facetValues);
                    }
                    for (FacetField.Count facetValue : facetValues) {
                        String displayedValue = this.transformDisplayedValue(context, facetField.getName(), facetValue.getName());
                        String field = this.transformFacetField(facetFieldConfig, facetField.getName(), true);
                        String authorityValue = this.transformAuthorityValue(context, facetField.getName(), facetValue.getName());
                        String sortValue = this.transformSortValue(context, facetField.getName(), facetValue.getName());
                        String filterValue = displayedValue;
                        if (StringUtils.isNotBlank((String)authorityValue)) {
                            filterValue = authorityValue;
                        }
                        result.addFacetResult(field, new DiscoverResult.FacetResult(filterValue, displayedValue, authorityValue, sortValue, facetValue.getCount()));
                    }
                }
            }
            if (solrQueryResponse.getFacetQuery() != null) {
                LinkedHashMap sortedFacetQueries = new LinkedHashMap(solrQueryResponse.getFacetQuery());
                for (String facetQuery : sortedFacetQueries.keySet()) {
                    Integer count;
                    String facetField = facetQuery.substring(0, facetQuery.indexOf(":"));
                    String name = "";
                    String filter = "";
                    if (facetQuery.indexOf(91) > -1 && facetQuery.lastIndexOf(93) > -1) {
                        name = facetQuery.substring(facetQuery.indexOf(91) + 1);
                        name = name.substring(0, name.lastIndexOf(93)).replaceAll("TO", "-");
                        filter = facetQuery.substring(facetQuery.indexOf(91));
                        filter = filter.substring(0, filter.lastIndexOf(93) + 1);
                    }
                    if (0 >= (count = (Integer)sortedFacetQueries.get(facetQuery))) continue;
                    result.addFacetResult(facetField, new DiscoverResult.FacetResult(filter, name, null, name, count.intValue()));
                }
            }
            if (solrQueryResponse.getSpellCheckResponse() != null && StringUtils.isNotBlank((String)(recommendedQuery = solrQueryResponse.getSpellCheckResponse().getCollatedResult()))) {
                result.setSpellCheckQuery(recommendedQuery);
            }
        }
        return result;
    }

    protected DSpaceObject findDSpaceObject(Context context, SolrDocument doc) throws SQLException {
        Integer type = (Integer)doc.getFirstValue(RESOURCE_TYPE_FIELD);
        UUID id = UUID.fromString((String)doc.getFirstValue(RESOURCE_ID_FIELD));
        String handle = (String)doc.getFirstValue(HANDLE_FIELD);
        if (type != null && id != null) {
            return this.contentServiceFactory.getDSpaceObjectService(type).find(context, id);
        }
        if (handle != null) {
            return this.handleService.resolveToObject(context, handle);
        }
        return null;
    }

    public InputStream searchAsInputStream(DiscoverQuery query) throws SearchServiceException, IOException {
        if (this.getSolr() == null) {
            return null;
        }
        HttpHost hostURL = (HttpHost)this.getSolr().getHttpClient().getParams().getParameter("http.default-host");
        HttpGet method = new HttpGet(hostURL.toHostString() + "");
        try {
            URI uRI = new URIBuilder(method.getURI()).addParameter("q", query.toString()).build();
        }
        catch (URISyntaxException e) {
            throw new SearchServiceException(e);
        }
        HttpResponse response = this.getSolr().getHttpClient().execute((HttpUriRequest)method);
        return response.getEntity().getContent();
    }

    public List<DSpaceObject> search(Context context, String query, int offset, int max, String ... filterquery) {
        return this.search(context, query, null, true, offset, max, filterquery);
    }

    @Override
    public List<DSpaceObject> search(Context context, String query, String orderfield, boolean ascending, int offset, int max, String ... filterquery) {
        try {
            if (this.getSolr() == null) {
                return Collections.emptyList();
            }
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(query);
            solrQuery.setFields(new String[]{RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD});
            solrQuery.setStart(Integer.valueOf(offset));
            solrQuery.setRows(Integer.valueOf(max));
            if (orderfield != null) {
                solrQuery.setSortField(orderfield, ascending ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            }
            if (filterquery != null) {
                solrQuery.addFilterQuery(filterquery);
            }
            QueryResponse rsp = this.getSolr().query((SolrParams)solrQuery);
            SolrDocumentList docs = rsp.getResults();
            Iterator iter = docs.iterator();
            ArrayList<DSpaceObject> result = new ArrayList<DSpaceObject>();
            while (iter.hasNext()) {
                SolrDocument doc = (SolrDocument)iter.next();
                Object o = this.contentServiceFactory.getDSpaceObjectService((Integer)doc.getFirstValue(RESOURCE_TYPE_FIELD)).find(context, UUID.fromString((String)doc.getFirstValue(RESOURCE_ID_FIELD)));
                if (o == null) continue;
                result.add((DSpaceObject)o);
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while quering solr", "Queyr: " + query), (Throwable)e);
            return new ArrayList<DSpaceObject>(0);
        }
    }

    @Override
    public DiscoverFilterQuery toFilterQuery(Context context, String field, String operator, String value) throws SQLException {
        DiscoverFilterQuery result = new DiscoverFilterQuery();
        StringBuilder filterQuery = new StringBuilder();
        if (StringUtils.isNotBlank((String)field) && StringUtils.isNotBlank((String)value)) {
            filterQuery.append(field);
            if ("equals".equals(operator)) {
                filterQuery.append("_keyword");
            } else if ("authority".equals(operator)) {
                filterQuery.append("_authority");
            } else if ("notequals".equals(operator) || "notcontains".equals(operator) || "notauthority".equals(operator)) {
                filterQuery.insert(0, "-");
            }
            filterQuery.append(":");
            if ("equals".equals(operator) || "notequals".equals(operator)) {
                if (!value.matches("\\[.*TO.*\\]")) {
                    value = ClientUtils.escapeQueryChars((String)value);
                    filterQuery.append(value);
                } else {
                    if (value.matches("\\[\\d{1,4} TO \\d{1,4}\\]")) {
                        int minRange = Integer.parseInt(value.substring(1, value.length() - 1).split(" TO ")[0]);
                        int maxRange = Integer.parseInt(value.substring(1, value.length() - 1).split(" TO ")[1]);
                        value = "[" + String.format("%04d", minRange) + " TO " + String.format("%04d", maxRange) + "]";
                    }
                    filterQuery.append(value);
                }
            } else if (!value.matches("\\[.*TO.*\\]")) {
                value = ClientUtils.escapeQueryChars((String)value);
                filterQuery.append("(").append(value).append(")");
            } else {
                filterQuery.append(value);
            }
            result.setDisplayedValue(this.transformDisplayedValue(context, field, value));
        }
        result.setFilterQuery(filterQuery.toString());
        return result;
    }

    @Override
    public List<Item> getRelatedItems(Context context, Item item, DiscoveryMoreLikeThisConfiguration mltConfig) {
        ArrayList<Item> results = new ArrayList<Item>();
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery("handle: " + item.getHandle());
            solrQuery.setFields(new String[]{HANDLE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD});
            solrQuery.setParam("mlt", true);
            Collection similarityMetadataFields = CollectionUtils.collect(mltConfig.getSimilarityMetadataFields(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return input + "_mlt";
                }
            });
            solrQuery.setParam("mlt.fl", new String[]{StringUtils.join((Collection)similarityMetadataFields, (char)',')});
            solrQuery.setParam("mlt.mintf", new String[]{String.valueOf(mltConfig.getMinTermFrequency())});
            solrQuery.setParam("mlt.count", new String[]{String.valueOf(mltConfig.getMax())});
            solrQuery.setParam("mlt.minwl", new String[]{String.valueOf(mltConfig.getMinWordLength())});
            if (this.getSolr() == null) {
                return Collections.emptyList();
            }
            QueryResponse rsp = this.getSolr().query((SolrParams)solrQuery);
            NamedList mltResults = (NamedList)rsp.getResponse().get("moreLikeThis");
            if (mltResults != null && mltResults.get(item.getType() + "-" + item.getID()) != null) {
                SolrDocumentList relatedDocs = (SolrDocumentList)mltResults.get(item.getType() + "-" + item.getID());
                for (Object relatedDoc : relatedDocs) {
                    SolrDocument relatedDocument = (SolrDocument)relatedDoc;
                    DSpaceObject relatedItem = this.findDSpaceObject(context, relatedDocument);
                    if (relatedItem.getType() != 2) continue;
                    results.add((Item)relatedItem);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while retrieving related items", "Handle: " + item.getHandle()), (Throwable)e);
        }
        return results;
    }

    @Override
    public String toSortFieldIndex(String metadataField, String type) {
        if (type.equals("date")) {
            return metadataField + "_dt";
        }
        return metadataField + "_sort";
    }

    protected String transformFacetField(DiscoverFacetField facetFieldConfig, String field, boolean removePostfix) {
        if (facetFieldConfig.getType().equals("text")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_filter"));
            }
            return field + "_filter";
        }
        if (facetFieldConfig.getType().equals("date")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf(".year"));
            }
            return field + ".year";
        }
        if (facetFieldConfig.getType().equals("ac")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_ac"));
            }
            return field + "_ac";
        }
        if (facetFieldConfig.getType().equals("hierarchical")) {
            if (removePostfix) {
                return StringUtils.substringBeforeLast((String)field, (String)"_tax_");
            }
            return field + "_tax_0_filter";
        }
        if (facetFieldConfig.getType().equals("authority")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_acid"));
            }
            return field + "_acid";
        }
        if (facetFieldConfig.getType().equals("standard")) {
            return field;
        }
        return field;
    }

    protected String transformDisplayedValue(Context context, String field, String value) throws SQLException {
        if (field.equals("location.comm") || field.equals("location.coll")) {
            value = this.locationToName(context, field, value);
        } else if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid")) {
            int start;
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuffer valueBuffer = new StringBuffer();
            for (int i = start = fqParts.length / 2; i < fqParts.length; ++i) {
                String[] split = fqParts[i].split("###", 2);
                valueBuffer.append(split[0]);
            }
            value = valueBuffer.toString();
        } else if (value.matches("\\((.*?)\\)")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected String transformAuthorityValue(Context context, String field, String value) throws SQLException {
        if (field.equals("location.comm") || field.equals("location.coll")) {
            return value;
        }
        if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid")) {
            int start;
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuffer authorityBuffer = new StringBuffer();
            for (int i = start = fqParts.length / 2; i < fqParts.length; ++i) {
                String[] split = fqParts[i].split("###", 2);
                if (split.length != 2) continue;
                authorityBuffer.append(split[1]);
            }
            if (authorityBuffer.length() > 0) {
                return authorityBuffer.toString();
            }
        }
        return null;
    }

    protected String transformSortValue(Context context, String field, String value) throws SQLException {
        if (field.equals("location.comm") || field.equals("location.coll")) {
            value = this.locationToName(context, field, value);
        } else if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid")) {
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuffer valueBuffer = new StringBuffer();
            int end = fqParts.length / 2;
            for (int i = 0; i < end; ++i) {
                valueBuffer.append(fqParts[i]);
            }
            value = valueBuffer.toString();
        } else if (value.matches("\\((.*?)\\)")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    @Override
    public void indexContent(Context context, DSpaceObject dso, boolean force, boolean commit) throws SearchServiceException, SQLException {
        this.indexContent(context, dso, force);
        if (commit) {
            this.commit();
        }
    }

    @Override
    public void commit() throws SearchServiceException {
        try {
            if (this.getSolr() != null) {
                this.getSolr().commit();
            }
        }
        catch (Exception e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
    }

    @Override
    public String escapeQueryChars(String query) {
        return ClientUtils.escapeQueryChars((String)query);
    }
}

