/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.identifier.DOI;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.dao.DOIDAO;
import org.dspace.identifier.doi.DOIIdentifierException;
import org.dspace.identifier.service.DOIService;
import org.springframework.beans.factory.annotation.Autowired;

public class DOIServiceImpl
implements DOIService {
    @Autowired(required=true)
    protected DOIDAO doiDAO;

    protected DOIServiceImpl() {
    }

    @Override
    public void update(Context context, DOI doi) throws SQLException {
        this.doiDAO.save(context, doi);
    }

    @Override
    public DOI create(Context context) throws SQLException {
        return this.doiDAO.create(context, new DOI());
    }

    @Override
    public DOI findByDoi(Context context, String doi) throws SQLException {
        return this.doiDAO.findByDoi(context, doi);
    }

    @Override
    public DOI findDOIByDSpaceObject(Context context, DSpaceObject dso) throws SQLException {
        return this.doiDAO.findDOIByDSpaceObject(context, dso);
    }

    @Override
    public DOI findDOIByDSpaceObject(Context context, DSpaceObject dso, List<Integer> statusToExclude) throws SQLException {
        return this.doiDAO.findDOIByDSpaceObject(context, dso, statusToExclude);
    }

    @Override
    public String DOIToExternalForm(String identifier) throws IdentifierException {
        if (null == identifier) {
            throw new IllegalArgumentException("Identifier is null.", new NullPointerException());
        }
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Cannot format an empty identifier.");
        }
        if (identifier.startsWith("doi:")) {
            return "http://dx.doi.org/" + identifier.substring("doi:".length());
        }
        if (identifier.startsWith("10.") && identifier.contains("/")) {
            return "http://dx.doi.org/" + identifier;
        }
        if (identifier.startsWith("http://dx.doi.org/10.")) {
            return identifier;
        }
        throw new IdentifierException(identifier + "does not seem to be a DOI.");
    }

    @Override
    public String DOIFromExternalFormat(String identifier) throws DOIIdentifierException {
        Pattern pattern = Pattern.compile("^http://dx.doi.org/+(10\\..*)$");
        Matcher matcher = pattern.matcher(identifier);
        if (matcher.find()) {
            return "doi:" + matcher.group(1);
        }
        throw new DOIIdentifierException("Cannot recognize DOI!", 11);
    }

    @Override
    public String formatIdentifier(String identifier) throws DOIIdentifierException {
        if (null == identifier) {
            throw new IllegalArgumentException("Identifier is null.", new NullPointerException());
        }
        if (identifier.startsWith("doi:")) {
            return identifier;
        }
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Cannot format an empty identifier.");
        }
        if (identifier.startsWith("10.") && identifier.contains("/")) {
            return "doi:" + identifier;
        }
        if (identifier.startsWith("http://dx.doi.org/10.")) {
            return "doi:" + identifier.substring(18);
        }
        throw new DOIIdentifierException(identifier + "does not seem to be a DOI.", 11);
    }

    @Override
    public List<DOI> getDOIsByStatus(Context context, List<Integer> statuses) throws SQLException {
        return this.doiDAO.findByStatus(context, statuses);
    }

    @Override
    public List<DOI> getSimilarDOIsNotInState(Context context, String doiPattern, List<Integer> statuses, boolean dsoIsNotNull) throws SQLException {
        return this.doiDAO.findSimilarNotInState(context, doiPattern, statuses, dsoIsNotNull);
    }
}

