/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.Handle;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionedHandleIdentifierProvider
extends IdentifierProvider {
    private static Logger log = Logger.getLogger(VersionedHandleIdentifierProvider.class);
    static final String EXAMPLE_PREFIX = "123456789";
    private static final char DOT = '.';
    @Autowired(required=true)
    private VersioningService versionService;
    @Autowired(required=true)
    private VersionHistoryService versionHistoryService;
    @Autowired(required=true)
    private HandleService handleService;
    @Autowired(required=true)
    private ItemService itemService;

    @Override
    public boolean supports(Class<? extends Identifier> identifier) {
        return Handle.class.isAssignableFrom(identifier);
    }

    @Override
    public boolean supports(String identifier) {
        String[] additionalPrefixes;
        String prefix = this.handleService.getPrefix();
        String canonicalPrefix = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("handle.canonical.prefix");
        if (identifier == null) {
            return false;
        }
        if (identifier.startsWith(prefix + "/") || identifier.startsWith(canonicalPrefix) || identifier.startsWith("hdl:") || identifier.startsWith("info:hdl") || identifier.matches("^https?://hdl\\.handle\\.net/.*") || identifier.matches("^https?://.+/handle/.*")) {
            return true;
        }
        for (String additionalPrefix : additionalPrefixes = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("handle.additional.prefixes")) {
            if (!identifier.startsWith(additionalPrefix + "/")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String register(Context context, DSpaceObject dso) {
        String id = this.mint(context, dso);
        try {
            if (dso instanceof Item) {
                this.populateHandleMetadata(context, (Item)dso, id);
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + (dso != null ? dso.getID() : "")), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + (dso != null ? dso.getID() : ""));
        }
        return id;
    }

    @Override
    public void register(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        if (dso instanceof Item && identifier != null) {
            Item item = (Item)dso;
            Matcher versionHandleMatcher = Pattern.compile("^.*/.*\\.(\\d+)$").matcher(identifier);
            if (versionHandleMatcher.matches()) {
                int versionNumber = -1;
                try {
                    versionNumber = Integer.valueOf(versionHandleMatcher.group(1));
                }
                catch (NumberFormatException ex) {
                    throw new IllegalStateException("Cannot detect the interger value of a digit.", ex);
                }
                VersionHistory history = null;
                try {
                    history = this.versionHistoryService.findByItem(context, item);
                }
                catch (SQLException ex) {
                    throw new RuntimeException("Unable to create handle '" + identifier + "' for " + Constants.typeText[dso.getType()] + " " + dso.getID() + " in cause of a problem with the database: ", ex);
                }
                if (history != null) {
                    Version version = null;
                    try {
                        this.versionHistoryService.getVersion(context, history, item);
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException("Problem with the database connection occurd.", ex);
                    }
                    if (version != null) {
                        if (version.getVersionNumber() != versionNumber) {
                            throw new IdentifierException("Trying to register a handle without matching its item's version number.");
                        }
                        try {
                            this.handleService.createHandle(context, dso, identifier);
                            this.populateHandleMetadata(context, item, identifier);
                            return;
                        }
                        catch (AuthorizeException ex) {
                            throw new IdentifierException("Current user does not have the privileges to add the handle " + identifier + " to the item's (" + dso.getID() + ") metadata.", ex);
                        }
                        catch (IOException | SQLException ex) {
                            throw new RuntimeException("Unable to create handle '" + identifier + "' for " + Constants.typeText[dso.getType()] + " " + dso.getID() + ".", ex);
                        }
                    }
                } else {
                    try {
                        this.restoreItAsVersion(context, item, identifier, versionNumber);
                    }
                    catch (IOException | SQLException ex) {
                        throw new RuntimeException("Unable to restore a versioned handle as there was a problem in creating a neccessary item version: ", ex);
                    }
                    catch (AuthorizeException ex) {
                        throw new RuntimeException("Unable to restore a versioned handle as the current user was not allowed to create a neccessary item version: ", ex);
                    }
                    return;
                }
            }
        }
        try {
            this.createNewIdentifier(context, dso, identifier);
            if (dso instanceof Item) {
                this.populateHandleMetadata(context, (Item)dso, identifier);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Unable to create handle '" + identifier + "' for " + Constants.typeText[dso.getType()] + " " + dso.getID() + " in cause of a problem with the database: ", ex);
        }
        catch (AuthorizeException ex) {
            throw new IdentifierException("Current user does not have the privileges to add the handle " + identifier + " to the item's (" + dso.getID() + ") metadata.", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable add the handle '" + identifier + "' for " + Constants.typeText[dso.getType()] + " " + dso.getID() + " in the object's metadata.", ex);
        }
    }

    protected VersionHistory getHistory(Context context, String identifier) throws SQLException {
        DSpaceObject item = this.resolve(context, identifier, new String[0]);
        if (item != null) {
            VersionHistory history = this.versionHistoryService.findByItem(context, (Item)item);
            return history;
        }
        return null;
    }

    protected void restoreItAsVersion(Context context, Item item, String identifier, int versionNumber) throws SQLException, AuthorizeException, IOException {
        Version version;
        this.createNewIdentifier(context, item, identifier);
        this.populateHandleMetadata(context, item, identifier);
        VersionHistory vh = this.versionHistoryService.findByItem(context, item);
        if (vh == null) {
            vh = (VersionHistory)this.versionHistoryService.create(context);
        }
        if ((version = this.versionHistoryService.getVersion(context, vh, item)) == null) {
            version = this.versionService.createNewVersion(context, vh, item, "Restoring from AIP Service", new Date(), versionNumber);
        }
        this.versionHistoryService.update(context, vh);
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) {
        try {
            this.handleService.createHandle(context, dso, identifier);
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public String mint(Context context, DSpaceObject dso) {
        if (dso.getHandle() != null) {
            return dso.getHandle();
        }
        try {
            String handleId = null;
            VersionHistory history = null;
            if (dso instanceof Item) {
                history = this.versionHistoryService.findByItem(context, (Item)dso);
            }
            handleId = history != null ? this.makeIdentifierBasedOnHistory(context, dso, history) : this.createNewIdentifier(context, dso, null);
            return handleId;
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier, String ... attributes) {
        try {
            return this.handleService.resolveToObject(context, identifier);
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while resolving handle to item", "handle: " + identifier), (Throwable)e);
            return null;
        }
    }

    @Override
    public String lookup(Context context, DSpaceObject dso) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        try {
            return this.handleService.findHandle(context, dso);
        }
        catch (SQLException sqe) {
            throw new IdentifierNotResolvableException(sqe.getMessage(), sqe);
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        this.delete(context, dso);
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
        try {
            this.handleService.unbindHandle(context, dso);
        }
        catch (SQLException sqe) {
            throw new RuntimeException(sqe.getMessage(), sqe);
        }
    }

    public static String retrieveHandleOutOfUrl(String url) throws SQLException {
        if (!url.contains("/")) {
            return null;
        }
        String[] splitUrl = url.split("/");
        return splitUrl[splitUrl.length - 2] + "/" + splitUrl[splitUrl.length - 1];
    }

    public static String getPrefix() {
        String prefix = ConfigurationManager.getProperty("handle.prefix");
        if (null == prefix) {
            prefix = EXAMPLE_PREFIX;
            log.error((Object)("handle.prefix is not configured; using " + prefix));
        }
        return prefix;
    }

    protected static String getCanonicalForm(String handle) {
        String handlePrefix = ConfigurationManager.getProperty("handle.canonical.prefix");
        if (handlePrefix == null || handlePrefix.length() == 0) {
            handlePrefix = "http://hdl.handle.net/";
        }
        return handlePrefix + handle;
    }

    protected String createNewIdentifier(Context context, DSpaceObject dso, String handleId) throws SQLException {
        if (handleId == null) {
            return this.handleService.createHandle(context, dso);
        }
        return this.handleService.createHandle(context, dso, handleId);
    }

    protected String makeIdentifierBasedOnHistory(Context context, DSpaceObject dso, VersionHistory history) throws AuthorizeException, SQLException {
        if (!(dso instanceof Item)) {
            throw new IllegalStateException("Cannot create versioned handle for objects other then item: Currently versioning supports items only.");
        }
        Item item = (Item)dso;
        Version version = this.versionService.getVersion(context, item);
        Version firstVersion = this.versionHistoryService.getFirstVersion(context, history);
        String bareHandle = firstVersion.getItem().getHandle();
        if (bareHandle.matches(".*/.*\\.\\d+")) {
            bareHandle = bareHandle.substring(0, bareHandle.lastIndexOf(46));
        }
        int versionNumber = version.getVersionNumber();
        String identifier = bareHandle;
        if (versionNumber > 1) {
            identifier = identifier.concat(String.valueOf('.')).concat(String.valueOf(versionNumber));
        }
        if (this.handleService.resolveToObject(context, identifier) != null) {
            throw new IllegalStateException("A versioned handle is used for another version already!");
        }
        this.handleService.createHandle(context, dso, identifier);
        return identifier;
    }

    protected void populateHandleMetadata(Context context, Item item, String handle) throws SQLException, IOException, AuthorizeException {
        String handleref = VersionedHandleIdentifierProvider.getCanonicalForm(handle);
        List<MetadataValue> identifiers = this.itemService.getMetadata(item, "dc", "identifier", "uri", "*");
        this.itemService.clearMetadata(context, item, "dc", "identifier", "uri", "*");
        for (MetadataValue identifier : identifiers) {
            if (this.supports(identifier.getValue())) {
                log.debug((Object)("Removing identifier " + identifier.getValue()));
                continue;
            }
            log.debug((Object)("Preserving identifier " + identifier.getValue()));
            this.itemService.addMetadata(context, item, identifier.getMetadataField(), identifier.getLanguage(), identifier.getValue(), identifier.getAuthority(), identifier.getConfidence());
        }
        if (StringUtils.isNotBlank((CharSequence)handleref)) {
            this.itemService.addMetadata(context, item, "dc", "identifier", "uri", null, handleref);
        }
        this.itemService.update(context, item);
    }
}

