/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.dspace.curate.Curator;
import org.dspace.submit.AbstractProcessingStep;

public class UploadStep
extends AbstractProcessingStep {
    public static final String SUBMIT_UPLOAD_BUTTON = "submit_upload";
    public static final String SUBMIT_SKIP_BUTTON = "submit_skip";
    public static final String SUBMIT_MORE_BUTTON = "submit_more";
    public static final String CANCEL_EDIT_BUTTON = "submit_edit_cancel";
    public static final int STATUS_INTEGRITY_ERROR = 1;
    public static final int STATUS_UPLOAD_ERROR = 2;
    public static final int STATUS_NO_FILES_ERROR = 5;
    public static final int STATUS_UNKNOWN_FORMAT = 10;
    public static final int STATUS_VIRUS_CHECKER_UNAVAILABLE = 14;
    public static final int STATUS_CONTAINS_VIRUS = 16;
    public static final int STATUS_EDIT_BITSTREAM = 20;
    public static final int STATUS_EDIT_COMPLETE = 25;
    private static final Logger log = Logger.getLogger(UploadStep.class);
    protected boolean fileRequired;
    protected BitstreamFormatService bitstreamFormatService;

    public UploadStep() {
        this.fileRequired = this.configurationService.getBooleanProperty("webui.submit.upload.required", true);
        this.bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    }

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        List<Bundle> bundles;
        int status;
        int status2;
        int status3;
        String buttonPressed = Util.getSubmitButton(request, "submit_next");
        Item item = subInfo.getSubmissionItem().getItem();
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1 && (status3 = this.processUploadFile(context, request, response, subInfo)) != 0) {
            return status3;
        }
        if (buttonPressed.startsWith("submit_jump_") || buttonPressed.startsWith("submit_prev")) {
            if (this.fileRequired && !this.itemService.hasUploadedFiles(item)) {
                return 5;
            }
            return 0;
        }
        if (request.getParameter("bitstream_id") != null) {
            if (buttonPressed.equals(CANCEL_EDIT_BUTTON)) {
                subInfo.setBitstream(null);
                return 25;
            }
            Bitstream b = (Bitstream)this.bitstreamService.find(context, Util.getUUIDParameter(request, "bitstream_id"));
            subInfo.setBitstream(b);
        } else if (buttonPressed.startsWith("submit_edit_")) {
            String bitstreamID = buttonPressed.substring("submit_edit_".length());
            Bitstream b = (Bitstream)this.bitstreamService.find(context, UUID.fromString(bitstreamID));
            subInfo.setBitstream(b);
            return 20;
        }
        if (buttonPressed.equalsIgnoreCase("submit_remove_selected")) {
            if (request.getParameter("remove") != null) {
                String[] removeIDs = request.getParameterValues("remove");
                for (int i = 0; i < removeIDs.length; ++i) {
                    UUID id = UUID.fromString(removeIDs[i]);
                    status2 = this.processRemoveFile(context, item, id);
                    if (status2 == 0) continue;
                    return status2;
                }
                subInfo.setBitstream(null);
            }
        } else if (buttonPressed.startsWith("submit_remove_")) {
            UUID id = UUID.fromString(buttonPressed.substring(14));
            int status4 = this.processRemoveFile(context, item, id);
            if (status4 != 0) {
                return status4;
            }
            subInfo.setBitstream(null);
        }
        Enumeration parameterNames = request.getParameterNames();
        HashMap<String, String> descriptions = new HashMap<String, String>();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            if (!StringUtils.startsWithIgnoreCase((String)name, (String)"description[")) continue;
            descriptions.put(name.substring("description[".length(), name.length() - 1), request.getParameter(name));
        }
        if (!descriptions.isEmpty()) {
            if (item != null) {
                List<Bundle> bundles2 = this.itemService.getBundles(item, "ORIGINAL");
                for (Bundle bundle : bundles2) {
                    List<Bitstream> bitstreams = bundle.getBitstreams();
                    for (Bitstream bitstream : bitstreams) {
                        if (!descriptions.containsKey(bitstream.getName())) continue;
                        bitstream.setDescription(context, (String)descriptions.get(bitstream.getName()));
                        this.bitstreamService.update(context, bitstream);
                    }
                }
            }
            return 0;
        }
        String fileDescription = request.getParameter("description");
        if (fileDescription != null && fileDescription.length() > 0 && (status2 = this.processSaveFileDescription(context, request, response, subInfo)) != 0) {
            return status2;
        }
        int formatTypeID = Util.getIntParameter(request, "format");
        String formatDesc = request.getParameter("format_description");
        if ((formatTypeID >= 0 || formatDesc != null && formatDesc.length() > 0) && (status = this.processSaveFileFormat(context, request, response, subInfo)) != 0) {
            return status;
        }
        if (request.getParameter("primary_bitstream_id") != null && (bundles = this.itemService.getBundles(item, "ORIGINAL")).size() > 0) {
            bundles.get(0).setPrimaryBitstreamID((Bitstream)this.bitstreamService.find(context, Util.getUUIDParameter(request, "primary_bitstream_id")));
            this.bundleService.update(context, (DSpaceObject)bundles.get(0));
        }
        if (this.fileRequired && !this.itemService.hasUploadedFiles(item) && !buttonPressed.equals(SUBMIT_MORE_BUTTON)) {
            return 5;
        }
        context.dispatchEvents();
        return 0;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }

    protected int processRemoveFile(Context context, Item item, UUID bitstreamID) throws IOException, SQLException, AuthorizeException {
        Bitstream bitstream;
        try {
            bitstream = (Bitstream)this.bitstreamService.find(context, bitstreamID);
        }
        catch (NumberFormatException nfe) {
            bitstream = null;
        }
        if (bitstream == null) {
            return 1;
        }
        List<Bundle> bundles = bitstream.getBundles();
        Bundle bundle = bundles.get(0);
        this.bundleService.removeBitstream(context, bundle, bitstream);
        List<Bitstream> bitstreams = bundle.getBitstreams();
        if (bitstreams.size() < 1) {
            this.itemService.removeBundle(context, item, bundle);
            this.itemService.update(context, item);
        }
        return 0;
    }

    public int processUploadFile(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean formatKnown = true;
        boolean fileOK = false;
        BitstreamFormat bf = null;
        Bitstream b = null;
        Enumeration attNames = request.getAttributeNames();
        while (attNames.hasMoreElements()) {
            String attr = (String)attNames.nextElement();
            if (!attr.endsWith("-path")) continue;
            String param = attr.replace("-path", "");
            String filePath = (String)request.getAttribute(param + "-path");
            InputStream fileInputStream = (InputStream)request.getAttribute(param + "-inputstream");
            String fileDescription = (String)request.getAttribute(param + "-description");
            if (fileDescription == null || fileDescription.length() == 0) {
                fileDescription = request.getParameter("description");
            }
            if (filePath == null || fileInputStream == null) {
                return 2;
            }
            if (subInfo == null) {
                return 1;
            }
            Item item = subInfo.getSubmissionItem().getItem();
            List<Bundle> bundles = this.itemService.getBundles(item, "ORIGINAL");
            b = bundles.size() < 1 ? this.itemService.createSingleBitstream(context, fileInputStream, item, "ORIGINAL") : this.bitstreamService.create(context, bundles.get(0), fileInputStream);
            String noPath = filePath;
            while (noPath.indexOf(47) > -1) {
                noPath = noPath.substring(noPath.indexOf(47) + 1);
            }
            while (noPath.indexOf(92) > -1) {
                noPath = noPath.substring(noPath.indexOf(92) + 1);
            }
            b.setName(context, noPath);
            b.setSource(context, filePath);
            b.setDescription(context, fileDescription);
            bf = this.bitstreamFormatService.guessFormat(context, b);
            b.setFormat(context, bf);
            this.bitstreamService.update(context, b);
            this.itemService.update(context, item);
            if (bf != null && bf.isInternal()) {
                log.warn((Object)"Attempt to upload file format marked as internal system use only");
                this.backoutBitstream(context, subInfo, b, item);
                return 2;
            }
            if (this.configurationService.getBooleanProperty("submission-curation.virus-scan")) {
                Curator curator = new Curator();
                curator.addTask("vscan").curate(context, item);
                int status = curator.getStatus("vscan");
                if (status == -1) {
                    this.backoutBitstream(context, subInfo, b, item);
                    return 14;
                }
                if (status == 1) {
                    this.backoutBitstream(context, subInfo, b, item);
                    return 16;
                }
            }
            context.dispatchEvents();
            subInfo.setBitstream(b);
            if (bf != null) continue;
            return 10;
        }
        return 0;
    }

    protected void backoutBitstream(Context context, SubmissionInfo subInfo, Bitstream b, Item item) throws SQLException, AuthorizeException, IOException {
        List<Bundle> bundles = b.getBundles();
        if (bundles.isEmpty()) {
            throw new SQLException("Bitstream is not in any Bundles.");
        }
        Bundle firstBundle = bundles.get(0);
        this.bundleService.removeBitstream(context, firstBundle, b);
        List<Bitstream> bitstreams = firstBundle.getBitstreams();
        if (bitstreams.isEmpty()) {
            this.itemService.removeBundle(context, item, firstBundle);
            this.itemService.update(context, item);
        } else {
            this.bundleService.update(context, firstBundle);
        }
        subInfo.setBitstream(null);
    }

    protected int processSaveFileFormat(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        if (subInfo.getBitstream() != null) {
            int typeID = Util.getIntParameter(request, "format");
            BitstreamFormat format = (BitstreamFormat)this.bitstreamFormatService.find(context, typeID);
            if (format != null) {
                subInfo.getBitstream().setFormat(context, format);
            } else {
                String userDesc = request.getParameter("format_description");
                subInfo.getBitstream().setUserFormatDescription(context, userDesc);
            }
        } else {
            return 1;
        }
        this.bitstreamService.update(context, subInfo.getBitstream());
        return 0;
    }

    protected int processSaveFileDescription(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        if (subInfo.getBitstream() == null) {
            return 1;
        }
        subInfo.getBitstream().setDescription(context, request.getParameter("description"));
        this.bitstreamService.update(context, subInfo.getBitstream());
        context.dispatchEvents();
        return 0;
    }
}

