/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic.dao.impl;

import java.sql.SQLException;
import java.util.List;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.dao.BasicWorkflowItemDAO;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class BasicWorkflowItemDAOImpl
extends AbstractHibernateDAO<BasicWorkflowItem>
implements BasicWorkflowItemDAO {
    protected BasicWorkflowItemDAOImpl() {
    }

    @Override
    public BasicWorkflowItem findByItem(Context context, Item i) throws SQLException {
        Criteria criteria = this.createCriteria(context, BasicWorkflowItem.class);
        criteria.add((Criterion)Restrictions.eq((String)"item", (Object)i));
        return (BasicWorkflowItem)this.uniqueResult(criteria);
    }

    @Override
    public List<BasicWorkflowItem> findBySubmitter(Context context, EPerson ep) throws SQLException {
        Criteria criteria = this.createCriteria(context, BasicWorkflowItem.class);
        criteria.createAlias("item", "i");
        criteria.add((Criterion)Restrictions.eq((String)"i.submitter", (Object)ep));
        criteria.addOrder(Order.asc((String)"workflowitemId"));
        return this.list(criteria);
    }

    @Override
    public List<BasicWorkflowItem> findByCollection(Context context, Collection c) throws SQLException {
        Criteria criteria = this.createCriteria(context, BasicWorkflowItem.class);
        criteria.add((Criterion)Restrictions.eq((String)"collection", (Object)c));
        return this.list(criteria);
    }

    @Override
    public List<BasicWorkflowItem> findByPooledTasks(Context context, EPerson ePerson) throws SQLException {
        String queryString = "select wf from TaskListItem as tli join tli.workflowItem wf where tli.ePerson = :eperson ORDER BY wf.workflowitemId";
        Query query = this.createQuery(context, queryString);
        query.setParameter("eperson", (Object)ePerson);
        return this.list(query);
    }

    @Override
    public List<BasicWorkflowItem> findByOwner(Context context, EPerson ePerson) throws SQLException {
        Criteria criteria = this.createCriteria(context, BasicWorkflowItem.class);
        criteria.add((Criterion)Restrictions.eq((String)"owner", (Object)ePerson));
        return this.list(criteria);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM BasicWorkflowItem"));
    }
}

