/*
 * Decompiled with CFR 0.152.
 */
package org.dspace;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.app.util.MockUtil;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class AbstractDSpaceTest {
    private static final Logger log = Logger.getLogger(AbstractDSpaceTest.class);
    protected static Properties testProps;
    protected static DSpaceKernelImpl kernelImpl;

    @BeforeClass
    public static void initKernel() {
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("Europe/Dublin"));
            testProps = new Properties();
            URL properties = AbstractUnitTest.class.getClassLoader().getResource("test-config.properties");
            testProps.load(properties.openStream());
            kernelImpl = DSpaceKernelInit.getKernel(null);
            if (!kernelImpl.isRunning()) {
                kernelImpl.start(System.getProperty("dspace.dir"));
            }
            new MockUtil();
        }
        catch (IOException ex) {
            log.error((Object)"Error initializing tests", (Throwable)ex);
            Assert.fail((String)("Error initializing tests: " + ex.getMessage()));
        }
    }

    @AfterClass
    public static void destroyKernel() throws SQLException {
        testProps.clear();
        testProps = null;
        if (kernelImpl != null) {
            kernelImpl.destroy();
        }
        kernelImpl = null;
    }
}

