/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.commons.io.Charsets;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.app.util.GoogleMetadata;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.core.ReloadableEntity;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GoogleMetadataTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(GoogleMetadataTest.class);
    private Item it;
    private BundleService bundleService;
    private BitstreamFormatService bitstreamFormatService;
    private BitstreamService bitstreamService;
    private Community community;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.community = ContentServiceFactory.getInstance().getCommunityService().create(null, this.context);
            Collection collection = ContentServiceFactory.getInstance().getCollectionService().create(this.context, this.community);
            WorkspaceItem wi = ContentServiceFactory.getInstance().getWorkspaceItemService().create(this.context, collection, true);
            Item item = wi.getItem();
            ContentServiceFactory.getInstance().getInstallItemService().installItem(this.context, (InProgressSubmission)wi, null);
            this.context.restoreAuthSystemState();
            this.context.commit();
            this.it = item;
            this.bundleService = ContentServiceFactory.getInstance().getBundleService();
            this.bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
            this.bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGetPDFURLDifferentMimeTypes() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Bitstream 1".getBytes(Charsets.UTF_8)));
        b.setName(this.context, "Word");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("application/msword");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Bitstream 2".getBytes(Charsets.UTF_8)));
        b2.setName(this.context, "Pdf");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Bitstream 3".getBytes(Charsets.UTF_8)));
        b3.setName(this.context, "Rtf");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("text/richtext");
        this.bundleService.addBitstream(this.context, bundle, b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        String[] urlSplitted = ((String)gm.getPDFURL().get(0)).split("/");
        Assert.assertEquals((Object)"Pdf", (Object)urlSplitted[urlSplitted.length - 1]);
    }

    @Test
    public void testGetPDFURLSameMimeTypes() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("123456789".getBytes(Charsets.UTF_8)));
        b.setName(this.context, "size9");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("1".getBytes(Charsets.UTF_8)));
        b2.setName(this.context, "size1");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("12345".getBytes(Charsets.UTF_8)));
        b3.setName(this.context, "size5");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("text/richtext");
        this.bundleService.addBitstream(this.context, bundle, b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        String[] urlSplitted = ((String)gm.getPDFURL().get(0)).split("/");
        Assert.assertEquals((Object)"size9", (Object)urlSplitted[urlSplitted.length - 1]);
    }

    @Test
    public void testGetPDFURLSameMimeTypesSameSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("1".getBytes(Charsets.UTF_8)));
        b.setName(this.context, "first");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("1".getBytes(Charsets.UTF_8)));
        b2.setName(this.context, "second");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("1".getBytes(Charsets.UTF_8)));
        b3.setName(this.context, "third");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        String[] urlSplitted = ((String)gm.getPDFURL().get(0)).split("/");
        Assert.assertEquals((Object)"first", (Object)urlSplitted[urlSplitted.length - 1]);
    }

    @Test
    public void testGetPDFURLWithPrimaryBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Larger file than primary".getBytes(Charsets.UTF_8)));
        b.setName(this.context, "first");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("unknown");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Bitstream with more prioritized mimetype than primary".getBytes(Charsets.UTF_8)));
        b2.setName(this.context, "second");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("application/pdf");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("1".getBytes(Charsets.UTF_8)));
        b3.setName(this.context, "primary");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("Primary");
        this.bundleService.addBitstream(this.context, bundle, b3);
        bundle.setPrimaryBitstreamID(b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        String[] urlSplitted = ((String)gm.getPDFURL().get(0)).split("/");
        Assert.assertEquals((Object)"primary", (Object)urlSplitted[urlSplitted.length - 1]);
    }

    @Test
    public void testGetPDFURLWithUndefinedMimeTypes() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("12".getBytes(Charsets.UTF_8)));
        b.setName(this.context, "small");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("unknown type 1");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("12121212".getBytes(Charsets.UTF_8)));
        b2.setName(this.context, "medium");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("unknown type 2");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("12121212121212".getBytes(Charsets.UTF_8)));
        b3.setName(this.context, "large");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("unknown type 3");
        this.bundleService.addBitstream(this.context, bundle, b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        String[] urlSplitted = ((String)gm.getPDFURL().get(0)).split("/");
        Assert.assertEquals((Object)"large", (Object)urlSplitted[urlSplitted.length - 1]);
    }

    @Test
    public void testGetPDFURLWithNoBundle() throws Exception {
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        Assert.assertEquals((long)0L, (long)gm.getPDFURL().size());
    }

    @Test
    public void testGetPDFURLWithNoBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        Assert.assertEquals((long)0L, (long)gm.getPDFURL().size());
    }

    @Test
    public void testGetPDFURLWithEmptyBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = ContentServiceFactory.getInstance().getBundleService().create(this.context, this.it, "ORIGINAL");
        Bitstream b = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("".getBytes(Charsets.UTF_8)));
        b.setName(this.context, "small");
        b.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b.getFormat(this.context).setMIMEType("unknown type 1");
        this.bundleService.addBitstream(this.context, bundle, b);
        Bitstream b2 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("".getBytes(Charsets.UTF_8)));
        b2.setName(this.context, "medium");
        b2.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b2.getFormat(this.context).setMIMEType("unknown type 2");
        this.bundleService.addBitstream(this.context, bundle, b2);
        Bitstream b3 = this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("".getBytes(Charsets.UTF_8)));
        b3.setName(this.context, "large");
        b3.setFormat(this.context, (BitstreamFormat)this.bitstreamFormatService.create(this.context));
        b3.getFormat(this.context).setMIMEType("unknown type 3");
        this.bundleService.addBitstream(this.context, bundle, b3);
        this.context.restoreAuthSystemState();
        this.context.commit();
        GoogleMetadata gm = new GoogleMetadata(this.context, this.it);
        String[] urlSplitted = ((String)gm.getPDFURL().get(0)).split("/");
        Assert.assertEquals((Object)"small", (Object)urlSplitted[urlSplitted.length - 1]);
    }

    @Override
    @After
    public void destroy() {
        try {
            this.context.turnOffAuthorisationSystem();
            this.community = (Community)this.context.reloadEntity((ReloadableEntity)this.community);
            ContentServiceFactory.getInstance().getCommunityService().delete(this.context, (DSpaceObject)this.community);
            this.community = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.it = null;
        super.destroy();
    }
}

