/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import mockit.NonStrictExpectations;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BundleTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = Logger.getLogger(BundleTest.class);
    private Bundle b;
    private Item item;
    private Collection collection;
    private Community owningCommunity;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
            this.item = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
            this.b = this.bundleService.create(this.context, this.item, "TESTBUNDLE");
            this.dspaceObject = this.b;
            this.context.restoreAuthSystemState();
        }
        catch (SQLException | AuthorizeException ex) {
            log.error((Object)"SQL Error in init", ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.b = null;
        this.item = null;
        this.collection = null;
        this.owningCommunity = null;
        super.destroy();
    }

    @Test
    public void testDeleteParents() throws Exception {
        try {
            this.context.turnOffAuthorisationSystem();
            this.b = (Bundle)this.bundleService.find(this.context, this.b.getID());
            if (this.b != null) {
                this.itemService.removeBundle(this.context, this.item, this.b);
            }
            this.item = (Item)this.itemService.find(this.context, this.item.getID());
            this.collection = (Collection)this.collectionService.find(this.context, this.collection.getID());
            this.owningCommunity = (Community)this.communityService.find(this.context, this.owningCommunity.getID());
            this.collectionService.removeItem(this.context, this.collection, this.item);
            this.communityService.removeCollection(this.context, this.owningCommunity, this.collection);
            this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
            this.context.restoreAuthSystemState();
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error((Object)"SQL Error in destroy", ex);
            Assert.fail((String)("SQL Error in destroy: " + ex.getMessage()));
        }
    }

    @Test
    public void testBundleFind() throws SQLException {
        UUID id = this.b.getID();
        Bundle found = (Bundle)this.bundleService.find(this.context, id);
        Assert.assertThat((String)"testBundleFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testBundleFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
    }

    @Test
    public void testCreate() throws SQLException, AuthorizeException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = null;
            }
        };
        Bundle created = this.bundleService.create(this.context, this.item, "testCreateBundle");
        Assert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreate 1", (created.getID() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"testCreate 2", (created.getBitstreams().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"testCreate 3", (Object)created.getName(), (Object)"testCreateBundle");
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.b.getID() != null ? 1 : 0) != 0);
    }

    @Test
    public void testLegacyID() {
        Assert.assertTrue((String)"testGetLegacyID 0", (this.b.getLegacyId() == null ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.b.getName(), (Matcher)CoreMatchers.equalTo((Object)"TESTBUNDLE"));
    }

    @Test
    public void testSetName() throws SQLException {
        String name = "new name";
        this.b.setName(this.context, name);
        Assert.assertThat((String)"testSetName 0", (Object)this.b.getName(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetName 1", (Object)this.b.getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testSetName 2", (Object)this.b.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test
    public void testGetPrimaryBitstreamID() {
        Assert.assertThat((String)"testGetPrimaryBitstreamID 0", (Object)this.b.getPrimaryBitstream(), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void testSetPrimaryBitstreamID() throws SQLException, AuthorizeException, IOException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bitstream)this.any), 1);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        this.bundleService.addBitstream(this.context, this.b, bs);
        this.b.setPrimaryBitstreamID(bs);
        Assert.assertThat((String)"testSetPrimaryBitstreamID 0", (Object)this.b.getPrimaryBitstream(), (Matcher)CoreMatchers.equalTo((Object)bs));
    }

    @Test
    public void testUnsetPrimaryBitstreamID() throws IOException, SQLException, AuthorizeException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bitstream)this.any), 1);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        this.bundleService.addBitstream(this.context, this.b, bs);
        this.b.setPrimaryBitstreamID(bs);
        this.b.unsetPrimaryBitstreamID();
        Assert.assertThat((String)"testUnsetPrimaryBitstreamID 0", (Object)this.b.getPrimaryBitstream(), (Matcher)CoreMatchers.equalTo(null));
    }

    @Override
    @Test
    public void testGetHandle() {
        Assert.assertThat((String)"testGetHandle 0", (Object)this.b.getHandle(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetBitstreamByName() throws FileNotFoundException, SQLException, IOException, AuthorizeException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bitstream)this.any), 1);
                this.result = null;
            }
        };
        String name = "name";
        Assert.assertThat((String)"testGetHandle 0", (Object)this.bundleService.getBitstreamByName(this.b, name), (Matcher)CoreMatchers.nullValue());
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        bs.setName(this.context, name);
        this.bundleService.addBitstream(this.context, this.b, bs);
        this.bundleService.update(this.context, (DSpaceObject)this.b);
        Assert.assertThat((String)"testGetHandle 1", (Object)this.bundleService.getBitstreamByName(this.b, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetHandle 2", (Object)this.bundleService.getBitstreamByName(this.b, name), (Matcher)CoreMatchers.equalTo((Object)bs));
        Assert.assertThat((String)"testGetHandle 3", (Object)this.bundleService.getBitstreamByName(this.b, name).getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test
    public void testGetBitstreams() throws FileNotFoundException, SQLException, IOException, AuthorizeException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bitstream)this.any), 1);
                this.result = null;
            }
        };
        Assert.assertThat((String)"testGetBitstreams 0", (Object)this.b.getBitstreams(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetBitstreams 1", (Object)this.b.getBitstreams().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        String name = "name";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        bs.setName(this.context, name);
        this.bundleService.addBitstream(this.context, this.b, bs);
        Assert.assertThat((String)"testGetBitstreams 2", (Object)this.b.getBitstreams(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetBitstreams 3", (Object)this.b.getBitstreams().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((String)"testGetBitstreams 4", (Object)((Bitstream)this.b.getBitstreams().get(0)).getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test
    public void testGetItems() throws SQLException {
        Assert.assertThat((String)"testGetItems 0", (Object)this.b.getItems(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetItems 1", (Object)this.b.getItems().size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateBitstreamNoAuth() throws FileNotFoundException, AuthorizeException, SQLException, IOException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, this.b, (InputStream)new FileInputStream(f));
        Assert.fail((String)"Exception should be thrown");
    }

    @Test
    public void testCreateBitstreamAuth() throws FileNotFoundException, AuthorizeException, SQLException, IOException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bitstream)this.any), 1);
                this.result = null;
            }
        };
        String name = "name";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, this.b, (InputStream)new FileInputStream(f));
        bs.setName(this.context, name);
        Assert.assertThat((String)"testCreateBitstreamAuth 0", (Object)this.bundleService.getBitstreamByName(this.b, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateBitstreamAuth 1", (Object)this.bundleService.getBitstreamByName(this.b, name), (Matcher)CoreMatchers.equalTo((Object)bs));
        Assert.assertThat((String)"testCreateBitstreamAuth 2", (Object)this.bundleService.getBitstreamByName(this.b, name).getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test(expected=AuthorizeException.class)
    public void testRegisterBitstreamNoAuth() throws AuthorizeException, IOException, SQLException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        int assetstore = 0;
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.register(this.context, this.b, assetstore, f.getAbsolutePath());
        Assert.fail((String)"Exception should be thrown");
    }

    @Test
    public void testRegisterBitstreamAuth() throws AuthorizeException, IOException, SQLException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bitstream)this.any), 1);
                this.result = null;
            }
        };
        int assetstore = 0;
        String name = "name bitstream";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.register(this.context, this.b, assetstore, f.getName());
        bs.setName(this.context, name);
        Assert.assertThat((String)"testRegisterBitstream 0", (Object)this.bundleService.getBitstreamByName(this.b, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testRegisterBitstream 1", (Object)this.bundleService.getBitstreamByName(this.b, name), (Matcher)CoreMatchers.equalTo((Object)bs));
        Assert.assertThat((String)"testRegisterBitstream 2", (Object)this.bundleService.getBitstreamByName(this.b, name).getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddBitstreamNoAuth() throws SQLException, AuthorizeException, IOException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        bs.setName(this.context, "name");
        this.bundleService.addBitstream(this.context, this.b, bs);
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testAddBitstreamAuth() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bitstream)this.any), 1);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        bs.setName(this.context, "name");
        this.bundleService.addBitstream(this.context, this.b, bs);
        Assert.assertThat((String)"testAddBitstreamAuth 0", (Object)this.bundleService.getBitstreamByName(this.b, bs.getName()), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testAddBitstreamAuth 1", (Object)this.bundleService.getBitstreamByName(this.b, bs.getName()), (Matcher)CoreMatchers.equalTo((Object)bs));
        Assert.assertThat((String)"testAddBitstreamAuth 2", (Object)this.bundleService.getBitstreamByName(this.b, bs.getName()).getName(), (Matcher)CoreMatchers.equalTo((Object)bs.getName()));
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveBitstreamNoAuth() throws SQLException, AuthorizeException, IOException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 4);
                this.result = new AuthorizeException();
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        bs.setName(this.context, "name");
        this.bundleService.removeBitstream(this.context, this.b, bs);
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testRemoveBitstreamAuth() throws SQLException, AuthorizeException, IOException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 4);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bitstream)this.any), 1);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction(BundleTest.this.context, (DSpaceObject)((Bitstream)this.any), 2);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        this.bundleService.addBitstream(this.context, this.b, bs);
        this.bundleService.removeBitstream(this.context, this.b, bs);
        Assert.assertThat((String)"testRemoveBitstreamAuth 0", (Object)this.bundleService.getBitstreamByName(this.b, bs.getName()), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testUpdate() throws SQLException, AuthorizeException {
        this.bundleService.update(this.context, (DSpaceObject)this.b);
    }

    @Test
    public void testDelete() throws SQLException, AuthorizeException, IOException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 4);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 2);
                this.result = null;
            }
        };
        UUID id = this.b.getID();
        this.itemService.removeBundle(this.context, this.item, this.b);
        Assert.assertThat((String)"testDelete 0", (Object)this.bundleService.find(this.context, id), (Matcher)CoreMatchers.nullValue());
    }

    @Override
    @Test
    public void testGetType() {
        Assert.assertThat((String)"testGetType 0", (Object)this.b.getType(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testInheritCollectionDefaultPolicies() throws AuthorizeException, SQLException {
        List defaultCollectionPolicies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)this.collection, 9);
        Iterator it = defaultCollectionPolicies.iterator();
        this.bundleService.inheritCollectionDefaultPolicies(this.context, this.b, this.collection);
        while (it.hasNext()) {
            ResourcePolicy rp = (ResourcePolicy)it.next();
            rp.setAction(0);
        }
        List bspolicies = this.bundleService.getBundlePolicies(this.context, this.b);
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 0", (defaultCollectionPolicies.size() == bspolicies.size() ? 1 : 0) != 0);
        boolean equals = false;
        for (int i = 0; i < defaultCollectionPolicies.size(); ++i) {
            ResourcePolicy collectionPolicy = (ResourcePolicy)defaultCollectionPolicies.get(i);
            ResourcePolicy bundlePolicy = (ResourcePolicy)bspolicies.get(i);
            if (collectionPolicy.getAction() != bundlePolicy.getAction() || !collectionPolicy.getGroup().equals((Object)bundlePolicy.getGroup())) continue;
            equals = true;
        }
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 1", (boolean)equals);
        bspolicies = this.bundleService.getBitstreamPolicies(this.context, this.b);
        boolean exists = true;
        for (int i = 0; bspolicies.size() > 0 && i < defaultCollectionPolicies.size(); ++i) {
            ResourcePolicy collectionPolicy = (ResourcePolicy)defaultCollectionPolicies.get(i);
            ResourcePolicy bitstreamPolicy = (ResourcePolicy)bspolicies.get(i);
            if (collectionPolicy.getAction() != bitstreamPolicy.getAction() || !collectionPolicy.getGroup().equals((Object)bitstreamPolicy.getGroup())) continue;
            exists = true;
        }
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 2", (boolean)exists);
    }

    @Test
    public void testReplaceAllBitstreamPolicies() throws SQLException, AuthorizeException {
        ArrayList<Object> newpolicies = new ArrayList<Object>();
        newpolicies.add(this.resourcePolicyService.create(this.context));
        newpolicies.add(this.resourcePolicyService.create(this.context));
        newpolicies.add(this.resourcePolicyService.create(this.context));
        this.bundleService.replaceAllBitstreamPolicies(this.context, this.b, newpolicies);
        List bspolicies = this.bundleService.getBundlePolicies(this.context, this.b);
        Assert.assertTrue((String)"testReplaceAllBitstreamPolicies 0", (newpolicies.size() == bspolicies.size() ? 1 : 0) != 0);
        boolean equals = true;
        for (int i = 0; i < newpolicies.size() && equals; ++i) {
            if (newpolicies.contains(bspolicies.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testReplaceAllBitstreamPolicies 1", (boolean)equals);
        bspolicies = this.bundleService.getBitstreamPolicies(this.context, this.b);
        boolean exists = true;
        for (int i = 0; bspolicies.size() > 0 && i < newpolicies.size() && exists; ++i) {
            if (bspolicies.contains(newpolicies.get(i))) continue;
            exists = false;
        }
        Assert.assertTrue((String)"testReplaceAllBitstreamPolicies 2", (boolean)exists);
    }

    @Test
    public void testGetBundlePolicies() throws SQLException {
        List bspolicies = this.bundleService.getBundlePolicies(this.context, this.b);
        Assert.assertTrue((String)"testGetBundlePolicies 0", (boolean)CollectionUtils.isNotEmpty((java.util.Collection)bspolicies));
    }

    @Test
    public void testGetBitstreamPolicies() throws SQLException {
        List bspolicies = this.bundleService.getBitstreamPolicies(this.context, this.b);
        Assert.assertTrue((String)"testGetBitstreamPolicies 0", (boolean)bspolicies.isEmpty());
    }

    @Test
    public void testSetOrder() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bundle)this.any), 3);
                this.result = null;
                BundleTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Bitstream)this.any), 1);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        bs.setName(this.context, "bitstream1");
        this.bundleService.addBitstream(this.context, this.b, bs);
        Bitstream bs2 = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        bs2.setName(this.context, "bitstream2");
        this.bundleService.addBitstream(this.context, this.b, bs2);
        Bitstream bs3 = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        bs3.setName(this.context, "bitstream3");
        this.bundleService.addBitstream(this.context, this.b, bs3);
        Bitstream[] bitstreams = this.b.getBitstreams().toArray(new Bitstream[this.b.getBitstreams().size()]);
        Assert.assertTrue((String)"testSetOrder: starting count correct", (bitstreams.length == 3 ? 1 : 0) != 0);
        Assert.assertThat((String)"testSetOrder: Bitstream 1 is first", (Object)bitstreams[0].getName(), (Matcher)CoreMatchers.equalTo((Object)bs.getName()));
        Assert.assertThat((String)"testSetOrder: Bitstream 2 is second", (Object)bitstreams[1].getName(), (Matcher)CoreMatchers.equalTo((Object)bs2.getName()));
        Assert.assertThat((String)"testSetOrder: Bitstream 3 is third", (Object)bitstreams[2].getName(), (Matcher)CoreMatchers.equalTo((Object)bs3.getName()));
        UUID bsID1 = bs.getID();
        UUID bsID2 = bs2.getID();
        UUID bsID3 = bs3.getID();
        UUID[] newBitstreamOrder = new UUID[]{bsID3, bsID1, bsID2};
        this.bundleService.setOrder(this.context, this.b, newBitstreamOrder);
        bitstreams = this.b.getBitstreams().toArray(new Bitstream[this.b.getBitstreams().size()]);
        Assert.assertTrue((String)"testSetOrder: new count correct", (bitstreams.length == 3 ? 1 : 0) != 0);
        Assert.assertThat((String)"testSetOrder: Bitstream 3 is now first", (Object)bitstreams[0].getName(), (Matcher)CoreMatchers.equalTo((Object)bs3.getName()));
        Assert.assertThat((String)"testSetOrder: Bitstream 1 is now second", (Object)bitstreams[1].getName(), (Matcher)CoreMatchers.equalTo((Object)bs.getName()));
        Assert.assertThat((String)"testSetOrder: Bitstream 2 is now third", (Object)bitstreams[2].getName(), (Matcher)CoreMatchers.equalTo((Object)bs2.getName()));
        newBitstreamOrder = new UUID[]{bsID1, bsID2};
        this.bundleService.setOrder(this.context, this.b, newBitstreamOrder);
        Bitstream[] bitstreamsAfterPartialData = this.b.getBitstreams().toArray(new Bitstream[this.b.getBitstreams().size()]);
        Assert.assertThat((String)"testSetOrder: Partial data doesn't change order", (Object)bitstreamsAfterPartialData, (Matcher)CoreMatchers.equalTo((Object)bitstreams));
        newBitstreamOrder = new UUID[]{bsID1, null, bsID2};
        this.bundleService.setOrder(this.context, this.b, newBitstreamOrder);
        Bitstream[] bitstreamsAfterBadData = this.b.getBitstreams().toArray(new Bitstream[this.b.getBitstreams().size()]);
        Assert.assertThat((String)"testSetOrder: Partial data doesn't change order", (Object)bitstreamsAfterBadData, (Matcher)CoreMatchers.equalTo((Object)bitstreams));
    }

    @Override
    @Test
    public void testGetAdminObject() throws SQLException {
        Assert.assertThat((String)"testGetAdminObject 0", (Object)this.bundleService.getAdminObject(this.context, (DSpaceObject)this.b, 4), (Matcher)CoreMatchers.instanceOf(Item.class));
        Assert.assertThat((String)"testGetAdminObject 1", (Object)this.bundleService.getAdminObject(this.context, (DSpaceObject)this.b, 3), (Matcher)CoreMatchers.instanceOf(Item.class));
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        Assert.assertThat((String)"testGetParentObject 0", (Object)this.bundleService.getParentObject(this.context, (DSpaceObject)this.b), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetParentObject 0", (Object)this.bundleService.getParentObject(this.context, (DSpaceObject)this.b), (Matcher)CoreMatchers.instanceOf(Item.class));
    }
}

