/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommunityTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = Logger.getLogger(CommunityTest.class);
    private Community c;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.c = this.communityService.create(null, this.context);
            this.dspaceObject = this.c;
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.c = null;
        super.destroy();
    }

    @Test
    public void testCommunityFind() throws Exception {
        UUID id = this.c.getID();
        Community found = (Community)this.communityService.find(this.context, id);
        Assert.assertThat((String)"testCommunityFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCommunityFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
        Assert.assertThat((String)"testCommunityFind 2", (Object)found.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testCreateAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
                CommunityTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = false;
            }
        };
        Community sub = this.communityService.create(this.c, this.context);
        Assert.assertThat((String)"testCreate 2", (Object)sub, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 3", (Object)sub.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertTrue((String)"testCreate 4", (this.communityService.getAllParents(this.context, sub).size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreate 5", this.communityService.getAllParents(this.context, sub).get(0), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Test
    public void testCreateAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        Community created = this.communityService.create(null, this.context);
        Assert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 1", (Object)created.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
        Community son = this.communityService.create(created, this.context);
        Assert.assertThat((String)"testCreate 2", (Object)son, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 3", (Object)son.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertTrue((String)"testCreate 4", (this.communityService.getAllParents(this.context, son).size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreate 5", this.communityService.getAllParents(this.context, son).get(0), (Matcher)CoreMatchers.equalTo((Object)created));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = false;
            }
        };
        Community created = this.communityService.create(null, this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
                CommunityTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = false;
            }
        };
        Community created = this.communityService.create(null, this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateWithValidHandle() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        Community created = this.communityService.create(null, this.context, "987654321/100c");
        Assert.assertThat((String)"testCreateWithValidHandle 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateWithValidHandle 1", (Object)created.getHandle(), (Matcher)CoreMatchers.equalTo((Object)"987654321/100c"));
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateWithInvalidHandle() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        String inUseHandle = this.c.getHandle();
        Community created = this.communityService.create(null, this.context, inUseHandle);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindAll() throws Exception {
        List all = this.communityService.findAll(this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (all.size() >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (Community cm : all) {
            if (!cm.equals((Object)this.c)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testFindAllTop() throws Exception {
        List all = this.communityService.findAllTop(this.context);
        Assert.assertThat((String)"testFindAllTop 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAllTop 1", (all.size() >= 1 ? 1 : 0) != 0);
        for (Community cm : all) {
            Assert.assertThat((String)"testFindAllTop for", (Object)this.communityService.getAllParents(this.context, cm).size(), (Matcher)CoreMatchers.equalTo((Object)0));
        }
        boolean added = false;
        for (Community cm : all) {
            if (!cm.equals((Object)this.c)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAllTop 2", (boolean)added);
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.c.getID() != null ? 1 : 0) != 0);
    }

    @Test
    public void testLegacyID() {
        Assert.assertTrue((String)"testGetLegacyID 0", (this.c.getLegacyId() == null ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetHandle() {
        Assert.assertTrue((String)"testGetHandle 0", (boolean)this.c.getHandle().contains("123456789/"));
    }

    @Test
    public void testGetMetadata() {
        Assert.assertThat((String)"testGetMetadata 0", (Object)this.communityService.getMetadata(this.c, "name"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 1", (Object)this.communityService.getMetadata(this.c, "short_description"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 2", (Object)this.communityService.getMetadata(this.c, "introductory_text"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 4", (Object)this.communityService.getMetadata(this.c, "copyright_text"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 5", (Object)this.communityService.getMetadata(this.c, "side_bar_text"), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testSetMetadata() throws SQLException {
        String name = "name";
        String sdesc = "short description";
        String itext = "introductory text";
        String copy = "copyright declaration";
        String sidebar = "side bar text";
        this.communityService.setMetadata(this.context, this.c, "name", name);
        this.communityService.setMetadata(this.context, this.c, "short_description", sdesc);
        this.communityService.setMetadata(this.context, this.c, "introductory_text", itext);
        this.communityService.setMetadata(this.context, this.c, "copyright_text", copy);
        this.communityService.setMetadata(this.context, this.c, "side_bar_text", sidebar);
        Assert.assertThat((String)"testSetMetadata 0", (Object)this.communityService.getMetadata(this.c, "name"), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((String)"testSetMetadata 1", (Object)this.communityService.getMetadata(this.c, "short_description"), (Matcher)CoreMatchers.equalTo((Object)sdesc));
        Assert.assertThat((String)"testSetMetadata 2", (Object)this.communityService.getMetadata(this.c, "introductory_text"), (Matcher)CoreMatchers.equalTo((Object)itext));
        Assert.assertThat((String)"testSetMetadata 4", (Object)this.communityService.getMetadata(this.c, "copyright_text"), (Matcher)CoreMatchers.equalTo((Object)copy));
        Assert.assertThat((String)"testSetMetadata 5", (Object)this.communityService.getMetadata(this.c, "side_bar_text"), (Matcher)CoreMatchers.equalTo((Object)sidebar));
    }

    @Override
    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.c.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testGetLogo() {
        Assert.assertThat((String)"testGetLogo 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.communityService.setLogo(this.context, this.c, (InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.communityService.setLogo(this.context, this.c, (InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth2 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth2 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth3() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.communityService.setLogo(this.context, this.c, (InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth3 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth3 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth4() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.communityService.setLogo(this.context, this.c, (InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth4 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth4 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testSetLogoNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = new AuthorizeException();
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.communityService.setLogo(this.context, this.c, (InputStream)new FileInputStream(f));
        Assert.fail((String)"EXception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = new AuthorizeException();
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = new AuthorizeException();
            }
        };
        this.communityService.update(this.context, (DSpaceObject)this.c);
        Assert.fail((String)"Exception must be thrown");
    }

    @Test
    public void testUpdateAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        this.communityService.update(this.context, (DSpaceObject)this.c);
    }

    @Test
    public void testCreateAdministratorsAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)this.any), (Community)((Community)this.any));
                this.result = null;
            }
        };
        Group result = this.communityService.createAdministrators(this.context, this.c);
        Assert.assertThat((String)"testCreateAdministratorsAuth 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateAdministratorsAuth 1", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateAdministratorsNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)this.any), (Community)((Community)this.any));
                this.result = new AuthorizeException();
            }
        };
        Group result = this.communityService.createAdministrators(this.context, this.c);
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testRemoveAdministratorsAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)this.any), (Community)((Community)this.any));
                this.result = null;
                AuthorizeUtil.authorizeRemoveAdminGroup((Context)((Context)this.any), (Community)((Community)this.any));
                this.result = null;
            }
        };
        Group result = this.communityService.createAdministrators(this.context, this.c);
        Assert.assertThat((String)"testRemoveAdministratorsAuth 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testRemoveAdministratorsAuth 1", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.equalTo((Object)result));
        this.communityService.removeAdministrators(this.context, this.c);
        Assert.assertThat((String)"testRemoveAdministratorsAuth 2", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveAdministratorsNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)this.any), (Community)((Community)this.any));
                this.result = null;
                AuthorizeUtil.authorizeRemoveAdminGroup((Context)((Context)this.any), (Community)((Community)this.any));
                this.result = new AuthorizeException();
            }
        };
        Group result = this.communityService.createAdministrators(this.context, this.c);
        Assert.assertThat((String)"testRemoveAdministratorsAuth 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testRemoveAdministratorsAuth 1", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.equalTo((Object)result));
        this.communityService.removeAdministrators(this.context, this.c);
        Assert.fail((String)"Should have thrown exception");
    }

    @Test
    public void testGetAdministrators() {
        Assert.assertThat((String)"testGetAdministrators 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetCollections() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        Assert.assertThat((String)"testGetCollections 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCollections 1", (this.c.getCollections().size() == 0 ? 1 : 0) != 0);
        this.context.turnOffAuthorisationSystem();
        Collection collection = this.collectionService.create(this.context, this.c);
        this.collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection, "dc", "title", null, "*", "collection B");
        collection = this.collectionService.create(this.context, this.c);
        this.collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection, "dc", "title", null, "*", "collection C");
        collection = this.collectionService.create(this.context, this.c);
        this.collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection, "dc", "title", null, "*", "collection A");
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testGetCollections 2", (boolean)((Collection)this.c.getCollections().get(0)).getName().equals("collection A"));
        Assert.assertTrue((String)"testGetCollections 3", (boolean)((Collection)this.c.getCollections().get(1)).getName().equals("collection B"));
        Assert.assertTrue((String)"testGetCollections 4", (boolean)((Collection)this.c.getCollections().get(2)).getName().equals("collection C"));
    }

    @Test
    public void testGetSubcommunities() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
            }
        };
        Assert.assertThat((String)"testGetSubcommunities 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetSubcommunities 1", (this.c.getSubcommunities().size() == 0 ? 1 : 0) != 0);
        this.context.turnOffAuthorisationSystem();
        Community community = this.communityService.create(this.c, this.context);
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)community, "dc", "title", null, "*", "subcommunity B");
        community = this.communityService.create(this.c, this.context);
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)community, "dc", "title", null, "*", "subcommunity A");
        community = this.communityService.create(this.c, this.context);
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)community, "dc", "title", null, "*", "subcommunity C");
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testGetCollections 2", (boolean)((Community)this.c.getSubcommunities().get(0)).getName().equals("subcommunity A"));
        Assert.assertTrue((String)"testGetCollections 3", (boolean)((Community)this.c.getSubcommunities().get(1)).getName().equals("subcommunity B"));
        Assert.assertTrue((String)"testGetCollections 4", (boolean)((Community)this.c.getSubcommunities().get(2)).getName().equals("subcommunity C"));
    }

    @Test
    public void testGetParentCommunity() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
            }
        };
        Assert.assertEquals((String)"testGetParentCommunity 0", (long)this.c.getParentCommunities().size(), (long)0L);
        Community son = this.communityService.create(this.c, this.context);
        Assert.assertThat((String)"testGetParentCommunity 1", (Object)son.getParentCommunities().size(), (Matcher)CoreMatchers.not((Object)0));
        Assert.assertThat((String)"testGetParentCommunity 2", son.getParentCommunities().get(0), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Test
    public void testGetAllParents() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
            }
        };
        Assert.assertThat((String)"testGetAllParents 0", (Object)this.communityService.getAllParents(this.context, this.c), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAllParents 1", (this.communityService.getAllParents(this.context, this.c).size() == 0 ? 1 : 0) != 0);
        Community son = this.communityService.create(this.c, this.context);
        Assert.assertThat((String)"testGetAllParents 2", (Object)this.communityService.getAllParents(this.context, son), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAllParents 3", (this.communityService.getAllParents(this.context, son).size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testGetAllParents 4", this.communityService.getAllParents(this.context, son).get(0), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Test
    public void testGetAllCollections() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
            }
        };
        Assert.assertThat((String)"testGetAllCollections 0", (Object)this.communityService.getAllCollections(this.context, this.c), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAllCollections 1", (this.communityService.getAllCollections(this.context, this.c).size() == 0 ? 1 : 0) != 0);
        Collection collOfC = this.collectionService.create(this.context, this.c);
        Community sub = this.communityService.create(this.c, this.context);
        Collection collOfSub = this.collectionService.create(this.context, sub);
        Assert.assertThat((String)"testGetAllCollections 2", (Object)this.communityService.getAllCollections(this.context, this.c), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAllCollections 3", (this.communityService.getAllCollections(this.context, this.c).size() == 2 ? 1 : 0) != 0);
        Assert.assertThat((String)"testGetAllCollections 4", this.communityService.getAllCollections(this.context, this.c).get(0), (Matcher)CoreMatchers.equalTo((Object)collOfSub));
        Assert.assertThat((String)"testGetAllCollections 5", this.communityService.getAllCollections(this.context, this.c).get(1), (Matcher)CoreMatchers.equalTo((Object)collOfC));
    }

    @Test
    public void testCreateCollectionAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
            }
        };
        Collection result = this.collectionService.create(this.context, this.c);
        Assert.assertThat((String)"testCreateCollectionAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateCollectionAuth 1", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateCollectionAuth 2", this.c.getCollections().get(0), (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateCollectionNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        Collection result = this.collectionService.create(this.context, this.c);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddCollectionAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
            }
        };
        Collection col = this.collectionService.create(this.context, this.c);
        this.c.addCollection(col);
        Assert.assertThat((String)"testAddCollectionAuth 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testAddCollectionAuth 1", this.c.getCollections().get(0), (Matcher)CoreMatchers.equalTo((Object)col));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddCollectionNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        Collection col = this.collectionService.create(this.context, this.c);
        this.c.addCollection(col);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateSubcommunityAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
            }
        };
        Community result = this.communityService.createSubcommunity(this.context, this.c);
        Assert.assertThat((String)"testCreateSubcommunityAuth 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreateSubcommunityAuth 1", (this.c.getSubcommunities().size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreateSubcommunityAuth 2", this.c.getSubcommunities().get(0), (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSubcommunityNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = new AuthorizeException();
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
            }
        };
        Community result = this.communityService.createSubcommunity(this.context, this.c);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddSubcommunityAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
            }
        };
        this.context.turnOffAuthorisationSystem();
        Community result = this.communityService.create(null, this.context);
        this.context.restoreAuthSystemState();
        this.communityService.addSubcommunity(this.context, this.c, result);
        Assert.assertThat((String)"testAddSubcommunityAuth 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddSubcommunityAuth 1", (this.c.getSubcommunities().size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddSubcommunityAuth 2", this.c.getSubcommunities().get(0), (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddSubcommunityNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = new AuthorizeException();
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
            }
        };
        Community result = this.communityService.create(null, this.context);
        this.communityService.addSubcommunity(this.context, this.c, result);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveCollectionAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass(), AuthorizeUtil.class}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 4);
                this.result = null;
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        Collection col = this.collectionService.create(this.context, this.c);
        Assert.assertThat((String)"testRemoveCollectionAuth 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveCollectionAuth 1", (this.c.getCollections().size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testRemoveCollectionAuth 2", this.c.getCollections().get(0), (Matcher)CoreMatchers.equalTo((Object)col));
        this.c.removeCollection(col);
        Assert.assertThat((String)"testRemoveCollectionAuth 3", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveCollectionAuth 4", (this.c.getCollections().size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveCollectionNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 4);
                this.result = new AuthorizeException();
            }
        };
        Collection col = this.collectionService.create(this.context, this.c);
        Assert.assertThat((String)"testRemoveCollectionNoAuth 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveCollectionNoAuth 1", (this.c.getCollections().size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testRemoveCollectionNoAuth 2", this.c.getCollections().get(0), (Matcher)CoreMatchers.equalTo((Object)col));
        this.communityService.removeCollection(this.context, this.c, col);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveSubcommunityAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 4, true);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 2, true);
                this.result = null;
            }
        };
        this.context.turnOffAuthorisationSystem();
        Community com = this.communityService.create(null, this.context);
        this.context.restoreAuthSystemState();
        this.communityService.addSubcommunity(this.context, this.c, com);
        Assert.assertThat((String)"testRemoveSubcommunityAuth 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveSubcommunityAuth 1", (this.c.getSubcommunities().size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testRemoveSubcommunityAuth 2", this.c.getSubcommunities().get(0), (Matcher)CoreMatchers.equalTo((Object)com));
        this.communityService.removeSubcommunity(this.context, this.c, com);
        Assert.assertThat((String)"testRemoveSubcommunityAuth 3", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveSubcommunityAuth 4", (this.c.getSubcommunities().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 2);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 4);
                this.result = false;
            }
        };
        this.context.turnOffAuthorisationSystem();
        Community todelete = this.communityService.create(null, this.context);
        this.context.restoreAuthSystemState();
        UUID id = todelete.getID();
        this.communityService.delete(this.context, (DSpaceObject)todelete);
        Community found = (Community)this.communityService.find(this.context, id);
        Assert.assertThat((String)"testDeleteAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testDeleteAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 2);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 4, true);
                this.result = true;
            }
        };
        this.context.turnOffAuthorisationSystem();
        Community todelete = this.communityService.create(null, this.context);
        this.context.restoreAuthSystemState();
        UUID id = todelete.getID();
        this.communityService.delete(this.context, (DSpaceObject)todelete);
        Community found = (Community)this.communityService.find(this.context, id);
        Assert.assertThat((String)"testDeleteAuth2 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testDeleteHierachyAuth() throws Exception {
        System.out.println("testDeleteHierarchyAuth");
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass(), AuthorizeUtil.class}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 2, true);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 4, true);
                this.result = null;
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 2, true);
                this.result = null;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1, true);
                this.result = null;
            }
        };
        this.context.turnOffAuthorisationSystem();
        Community parent = this.communityService.create(null, this.context);
        Community child = this.communityService.createSubcommunity(this.context, parent);
        Community grandchild = this.communityService.createSubcommunity(this.context, child);
        Collection childCol = this.collectionService.create(this.context, child);
        Collection grandchildCol = this.collectionService.create(this.context, grandchild);
        WorkspaceItem wsItem = this.workspaceItemService.create(this.context, childCol, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)wsItem);
        wsItem = this.workspaceItemService.create(this.context, childCol, false);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)wsItem);
        this.context.restoreAuthSystemState();
        UUID parentId = parent.getID();
        UUID childId = child.getID();
        UUID grandchildId = grandchild.getID();
        UUID childColId = childCol.getID();
        UUID grandchildColId = grandchildCol.getID();
        UUID itemId = item.getID();
        this.communityService.delete(this.context, (DSpaceObject)parent);
        Assert.assertThat((String)"top-level Community not deleted", (Object)this.communityService.find(this.context, parentId), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"child Community not deleted", (Object)this.communityService.find(this.context, childId), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"grandchild Community not deleted", (Object)this.communityService.find(this.context, grandchildId), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"Collection of child Community not deleted", (Object)this.collectionService.find(this.context, childColId), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"Collection of grandchild Community not deleted", (Object)this.collectionService.find(this.context, grandchildColId), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"Item not deleted", (Object)this.itemService.find(this.context, itemId), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 2);
                this.result = new AuthorizeException();
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 4);
                this.result = false;
            }
        };
        this.communityService.delete(this.context, (DSpaceObject)this.c);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testEquals() throws SQLException, AuthorizeException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        Assert.assertFalse((String)"testEquals 0", (boolean)this.c.equals(null));
        Assert.assertFalse((String)"testEquals 1", (boolean)this.c.equals((Object)this.communityService.create(null, this.context)));
        Assert.assertTrue((String)"testEquals 2", (boolean)this.c.equals((Object)this.c));
    }

    @Override
    @Test
    public void testGetType() {
        Assert.assertThat((String)"testGetType 0", (Object)this.c.getType(), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void testCanEditBooleanAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth 0", (boolean)this.communityService.canEditBoolean(this.context, this.c));
    }

    @Test
    public void testCanEditBooleanAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth2 0", (boolean)this.communityService.canEditBoolean(this.context, this.c));
    }

    @Test
    public void testCanEditBooleanAuth3() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth3 0", (boolean)this.communityService.canEditBoolean(this.context, this.c));
    }

    @Test
    public void testCanEditBooleanAuth4() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth4 0", (boolean)this.communityService.canEditBoolean(this.context, this.c));
    }

    @Test
    public void testCanEditBooleanNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = new AuthorizeException();
            }
        };
        Assert.assertFalse((String)"testCanEditBooleanNoAuth 0", (boolean)this.communityService.canEditBoolean(this.context, this.c));
    }

    @Test
    public void testCanEditAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        this.communityService.canEdit(this.context, this.c);
    }

    @Test
    public void testCanEditAuth1() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        this.communityService.canEdit(this.context, this.c);
    }

    @Test
    public void testCanEditAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = true;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        this.communityService.canEdit(this.context, this.c);
    }

    @Test
    public void testCanEditAuth3() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = null;
            }
        };
        this.communityService.canEdit(this.context, this.c);
    }

    @Test(expected=AuthorizeException.class)
    public void testCanEditNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = false;
                CommunityTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1);
                this.result = new AuthorizeException();
            }
        };
        this.communityService.canEdit(this.context, this.c);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCountItems() throws Exception {
        Assert.assertTrue((String)"testCountItems 0", (this.itemService.countItems(this.context, this.c) == 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetAdminObject() throws SQLException {
        Assert.assertThat((String)"testGetAdminObject 0", (Object)((Community)this.communityService.getAdminObject(this.context, (DSpaceObject)this.c, 4)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        Assert.assertThat((String)"testGetAdminObject 1", (Object)((Community)this.communityService.getAdminObject(this.context, (DSpaceObject)this.c, 3)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        Assert.assertThat((String)"testGetAdminObject 2", (Object)this.communityService.getAdminObject(this.context, (DSpaceObject)this.c, 2), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testGetAdminObject 3", (Object)((Community)this.communityService.getAdminObject(this.context, (DSpaceObject)this.c, 11)), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        try {
            Assert.assertThat((String)"testGetParentObject 0", (Object)this.communityService.getParentObject(this.context, (DSpaceObject)this.c), (Matcher)CoreMatchers.nullValue());
            this.context.turnOffAuthorisationSystem();
            Community son = this.communityService.createSubcommunity(this.context, this.c);
            this.context.restoreAuthSystemState();
            Assert.assertThat((String)"testGetParentObject 1", (Object)this.communityService.getParentObject(this.context, (DSpaceObject)son), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"testGetParentObject 2", (Object)((Community)this.communityService.getParentObject(this.context, (DSpaceObject)son)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        }
        catch (AuthorizeException ex) {
            Assert.fail((String)"Authorize exception catched");
        }
    }
}

