/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import mockit.NonStrictExpectations;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ItemTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = Logger.getLogger(ItemTest.class);
    private Item it;
    private MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    private BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private Collection collection;
    private Community owningCommunity;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
            this.it = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
            this.it.setSubmitter(this.context.getCurrentUser());
            this.itemService.update(this.context, (DSpaceObject)this.it);
            this.dspaceObject = this.it;
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            this.itemService.delete(this.context, (DSpaceObject)this.it);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.collectionService.delete(this.context, (DSpaceObject)this.collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.restoreAuthSystemState();
        this.it = null;
        this.collection = null;
        this.owningCommunity = null;
        try {
            super.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testItemFind() throws Exception {
        UUID id = this.it.getID();
        Item found = (Item)this.itemService.find(this.context, id);
        Assert.assertThat((String)"testItemFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testItemFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
        Assert.assertThat((String)"testItemFind 2", (Object)found.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCreate() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 3);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1);
                this.result = null;
            }
        };
        Item created = this.createItem();
        Assert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 1", (Object)created.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testFindAll() throws Exception {
        Iterator all = this.itemService.findAll(this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        boolean added = false;
        while (all.hasNext()) {
            Item tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 1", (boolean)added);
    }

    @Test
    public void testFindBySubmitter() throws Exception {
        Iterator all = this.itemService.findBySubmitter(this.context, this.context.getCurrentUser());
        Assert.assertThat((String)"testFindBySubmitter 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        boolean added = false;
        while (all.hasNext()) {
            Item tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindBySubmitter 1", (boolean)added);
        this.context.turnOffAuthorisationSystem();
        all = this.itemService.findBySubmitter(this.context, this.ePersonService.create(this.context));
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testFindBySubmitter 2", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testFindBySubmitter 3", (boolean)all.hasNext());
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.it.getID() != null ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetHandle() {
        Assert.assertThat((String)"testGetHandle 0", (Object)this.it.getHandle(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testIsArchived() throws SQLException, AuthorizeException, IOException, IllegalAccessException {
        Assert.assertTrue((String)"testIsArchived 0", (boolean)this.it.isArchived());
        this.context.turnOffAuthorisationSystem();
        Item tmp = this.createItem();
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testIsArchived 1", (boolean)tmp.isArchived());
    }

    @Test
    public void testIsWithdrawn() {
        Assert.assertFalse((String)"testIsWithdrawn 0", (boolean)this.it.isWithdrawn());
    }

    @Test
    public void testGetLastModified() {
        Assert.assertThat((String)"testGetLastModified 0", (Object)this.it.getLastModified(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetLastModified 1", (boolean)DateUtils.isSameDay((Date)this.it.getLastModified(), (Date)new Date()));
    }

    @Test
    public void testSetArchived() {
        this.it.setArchived(true);
        Assert.assertTrue((String)"testSetArchived 0", (boolean)this.it.isArchived());
    }

    @Test
    public void testSetOwningCollection() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.context.restoreAuthSystemState();
        this.it.setOwningCollection(c);
        Assert.assertThat((String)"testSetOwningCollection 0", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetOwningCollection 1", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.equalTo((Object)c));
    }

    @Test
    public void testGetOwningCollection() throws Exception {
        Assert.assertThat((String)"testGetOwningCollection 0", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((String)"testGetOwningCollection 1", (Object)this.it.getOwningCollection(), (Object)this.collection);
    }

    @Test
    public void testGetMetadata_4args() {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, lang);
        Assert.assertThat((String)"testGetMetadata_4args 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_4args 1", (dc.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMetadata_String() {
        String mdString = "dc.contributor.author";
        List dc = this.itemService.getMetadataByMetadataString((DSpaceObject)this.it, mdString);
        Assert.assertThat((String)"testGetMetadata_String 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_String 1", (dc.size() == 0 ? 1 : 0) != 0);
        mdString = "dc.contributor.*";
        dc = this.itemService.getMetadataByMetadataString((DSpaceObject)this.it, mdString);
        Assert.assertThat((String)"testGetMetadata_String 2", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_String 3", (dc.size() == 0 ? 1 : 0) != 0);
        mdString = "dc.contributor";
        dc = this.itemService.getMetadataByMetadataString((DSpaceObject)this.it, mdString);
        Assert.assertThat((String)"testGetMetadata_String 4", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_String 5", (dc.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDS806() throws SQLException, AuthorizeException, NonUniqueMetadataException {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = this.metadataSchemaService.create(this.context, "test", "test");
        MetadataField metadataField = this.metadataFieldService.create(this.context, metadataSchema, "type", null, null);
        this.context.restoreAuthSystemState();
        String dcType = "DC-TYPE";
        String testType = "TEST-TYPE";
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, "dc", "type", null, null, dcType);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, "test", "type", null, null, testType);
        List values = this.itemService.getMetadata((DSpaceObject)this.it, "dc", "type", null, null);
        Assert.assertTrue((String)"Return results", (values.size() == 1 ? 1 : 0) != 0);
        this.context.turnOffAuthorisationSystem();
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.it, "test", "type", null, "*");
        this.metadataFieldService.delete(this.context, metadataField);
        this.metadataSchemaService.delete(this.context, metadataSchema);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testAddMetadata_5args_1() throws SQLException {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String[] values = new String[]{"value0", "value1"};
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, Arrays.asList(values));
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_5args_1 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_5args_1 1", (dc.size() == 2 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_5args_1 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_5args_1 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_5args_1 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_5args_1 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_5args_1 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values[0]));
        Assert.assertThat((String)"testAddMetadata_5args_1 7", (Object)((MetadataValue)dc.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_5args_1 8", (Object)((MetadataValue)dc.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_5args_1 9", (Object)((MetadataValue)dc.get(1)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_5args_1 10", (Object)((MetadataValue)dc.get(1)).getLanguage(), (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_5args_1 11", (Object)((MetadataValue)dc.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values[1]));
    }

    @Test
    public void testAddMetadata_7args_1_authority() throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, SQLException {
        String schema = "dc";
        String element = "language";
        String qualifier = "iso";
        String lang = "*";
        List<String> values = Arrays.asList("en_US", "en");
        List<String> authorities = Arrays.asList("accepted", "uncertain");
        List<Integer> confidences = Arrays.asList(0, 0);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_7args_1 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_1 1", (dc.size() == 2 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_7args_1 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_1 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_1 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_1 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_1 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values.get(0)));
        Assert.assertThat((String)"testAddMetadata_7args_1 7", (Object)((MetadataValue)dc.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)authorities.get(0)));
        Assert.assertThat((String)"testAddMetadata_7args_1 8", (Object)((MetadataValue)dc.get(0)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)confidences.get(0)));
        Assert.assertThat((String)"testAddMetadata_7args_1 9", (Object)((MetadataValue)dc.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_1 10", (Object)((MetadataValue)dc.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_1 11", (Object)((MetadataValue)dc.get(1)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_1 12", (Object)((MetadataValue)dc.get(1)).getLanguage(), (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_1 13", (Object)((MetadataValue)dc.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values.get(1)));
        Assert.assertThat((String)"testAddMetadata_7args_1 14", (Object)((MetadataValue)dc.get(1)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)authorities.get(1)));
        Assert.assertThat((String)"testAddMetadata_7args_1 15", (Object)((MetadataValue)dc.get(1)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)confidences.get(1)));
    }

    @Test
    public void testAddMetadata_7args_1_noauthority() throws SQLException {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        List<String> values = Arrays.asList("value0", "value1");
        List<String> authorities = Arrays.asList("auth0", "auth2");
        List<Integer> confidences = Arrays.asList(0, 0);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_7args_1 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_1 1", (dc.size() == 2 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_7args_1 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_1 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_1 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_1 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_1 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values.get(0)));
        Assert.assertThat((String)"testAddMetadata_7args_1 7", (Object)((MetadataValue)dc.get(0)).getAuthority(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testAddMetadata_7args_1 8", (Object)((MetadataValue)dc.get(0)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((String)"testAddMetadata_7args_1 9", (Object)((MetadataValue)dc.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_1 10", (Object)((MetadataValue)dc.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_1 11", (Object)((MetadataValue)dc.get(1)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_1 12", (Object)((MetadataValue)dc.get(1)).getLanguage(), (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_1 13", (Object)((MetadataValue)dc.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values.get(1)));
        Assert.assertThat((String)"testAddMetadata_7args_1 14", (Object)((MetadataValue)dc.get(1)).getAuthority(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testAddMetadata_7args_1 15", (Object)((MetadataValue)dc.get(1)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testAddMetadata_5args_2() throws SQLException {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        List<String> values = Arrays.asList("value0", "value1");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_5args_2 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_5args_2 1", (dc.size() == 2 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_5args_2 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_5args_2 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_5args_2 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_5args_2 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_5args_2 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values.get(0)));
        Assert.assertThat((String)"testAddMetadata_5args_2 7", (Object)((MetadataValue)dc.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_5args_2 8", (Object)((MetadataValue)dc.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_5args_2 9", (Object)((MetadataValue)dc.get(1)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_5args_2 10", (Object)((MetadataValue)dc.get(1)).getLanguage(), (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_5args_2 11", (Object)((MetadataValue)dc.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values.get(1)));
    }

    @Test
    public void testAddMetadata_7args_2_authority() throws SQLException {
        String schema = "dc";
        String element = "language";
        String qualifier = "iso";
        String lang = "*";
        String values = "en";
        String authorities = "accepted";
        int confidences = 0;
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_7args_2 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_2 1", (dc.size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_7args_2 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_2 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_2 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_2 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_2 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values));
        Assert.assertThat((String)"testAddMetadata_7args_2 7", (Object)((MetadataValue)dc.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)authorities));
        Assert.assertThat((String)"testAddMetadata_7args_2 8", (Object)((MetadataValue)dc.get(0)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)confidences));
    }

    @Test
    public void testAddMetadata_7args_2_noauthority() throws SQLException {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String values = "value0";
        String authorities = "auth0";
        int confidences = 0;
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_7args_2 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_2 1", (dc.size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_7args_2 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_2 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_2 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_2 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_2 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values));
        Assert.assertThat((String)"testAddMetadata_7args_2 7", (Object)((MetadataValue)dc.get(0)).getAuthority(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testAddMetadata_7args_2 8", (Object)((MetadataValue)dc.get(0)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testClearMetadata() throws SQLException {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String values = "value0";
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, lang);
        Assert.assertThat((String)"testClearMetadata 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testClearMetadata 1", (dc.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSubmitter() throws Exception {
        Assert.assertThat((String)"testGetSubmitter 0", (Object)this.it.getSubmitter(), (Matcher)CoreMatchers.notNullValue());
        this.context.turnOffAuthorisationSystem();
        Item tmp = this.createItem();
        this.context.restoreAuthSystemState();
        Assert.assertEquals((String)"testGetSubmitter 1", (Object)tmp.getSubmitter(), (Object)this.context.getCurrentUser());
    }

    @Test
    public void testSetSubmitter() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        EPerson sub = this.ePersonService.create(this.context);
        this.context.restoreAuthSystemState();
        this.it.setSubmitter(sub);
        Assert.assertThat((String)"testSetSubmitter 0", (Object)this.it.getSubmitter(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetSubmitter 1", (Object)this.it.getSubmitter().getID(), (Matcher)CoreMatchers.equalTo((Object)sub.getID()));
    }

    @Test
    public void testGetCollections() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collection = this.collectionService.create(this.context, this.owningCommunity);
        this.collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection, "dc", "title", null, "*", "collection B");
        this.it.addCollection(collection);
        collection = this.collectionService.create(this.context, this.owningCommunity);
        this.collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection, "dc", "title", null, "*", "collection A");
        this.it.addCollection(collection);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testGetCollections 0", (Object)this.it.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCollections 1", (this.it.getCollections().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testGetCollections 2", (boolean)((Collection)this.it.getCollections().get(1)).getName().equals("collection A"));
        Assert.assertTrue((String)"testGetCollections 3", (boolean)((Collection)this.it.getCollections().get(2)).getName().equals("collection B"));
    }

    @Test
    public void testGetCommunities() throws Exception {
        Assert.assertThat((String)"testGetCommunities 0", (Object)this.itemService.getCommunities(this.context, this.it), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCommunities 1", (this.itemService.getCommunities(this.context, this.it).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetBundles_0args() throws Exception {
        Assert.assertThat((String)"testGetBundles_0args 0", (Object)this.it.getBundles(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetBundles_0args 1", (this.it.getBundles().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetBundles_String() throws Exception {
        String name = "name";
        Assert.assertThat((String)"testGetBundles_String 0", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetBundles_String 1", (this.itemService.getBundles(this.it, name).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateBundleAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
            }
        };
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        Assert.assertThat((String)"testCreateBundleAuth 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateBundleAuth 1", (Object)created.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((String)"testCreateBundleAuth 2", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreateBundleAuth 3", (this.itemService.getBundles(this.it, name).size() == 1 ? 1 : 0) != 0);
    }

    @Test(expected=SQLException.class)
    public void testCreateBundleNoName() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
            }
        };
        String name = "";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=SQLException.class)
    public void testCreateBundleNoName2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
            }
        };
        String name = null;
        Bundle created = this.bundleService.create(this.context, this.it, name);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateBundleNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddBundleAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
            }
        };
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        Assert.assertThat((String)"testAddBundleAuth 0", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddBundleAuth 1", (this.itemService.getBundles(this.it, name).size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddBundleAuth 2", this.itemService.getBundles(this.it, name).get(0), (Matcher)CoreMatchers.equalTo((Object)created));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddBundleNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.it.addBundle(created);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveBundleAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 4);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 2);
                this.result = null;
            }
        };
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.itemService.addBundle(this.context, this.it, created);
        this.itemService.removeBundle(this.context, this.it, created);
        Assert.assertThat((String)"testRemoveBundleAuth 0", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveBundleAuth 1", (this.itemService.getBundles(this.it, name).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveBundleNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 4);
                this.result = new AuthorizeException();
            }
        };
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.it.addBundle(created);
        this.itemService.removeBundle(this.context, this.it, created);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateSingleBitstream_InputStream_StringAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1, true);
                this.result = null;
            }
        };
        String name = "new bundle";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, name);
        Assert.assertThat((String)"testCreateSingleBitstream_InputStream_StringAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSingleBitstream_InputStream_StringNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        String name = "new bundle";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, name);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateSingleBitstream_InputStreamAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1, true);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it);
        Assert.assertThat((String)"testCreateSingleBitstream_InputStreamAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSingleBitstream_InputStreamNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it);
        Assert.fail((String)"Expected exception");
    }

    @Test
    public void testGetNonInternalBitstreams() throws Exception {
        Assert.assertThat((String)"testGetNonInternalBitstreams 0", (Object)this.itemService.getNonInternalBitstreams(this.context, this.it), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetNonInternalBitstreams 1", (this.itemService.getNonInternalBitstreams(this.context, this.it).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveDSpaceLicenseAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 4);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 2);
                this.result = null;
            }
        };
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.itemService.removeDSpaceLicense(this.context, this.it);
        Assert.assertThat((String)"testRemoveDSpaceLicenseAuth 0", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveDSpaceLicenseAuth 1", (this.itemService.getBundles(this.it, name).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveDSpaceLicenseNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 4);
                this.result = new AuthorizeException();
            }
        };
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.itemService.removeDSpaceLicense(this.context, this.it);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveLicensesAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 4);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction(ItemTest.this.context, (DSpaceObject)((Bitstream)this.any), 2);
                this.result = null;
            }
        };
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, bsname);
        this.bitstreamService.setFormat(this.context, result, this.bitstreamFormatService.findByShortDescription(this.context, bsname));
        this.bundleService.addBitstream(this.context, created, result);
        this.itemService.removeLicenses(this.context, this.it);
        Assert.assertThat((String)"testRemoveLicensesAuth 0", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveLicensesAuth 1", (this.itemService.getBundles(this.it, name).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveLicensesNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 3);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 4);
                this.result = new AuthorizeException();
            }
        };
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, bsname);
        this.bitstreamService.setFormat(this.context, result, this.bitstreamFormatService.findByShortDescription(this.context, bsname));
        this.bundleService.addBitstream(this.context, created, result);
        this.itemService.removeLicenses(this.context, this.it);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testUpdateAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
            }
        };
        this.itemService.update(this.context, (DSpaceObject)this.it);
    }

    @Test
    public void testUpdateAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = new AuthorizeException();
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = new AuthorizeException();
            }
        };
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        this.itemService.update(this.context, (DSpaceObject)this.it);
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = new AuthorizeException();
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, this.anyBoolean.booleanValue());
                this.result = false;
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, this.anyBoolean.booleanValue());
                this.result = false;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, this.anyBoolean.booleanValue());
                this.result = new AuthorizeException();
            }
        };
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        this.itemService.update(this.context, (DSpaceObject)this.it);
    }

    @Test
    public void testWithdrawAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeWithdrawItem((Context)((Context)this.any), (Item)((Item)this.any));
                this.result = null;
            }
        };
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
            }
        };
        this.itemService.withdraw(this.context, this.it);
        Assert.assertTrue((String)"testWithdrawAuth 0", (boolean)this.it.isWithdrawn());
    }

    @Test(expected=AuthorizeException.class)
    public void testWithdrawNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeWithdrawItem((Context)((Context)this.any), (Item)((Item)this.any));
                this.result = new AuthorizeException();
            }
        };
        this.itemService.withdraw(this.context, this.it);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testReinstateAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeWithdrawItem((Context)((Context)this.any), (Item)((Item)this.any));
                this.result = null;
                AuthorizeUtil.authorizeReinstateItem((Context)((Context)this.any), (Item)((Item)this.any));
                this.result = null;
            }
        };
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
            }
        };
        this.itemService.withdraw(this.context, this.it);
        this.itemService.reinstate(this.context, this.it);
        Assert.assertFalse((String)"testReinstate 0", (boolean)this.it.isWithdrawn());
    }

    @Test(expected=AuthorizeException.class)
    public void testReinstateNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeWithdrawItem((Context)((Context)this.any), (Item)((Item)this.any));
                this.result = null;
                AuthorizeUtil.authorizeReinstateItem((Context)((Context)this.any), (Item)((Item)this.any));
                this.result = new AuthorizeException();
            }
        };
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
            }
        };
        this.itemService.withdraw(this.context, this.it);
        this.itemService.reinstate(this.context, this.it);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testDeleteAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 4, true);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 2, true);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
            }
        };
        UUID id = this.it.getID();
        this.itemService.delete(this.context, (DSpaceObject)this.it);
        Item found = (Item)this.itemService.find(this.context, id);
        Assert.assertThat((String)"testDeleteAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 4);
                this.result = new AuthorizeException();
            }
        };
        this.itemService.delete(this.context, (DSpaceObject)this.it);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testEquals() throws SQLException, AuthorizeException, IOException, IllegalAccessException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 3);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 4);
                this.result = null;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 2);
                this.result = null;
            }
        };
        Assert.assertFalse((String)"testEquals 0", (boolean)this.it.equals(null));
        Item item = this.createItem();
        try {
            Assert.assertFalse((String)"testEquals 1", (boolean)this.it.equals((Object)item));
            Assert.assertTrue((String)"testEquals 2", (boolean)this.it.equals((Object)this.it));
        }
        finally {
            this.itemService.delete(this.context, (DSpaceObject)item);
        }
    }

    @Test
    public void testIsOwningCollection() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.context.restoreAuthSystemState();
        boolean result = this.itemService.isOwningCollection(this.it, c);
        Assert.assertFalse((String)"testIsOwningCollection 0", (boolean)result);
    }

    @Override
    @Test
    public void testGetType() {
        Assert.assertThat((String)"testGetType 0", (Object)this.it.getType(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testReplaceAllItemPolicies() throws Exception {
        ArrayList<ResourcePolicy> newpolicies = new ArrayList<ResourcePolicy>();
        ResourcePolicy pol1 = (ResourcePolicy)this.resourcePolicyService.create(this.context);
        newpolicies.add(pol1);
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
            }
        };
        this.itemService.replaceAllItemPolicies(this.context, this.it, newpolicies);
        List retrieved = this.authorizeService.getPolicies(this.context, (DSpaceObject)this.it);
        Assert.assertThat((String)"testReplaceAllItemPolicies 0", (Object)retrieved, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testReplaceAllItemPolicies 1", (Object)retrieved.size(), (Matcher)CoreMatchers.equalTo((Object)newpolicies.size()));
    }

    @Test
    public void testReplaceAllBitstreamPolicies() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, bsname);
        this.bitstreamService.setFormat(this.context, result, this.bitstreamFormatService.findByShortDescription(this.context, bsname));
        this.bundleService.addBitstream(this.context, created, result);
        ArrayList<Object> newpolicies = new ArrayList<Object>();
        newpolicies.add(this.resourcePolicyService.create(this.context));
        newpolicies.add(this.resourcePolicyService.create(this.context));
        newpolicies.add(this.resourcePolicyService.create(this.context));
        this.context.restoreAuthSystemState();
        this.itemService.replaceAllBitstreamPolicies(this.context, this.it, newpolicies);
        ArrayList retrieved = new ArrayList();
        List bundles = this.it.getBundles();
        for (Bundle b : bundles) {
            retrieved.addAll(this.authorizeService.getPolicies(this.context, (DSpaceObject)b));
            retrieved.addAll(this.bundleService.getBitstreamPolicies(this.context, b));
        }
        Assert.assertFalse((String)"testReplaceAllBitstreamPolicies 0", (boolean)retrieved.isEmpty());
        boolean equals = true;
        for (int i = 0; i < newpolicies.size() && equals; ++i) {
            if (newpolicies.contains(retrieved.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testReplaceAllBitstreamPolicies 1", (boolean)equals);
    }

    @Test
    public void testRemoveGroupPolicies() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<ResourcePolicy> newpolicies = new ArrayList<ResourcePolicy>();
        Group g = this.groupService.create(this.context);
        ResourcePolicy pol1 = (ResourcePolicy)this.resourcePolicyService.create(this.context);
        newpolicies.add(pol1);
        pol1.setGroup(g);
        this.itemService.replaceAllItemPolicies(this.context, this.it, newpolicies);
        this.itemService.removeGroupPolicies(this.context, this.it, g);
        this.context.restoreAuthSystemState();
        List retrieved = this.authorizeService.getPolicies(this.context, (DSpaceObject)this.it);
        Assert.assertThat((String)"testRemoveGroupPolicies 0", (Object)retrieved, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveGroupPolicies 1", (boolean)retrieved.isEmpty());
    }

    @Test
    public void testInheritCollectionDefaultPolicies() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        List defaultCollectionPolicies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)c, 9);
        ArrayList<ResourcePolicy> newPolicies = new ArrayList<ResourcePolicy>();
        for (ResourcePolicy collRp : defaultCollectionPolicies) {
            ResourcePolicy rp = this.resourcePolicyService.clone(this.context, collRp);
            rp.setAction(0);
            rp.setRpType(ResourcePolicy.TYPE_INHERITED);
            newPolicies.add(rp);
        }
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, bsname);
        this.bitstreamService.setFormat(this.context, result, this.bitstreamFormatService.findByShortDescription(this.context, bsname));
        this.bundleService.addBitstream(this.context, created, result);
        this.context.restoreAuthSystemState();
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1, true);
                this.result = null;
            }
        };
        this.itemService.inheritCollectionDefaultPolicies(this.context, this.it, c);
        ArrayList retrieved = this.authorizeService.getPolicies(this.context, (DSpaceObject)this.it);
        boolean equals = true;
        for (int i = 0; i < retrieved.size() && equals; ++i) {
            if (newPolicies.contains(retrieved.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 0", (boolean)equals);
        retrieved = new ArrayList();
        List bundles = this.it.getBundles();
        for (Bundle b : bundles) {
            retrieved.addAll(this.authorizeService.getPolicies(this.context, (DSpaceObject)b));
            retrieved.addAll(this.bundleService.getBitstreamPolicies(this.context, b));
        }
        Assert.assertFalse((String)"testInheritCollectionDefaultPolicies 1", (boolean)retrieved.isEmpty());
        equals = true;
        for (int i = 0; i < newPolicies.size() && equals; ++i) {
            if (newPolicies.contains(retrieved.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 2", (boolean)equals);
    }

    @Test
    public void testMove() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection from = this.createCollection();
        Collection to = this.createCollection();
        this.it.addCollection(from);
        this.it.setOwningCollection(from);
        this.itemService.move(this.context, this.it, from, to);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testMove 0", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testMove 1", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.equalTo((Object)to));
    }

    @Test
    public void testHasUploadedFiles() throws Exception {
        Assert.assertFalse((String)"testHasUploadedFiles 0", (boolean)this.itemService.hasUploadedFiles(this.it));
    }

    @Test
    public void testGetCollectionsNotLinked() throws Exception {
        List result = this.itemService.getCollectionsNotLinked(this.context, this.it);
        boolean isin = false;
        for (Collection c : result) {
            Iterator iit = this.itemService.findByCollection(this.context, c);
            while (iit.hasNext()) {
                if (!((Item)iit.next()).getID().equals(this.it.getID())) continue;
                isin = true;
            }
        }
        Assert.assertFalse((String)"testGetCollectionsNotLinked 0", (boolean)isin);
    }

    @Test
    public void testCanEditBooleanAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = true;
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth 0", (boolean)this.itemService.canEdit(this.context, this.it));
    }

    @Test
    public void testCanEditBooleanAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = false;
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth2 0", (boolean)this.itemService.canEdit(this.context, this.it));
    }

    @Test
    public void testCanEditBooleanAuth3() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = false;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = null;
            }
        };
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testCanEditBooleanAuth3 0", (boolean)this.itemService.canEdit(this.context, this.it));
    }

    @Test
    public void testCanEditBooleanAuth4() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = false;
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = true;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = new AuthorizeException();
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth4 0", (boolean)this.itemService.canEdit(this.context, this.it));
    }

    @Test
    public void testCanEditBooleanAuth5() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = new AuthorizeException();
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, this.anyBoolean.booleanValue());
                this.result = null;
            }
        };
        this.collectionService.createTemplateItem(this.context, this.collection);
        this.collectionService.update(this.context, (DSpaceObject)this.collection);
        Assert.assertTrue((String)"testCanEditBooleanNoAuth5 0", (boolean)this.itemService.canEdit(this.context, this.collection.getTemplateItem()));
    }

    @Test
    public void testCanEditBooleanNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = false;
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, this.anyBoolean.booleanValue());
                this.result = false;
                ItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, this.anyBoolean.booleanValue());
                this.result = false;
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, this.anyBoolean.booleanValue());
                this.result = new AuthorizeException();
            }
        };
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        Assert.assertFalse((String)"testCanEditBooleanNoAuth 0", (boolean)this.itemService.canEdit(this.context, this.it));
    }

    @Test
    public void testCanEditBooleanNoAuth2() throws Exception {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wi = this.workspaceItemService.create(this.context, this.collection, true);
        this.context.restoreAuthSystemState();
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1, this.anyBoolean.booleanValue());
                this.result = new AuthorizeException();
            }
        };
        Assert.assertFalse((String)"testCanEditBooleanNoAuth2 0", (boolean)this.itemService.canEdit(this.context, wi.getItem()));
    }

    @Test
    public void testIsInProgressSubmission() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        WorkspaceItem wi = this.workspaceItemService.create(this.context, c, true);
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testIsInProgressSubmission 0", (boolean)this.itemService.isInProgressSubmission(this.context, wi.getItem()));
    }

    @Test
    public void testIsInProgressSubmissionFalse() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        WorkspaceItem wi = this.workspaceItemService.create(this.context, c, true);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
        this.context.restoreAuthSystemState();
        Assert.assertFalse((String)"testIsInProgressSubmissionFalse 0", (boolean)this.itemService.isInProgressSubmission(this.context, item));
    }

    @Test
    public void testIsInProgressSubmissionFalse2() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.collectionService.createTemplateItem(this.context, c);
        this.collectionService.update(this.context, (DSpaceObject)c);
        Item item = c.getTemplateItem();
        this.context.restoreAuthSystemState();
        Assert.assertFalse((String)"testIsInProgressSubmissionFalse2 0", (boolean)this.itemService.isInProgressSubmission(this.context, item));
    }

    @Override
    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.it.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testFindByMetadataField() throws Exception {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String value = "value";
        Iterator result = this.itemService.findByMetadataField(this.context, schema, element, qualifier, value);
        Assert.assertThat((String)"testFindByMetadataField 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testFindByMetadataField 1", (boolean)result.hasNext());
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, "*", value);
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
            }
        };
        this.itemService.update(this.context, (DSpaceObject)this.it);
        result = this.itemService.findByMetadataField(this.context, schema, element, qualifier, value);
        Assert.assertThat((String)"testFindByMetadataField 3", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByMetadataField 4", (boolean)result.hasNext());
        Assert.assertTrue((String)"testFindByMetadataField 5", (boolean)((Item)result.next()).equals((Object)this.it));
    }

    @Override
    @Test
    public void testGetAdminObject() throws SQLException {
        Assert.assertThat((String)"testGetAdminObject 0", (Object)((Item)this.itemService.getAdminObject(this.context, (DSpaceObject)this.it, 4)), (Matcher)CoreMatchers.equalTo((Object)this.it));
        Assert.assertThat((String)"testGetAdminObject 1", (Object)((Item)this.itemService.getAdminObject(this.context, (DSpaceObject)this.it, 3)), (Matcher)CoreMatchers.equalTo((Object)this.it));
        Assert.assertThat((String)"testGetAdminObject 2", (Object)((Collection)this.itemService.getAdminObject(this.context, (DSpaceObject)this.it, 2)), (Matcher)CoreMatchers.equalTo((Object)this.collection));
        Assert.assertThat((String)"testGetAdminObject 3", (Object)((Item)this.itemService.getAdminObject(this.context, (DSpaceObject)this.it, 11)), (Matcher)CoreMatchers.equalTo((Object)this.it));
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        try {
            Assert.assertThat((String)"testGetParentObject 0", (Object)this.itemService.getParentObject(this.context, (DSpaceObject)this.it), (Matcher)CoreMatchers.notNullValue());
            this.context.turnOffAuthorisationSystem();
            Collection parent = this.createCollection();
            this.it.setOwningCollection(parent);
            this.context.restoreAuthSystemState();
            Assert.assertThat((String)"testGetParentObject 1", (Object)this.itemService.getParentObject(this.context, (DSpaceObject)this.it), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"testGetParentObject 2", (Object)((Collection)this.itemService.getParentObject(this.context, (DSpaceObject)this.it)), (Matcher)CoreMatchers.equalTo((Object)parent));
        }
        catch (AuthorizeException ex) {
            Assert.fail((String)"Authorize exception catched");
        }
    }

    @Test
    public void testFindByAuthorityValue() throws Exception {
        String schema = "dc";
        String element = "language";
        String qualifier = "iso";
        String value = "en";
        String authority = "accepted";
        int confidence = 0;
        Iterator result = this.itemService.findByAuthorityValue(this.context, schema, element, qualifier, value);
        Assert.assertThat((String)"testFindByAuthorityValue 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testFindByAuthorityValue 1", (boolean)result.hasNext());
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, "*", value, authority, confidence);
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
            }
        };
        this.itemService.update(this.context, (DSpaceObject)this.it);
        result = this.itemService.findByAuthorityValue(this.context, schema, element, qualifier, authority);
        Assert.assertThat((String)"testFindByAuthorityValue 3", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByAuthorityValue 4", (boolean)result.hasNext());
        Assert.assertThat((String)"testFindByAuthorityValue 5", result.next(), (Matcher)CoreMatchers.equalTo((Object)this.it));
    }

    protected Collection createCollection() throws SQLException, AuthorizeException {
        return this.collectionService.create(this.context, this.owningCommunity);
    }

    protected Item createItem() throws SQLException, IOException, AuthorizeException, IllegalAccessException {
        WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
        return this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
    }
}

