/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.SupervisedItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.eperson.service.SupervisorService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SupervisedItemTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(SupervisedItemTest.class);
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected SupervisedItemService supervisedItemService = ContentServiceFactory.getInstance().getSupervisedItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected SupervisorService supervisorService = EPersonServiceFactory.getInstance().getSupervisorService();
    protected UUID communityId;
    protected UUID groupId;
    protected int workspaceItemId;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            Community owningCommunity = this.communityService.create(null, this.context);
            Collection collection = this.collectionService.create(this.context, owningCommunity);
            WorkspaceItem si = this.workspaceItemService.create(this.context, collection, false);
            Group gr = this.groupService.create(this.context);
            EPerson currentUser = this.context.getCurrentUser();
            this.groupService.addMember(this.context, gr, currentUser);
            this.groupService.update(this.context, (DSpaceObject)gr);
            this.supervisorService.add(this.context, gr, si, 1);
            this.communityId = owningCommunity.getID();
            this.workspaceItemId = si.getID();
            this.groupId = gr.getID();
            this.context.restoreAuthSystemState();
            this.context.complete();
            this.context = new Context();
            this.context.setCurrentUser(currentUser);
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        try {
            this.context.turnOffAuthorisationSystem();
            this.communityService.delete(this.context, this.communityService.find(this.context, this.communityId));
            this.context.restoreAuthSystemState();
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error((Object)"SQL Error in destroy", ex);
            Assert.fail((String)("SQL Error in destroy: " + ex.getMessage()));
        }
        super.destroy();
    }

    @Test
    public void testGetAll() throws Exception {
        List found = this.supervisedItemService.getAll(this.context);
        Assert.assertThat((String)"testGetAll 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAll 1", (found.size() >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (WorkspaceItem sia : found) {
            if (sia.getID() != this.workspaceItemId) continue;
            added = true;
        }
        Assert.assertTrue((String)"testGetAll 2", (boolean)added);
    }

    @Test
    public void testGetSupervisorGroups_Context_int() throws Exception {
        List found = this.workspaceItemService.find(this.context, this.workspaceItemId).getSupervisorGroups();
        Assert.assertThat((String)"testGetSupervisorGroups_Context_int 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetSupervisorGroups_Context_int 1", (found.size() == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testGetSupervisorGroups_Context_int 2", (Object)((Group)found.get(0)).getID(), (Matcher)CoreMatchers.equalTo((Object)this.groupId));
    }

    @Test
    public void testGetSupervisorGroups_0args() throws Exception {
        List found = this.workspaceItemService.find(this.context, this.workspaceItemId).getSupervisorGroups();
        Assert.assertThat((String)"testGetSupervisorGroups_0args 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetSupervisorGroups_0args 1", (found.size() == 1 ? 1 : 0) != 0);
        boolean added = false;
        for (Group g : found) {
            if (!g.getID().equals(this.groupId)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testGetSupervisorGroups_0args 2", (boolean)added);
    }

    @Test
    public void testFindbyEPerson() throws Exception {
        this.context.turnOffAuthorisationSystem();
        List found = this.supervisedItemService.findbyEPerson(this.context, this.ePersonService.create(this.context));
        Assert.assertThat((String)"testFindbyEPerson 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindbyEPerson 1", (found.size() == 0 ? 1 : 0) != 0);
        found = this.supervisedItemService.findbyEPerson(this.context, this.context.getCurrentUser());
        Assert.assertThat((String)"testFindbyEPerson 2", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindbyEPerson 3", (found.size() >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (WorkspaceItem sia : found) {
            if (sia.getID() != this.workspaceItemId) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindbyEPerson 4", (boolean)added);
        this.context.restoreAuthSystemState();
    }
}

