/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.comparator;

import org.dspace.content.DSpaceObject;
import org.dspace.content.comparator.NameAscendingComparator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NameAscendingComparatorTest {
    private NameAscendingComparator comparator = new NameAscendingComparator();
    @Mock
    private DSpaceObject dso1;
    @Mock
    private DSpaceObject dso2;

    @Test
    public void testCompareLessThan() throws Exception {
        Mockito.when((Object)this.dso1.getName()).thenReturn((Object)"a");
        Mockito.when((Object)this.dso2.getName()).thenReturn((Object)"b");
        Assert.assertTrue((this.comparator.compare(this.dso1, this.dso2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareGreaterThan() throws Exception {
        Mockito.when((Object)this.dso1.getName()).thenReturn((Object)"b");
        Mockito.when((Object)this.dso2.getName()).thenReturn((Object)"a");
        Assert.assertTrue((this.comparator.compare(this.dso1, this.dso2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareEqual() throws Exception {
        Mockito.when((Object)this.dso1.getName()).thenReturn((Object)"b");
        Mockito.when((Object)this.dso2.getName()).thenReturn((Object)"b");
        Assert.assertTrue((this.comparator.compare(this.dso1, this.dso2) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareFirstNull() throws Exception {
        Mockito.when((Object)this.dso2.getName()).thenReturn((Object)"b");
        Assert.assertTrue((this.comparator.compare(null, this.dso2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareSecondNull() throws Exception {
        Mockito.when((Object)this.dso1.getName()).thenReturn((Object)"a");
        Assert.assertTrue((this.comparator.compare(this.dso1, null) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareBothNull() throws Exception {
        Assert.assertTrue((this.comparator.compare(null, null) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareNameNull() throws Exception {
        Mockito.when((Object)this.dso1.getName()).thenReturn(null);
        Mockito.when((Object)this.dso2.getName()).thenReturn((Object)"b");
        Assert.assertTrue((this.comparator.compare(this.dso1, this.dso2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareCaseInsensitive() throws Exception {
        Mockito.when((Object)this.dso1.getName()).thenReturn((Object)"a");
        Mockito.when((Object)this.dso2.getName()).thenReturn((Object)"B");
        Assert.assertTrue((this.comparator.compare(this.dso1, this.dso2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareCaseTrimmed() throws Exception {
        Mockito.when((Object)this.dso1.getName()).thenReturn((Object)"a");
        Mockito.when((Object)this.dso2.getName()).thenReturn((Object)" b ");
        Assert.assertTrue((this.comparator.compare(this.dso1, this.dso2) < 0 ? 1 : 0) != 0);
    }
}

