/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PackageUtilsTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(PackageUtilsTest.class);
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private static String topCommunityHandle = null;
    private static String testCollectionHandle = null;

    @BeforeClass
    public static void setUpClass() {
        try {
            Context context = new Context();
            context.turnOffAuthorisationSystem();
            CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
            CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
            log.info((Object)"setUpClass() - CREATE TEST HIERARCHY");
            Community topCommunity = communityService.create(null, context);
            communityService.addMetadata(context, (DSpaceObject)topCommunity, "dc", "title", null, null, "Top Community");
            communityService.update(context, (DSpaceObject)topCommunity);
            topCommunityHandle = topCommunity.getHandle();
            Community child = communityService.createSubcommunity(context, topCommunity);
            communityService.addMetadata(context, (DSpaceObject)child, "dc", "title", null, null, "Child Community");
            communityService.update(context, (DSpaceObject)child);
            Collection grandchildCol = collectionService.create(context, child);
            collectionService.addMetadata(context, (DSpaceObject)grandchildCol, "dc", "title", null, null, "Grandchild Collection");
            collectionService.update(context, (DSpaceObject)grandchildCol);
            testCollectionHandle = grandchildCol.getHandle();
            context.restoreAuthSystemState();
            context.complete();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in setUpClass()", (Throwable)ex);
            Assert.fail((String)("Authorization Error in setUpClass(): " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in setUpClass()", (Throwable)ex);
            Assert.fail((String)("SQL Error in setUpClass(): " + ex.getMessage()));
        }
    }

    @AfterClass
    public static void tearDownClass() {
        try {
            Context context = new Context();
            CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
            HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
            Community topCommunity = (Community)handleService.resolveToObject(context, topCommunityHandle);
            if (topCommunity != null) {
                log.info((Object)"tearDownClass() - DESTROY TEST HIERARCHY");
                context.turnOffAuthorisationSystem();
                communityService.delete(context, (DSpaceObject)topCommunity);
                context.restoreAuthSystemState();
                context.complete();
            }
            if (context.isValid()) {
                context.abort();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error in tearDownClass()", (Throwable)ex);
        }
    }

    @Override
    @Before
    public void init() {
        super.init();
        this.context.turnOffAuthorisationSystem();
    }

    @Test
    public void testCrosswalkGroupNameWithoutUnderscore() throws Exception {
        Collection testCollection = (Collection)this.handleService.resolveToObject(this.context, testCollectionHandle);
        Group originalFirstStepWorkflowGroup = testCollection.getWorkflowStep1();
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group testGroup = groupService.create(this.context);
        groupService.setName(testGroup, "TESTGROUP");
        testCollection.setWorkflowGroup(this.context, 1, testGroup);
        String exportName = PackageUtils.translateGroupNameForExport((Context)this.context, (String)testGroup.getName());
        Assert.assertEquals((String)"Group name without underscore unchanged by translation for export", (Object)testGroup.getName(), (Object)exportName);
        String importName = PackageUtils.translateGroupNameForImport((Context)this.context, (String)exportName);
        Assert.assertEquals((String)"Exported Group name without underscore unchanged by translation for import", (Object)exportName, (Object)importName);
        testCollection.setWorkflowGroup(this.context, 1, originalFirstStepWorkflowGroup);
    }

    @Test
    public void testCrosswalkGroupNameUnderscoresNoDSO() throws Exception {
        Collection testCollection = (Collection)this.handleService.resolveToObject(this.context, testCollectionHandle);
        Group originalFirstStepWorkflowGroup = testCollection.getWorkflowStep1();
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group testGroup = groupService.create(this.context);
        groupService.setName(testGroup, "TESTGROUP_ABC_TEST");
        testCollection.setWorkflowGroup(this.context, 1, testGroup);
        String exportName = PackageUtils.translateGroupNameForExport((Context)this.context, (String)testGroup.getName());
        Assert.assertEquals((String)"Group name with underscores but no DSO unchanged by translation for export", (Object)testGroup.getName(), (Object)exportName);
        String importName = PackageUtils.translateGroupNameForImport((Context)this.context, (String)exportName);
        Assert.assertEquals((String)"Exported Group name with underscores but no DSO unchanged by translation for import", (Object)exportName, (Object)importName);
        testCollection.setWorkflowGroup(this.context, 1, originalFirstStepWorkflowGroup);
    }

    @Test
    public void testCrosswalkGroupNameUnderscoresAndDSO() throws Exception {
        Collection testCollection = (Collection)this.handleService.resolveToObject(this.context, testCollectionHandle);
        Group originalFirstStepWorkflowGroup = testCollection.getWorkflowStep1();
        Group group = this.collectionService.createWorkflowGroup(this.context, testCollection, 1);
        String exportName = PackageUtils.translateGroupNameForExport((Context)this.context, (String)group.getName());
        Assert.assertNotEquals((String)"Exported group name should differ from original", (Object)group.getName(), (Object)exportName);
        Assert.assertThat((String)"Exported group name should contain '_hdl:' substring", (Object)exportName, (Matcher)CoreMatchers.containsString((String)"_hdl:"));
        String importName = PackageUtils.translateGroupNameForImport((Context)this.context, (String)exportName);
        Assert.assertEquals((String)"Exported Group name with dso unchanged by roundtrip translation for export/import", (Object)group.getName(), (Object)importName);
        testCollection.setWorkflowGroup(this.context, 1, originalFirstStepWorkflowGroup);
    }

    @Override
    @After
    public void destroy() {
        this.context.abort();
        this.context.restoreAuthSystemState();
        super.destroy();
    }
}

