/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ContextReadOnlyCache;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ContextReadOnlyCacheTest {
    private ContextReadOnlyCache readOnlyCache;
    @Mock
    private EPerson ePerson;

    @Before
    public void init() {
        this.readOnlyCache = new ContextReadOnlyCache();
        Mockito.when((Object)this.ePerson.getID()).thenReturn((Object)UUID.randomUUID());
    }

    @Test
    public void cacheAuthorizedAction() throws Exception {
        Item item = (Item)Mockito.mock(Item.class);
        Mockito.when((Object)item.getID()).thenReturn((Object)UUID.randomUUID());
        this.readOnlyCache.cacheAuthorizedAction((DSpaceObject)item, 0, this.ePerson, Boolean.valueOf(true));
        this.readOnlyCache.cacheAuthorizedAction((DSpaceObject)item, 1, this.ePerson, Boolean.valueOf(false));
        Assert.assertTrue((boolean)this.readOnlyCache.getCachedAuthorizationResult((DSpaceObject)item, 0, this.ePerson));
        Assert.assertFalse((boolean)this.readOnlyCache.getCachedAuthorizationResult((DSpaceObject)item, 1, this.ePerson));
        Assert.assertNull((Object)this.readOnlyCache.getCachedAuthorizationResult((DSpaceObject)item, 11, this.ePerson));
        Assert.assertNull((Object)this.readOnlyCache.getCachedAuthorizationResult((DSpaceObject)item, 0, null));
        Assert.assertNull((Object)this.readOnlyCache.getCachedAuthorizationResult(null, 0, this.ePerson));
    }

    @Test
    public void cacheGroupMembership() throws Exception {
        Group group1 = this.buildGroupMock("Test Group 1");
        Group group2 = this.buildGroupMock("Test Group 2");
        Group group3 = this.buildGroupMock("Test Group 3");
        this.readOnlyCache.cacheGroupMembership(group1, this.ePerson, Boolean.valueOf(true));
        this.readOnlyCache.cacheGroupMembership(group2, this.ePerson, Boolean.valueOf(false));
        Assert.assertTrue((boolean)this.readOnlyCache.getCachedGroupMembership(group1, this.ePerson));
        Assert.assertFalse((boolean)this.readOnlyCache.getCachedGroupMembership(group2, this.ePerson));
        Assert.assertNull((Object)this.readOnlyCache.getCachedGroupMembership(group3, this.ePerson));
        Assert.assertNull((Object)this.readOnlyCache.getCachedGroupMembership(null, this.ePerson));
        Assert.assertNull((Object)this.readOnlyCache.getCachedGroupMembership(group2, null));
    }

    @Test
    public void cacheAllMemberGroupsSet() throws Exception {
        Group group1 = this.buildGroupMock("Test Group 1");
        Group group2 = this.buildGroupMock("Test Group 2");
        Group group3 = this.buildGroupMock("Test Group 3");
        this.readOnlyCache.cacheAllMemberGroupsSet(this.ePerson, new HashSet<Group>(Arrays.asList(group1, group2)));
        Assert.assertTrue((boolean)this.readOnlyCache.getCachedGroupMembership(group1, this.ePerson));
        Assert.assertTrue((boolean)this.readOnlyCache.getCachedGroupMembership(group2, this.ePerson));
        Assert.assertFalse((boolean)this.readOnlyCache.getCachedGroupMembership(group3, this.ePerson));
        Assert.assertFalse((boolean)this.readOnlyCache.getCachedGroupMembership(null, this.ePerson));
        Assert.assertNull((Object)this.readOnlyCache.getCachedGroupMembership(group2, null));
    }

    @Test
    public void clear() throws Exception {
        Item item = (Item)Mockito.mock(Item.class);
        Mockito.when((Object)item.getID()).thenReturn((Object)UUID.randomUUID());
        Group group1 = this.buildGroupMock("Test Group 1");
        this.readOnlyCache.cacheAuthorizedAction((DSpaceObject)item, 0, this.ePerson, Boolean.valueOf(true));
        this.readOnlyCache.cacheGroupMembership(group1, this.ePerson, Boolean.valueOf(true));
        Assert.assertTrue((boolean)this.readOnlyCache.getCachedAuthorizationResult((DSpaceObject)item, 0, this.ePerson));
        Assert.assertTrue((boolean)this.readOnlyCache.getCachedGroupMembership(group1, this.ePerson));
        this.readOnlyCache.clear();
        Assert.assertNull((Object)this.readOnlyCache.getCachedAuthorizationResult((DSpaceObject)item, 0, this.ePerson));
        Assert.assertNull((Object)this.readOnlyCache.getCachedGroupMembership(group1, this.ePerson));
    }

    private Group buildGroupMock(String name) {
        Group group = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group.getName()).thenReturn((Object)name);
        return group;
    }
}

