/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import mockit.NonStrictExpectations;
import org.apache.commons.lang.StringUtils;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.core.DBConnection;
import org.dspace.core.I18nUtil;
import org.dspace.core.exception.DatabaseSchemaValidationException;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ContextTest
extends AbstractUnitTest {
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    @Test
    public void testGetDBConnection() throws SQLException {
        DBConnection connection = this.context.getDBConnection();
        Assert.assertThat((String)"testGetDBConnection 0", (Object)connection, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetDBConnection 1", (Object)connection.isSessionAlive(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testSchemaValidation() throws SQLException {
        try {
            this.destroy();
            ContextTest.destroyKernel();
            ContextTest.initKernel();
            this.init();
            Assert.fail();
        }
        catch (DatabaseSchemaValidationException ex) {
            Assert.assertTrue((boolean)StringUtils.isNotBlank((String)ex.getMessage()));
            Assert.assertTrue((boolean)StringUtils.contains((String)ex.getMessage(), (String)"Missing table"));
        }
        finally {
            this.destroy();
            ContextTest.destroyKernel();
            ContextTest.initKernel();
            ContextTest.initDatabase();
            this.init();
        }
    }

    @Test
    public void testSetCurrentUser() throws SQLException, AuthorizeException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ContextTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        EPerson oldUser = this.context.getCurrentUser();
        EPerson newUser = this.ePersonService.create(this.context);
        newUser.setFirstName(this.context, "Jane");
        newUser.setLastName(this.context, "Doe");
        newUser.setEmail("jane@email.com");
        newUser.setCanLogIn(true);
        newUser.setLanguage(this.context, I18nUtil.getDefaultLocale().getLanguage());
        this.context.setCurrentUser(newUser);
        Assert.assertThat((String)"testSetCurrentUser 0", (Object)this.context.getCurrentUser(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetCurrentUser 1", (Object)this.context.getCurrentUser(), (Matcher)CoreMatchers.equalTo((Object)newUser));
        this.context.setCurrentUser(oldUser);
    }

    @Test
    public void testGetCurrentUser() {
        Assert.assertThat((String)"testGetCurrentUser 0", (Object)this.context.getCurrentUser(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetCurrentUser 1", (Object)this.context.getCurrentUser(), (Matcher)CoreMatchers.equalTo((Object)this.eperson));
    }

    @Test
    public void testGetCurrentLocale() {
        Assert.assertThat((String)"testGetCurrentLocale 0", (Object)this.context.getCurrentLocale(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetCurrentLocale 1", (Object)this.context.getCurrentLocale(), (Matcher)CoreMatchers.equalTo((Object)I18nUtil.DEFAULTLOCALE));
    }

    @Test
    public void testSetCurrentLocale() {
        Locale oldLocale = this.context.getCurrentLocale();
        Locale newLocale = Locale.FRENCH;
        this.context.setCurrentLocale(newLocale);
        Assert.assertThat((String)"testSetCurrentLocale 0", (Object)this.context.getCurrentLocale(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetCurrentLocale 1", (Object)this.context.getCurrentLocale(), (Matcher)CoreMatchers.equalTo((Object)newLocale));
        this.context.setCurrentLocale(oldLocale);
    }

    @Test
    public void testIgnoreAuthorization() {
        this.context.turnOffAuthorisationSystem();
        Assert.assertThat((String)"testIgnoreAuthorization 0", (Object)this.context.ignoreAuthorization(), (Matcher)CoreMatchers.equalTo((Object)true));
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testIgnoreAuthorization 1", (Object)this.context.ignoreAuthorization(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testSetExtraLogInfo() {
        String oldValue = this.context.getExtraLogInfo();
        String newValue = "This is some extra log info";
        this.context.setExtraLogInfo(newValue);
        Assert.assertThat((String)"testSetExtraLogInfo 0", (Object)this.context.getExtraLogInfo(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetExtraLogInfo 1", (Object)this.context.getExtraLogInfo(), (Matcher)CoreMatchers.equalTo((Object)newValue));
    }

    @Test
    public void testGetExtraLogInfo() {
        String defaultValue = "";
        Assert.assertThat((String)"testGetExtraLogInfo 0", (Object)this.context.getExtraLogInfo(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetExtraLogInfo 1", (Object)this.context.getExtraLogInfo(), (Matcher)CoreMatchers.equalTo((Object)defaultValue));
    }

    @Test
    public void testComplete() throws SQLException {
        Context instance = new Context();
        Assert.assertThat((String)"testComplete 0", (Object)instance.getDBConnection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testComplete 1", (Object)instance.getDBConnection().isSessionAlive(), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((String)"testComplete 2", (Object)instance.isValid(), (Matcher)CoreMatchers.equalTo((Object)true));
        instance.complete();
        Assert.assertThat((String)"testComplete 3", (Object)instance.getDBConnection(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testComplete 4", (Object)instance.isValid(), (Matcher)CoreMatchers.equalTo((Object)false));
        this.cleanupContext(instance);
    }

    @Test
    public void testComplete2() throws SQLException {
        Context instance = new Context();
        instance.complete();
        instance.complete();
        this.cleanupContext(instance);
    }

    @Test
    public void testAbort() throws SQLException, AuthorizeException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ContextTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        Context instance = new Context();
        String createdEmail = "susie@email.com";
        EPerson newUser = this.ePersonService.create(instance);
        newUser.setFirstName(this.context, "Susan");
        newUser.setLastName(this.context, "Doe");
        newUser.setEmail(createdEmail);
        newUser.setCanLogIn(true);
        newUser.setLanguage(this.context, I18nUtil.getDefaultLocale().getLanguage());
        instance.abort();
        Assert.assertThat((String)"testAbort 0", (Object)instance.isValid(), (Matcher)CoreMatchers.equalTo((Object)false));
        Context newInstance = new Context();
        EPerson found = this.ePersonService.findByEmail(newInstance, createdEmail);
        Assert.assertThat((String)"testAbort 1", (Object)found, (Matcher)CoreMatchers.nullValue());
        this.cleanupContext(instance);
        this.cleanupContext(newInstance);
    }

    @Test
    public void testAbort2() throws SQLException {
        Context instance = new Context();
        instance.abort();
        instance.abort();
        this.cleanupContext(instance);
    }

    @Test
    public void testIsReadOnly() throws SQLException {
        Assert.assertThat((String)"testIsReadOnly 0", (Object)this.context.isReadOnly(), (Matcher)CoreMatchers.equalTo((Object)false));
        Context instance = new Context(Context.Mode.READ_ONLY);
        Assert.assertThat((String)"testIsReadOnly 1", (Object)instance.isReadOnly(), (Matcher)CoreMatchers.equalTo((Object)true));
        instance.abort();
        this.cleanupContext(instance);
    }

    @Test
    public void testIsReadOnlyCommit() throws SQLException {
        Context instance = new Context(Context.Mode.READ_ONLY);
        Assert.assertThat((String)"testIsReadOnly 1", (Object)instance.isReadOnly(), (Matcher)CoreMatchers.equalTo((Object)true));
        try {
            instance.commit();
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof UnsupportedOperationException));
        }
        instance.abort();
        this.cleanupContext(instance);
    }

    @Test
    public void testSetSpecialGroup() throws SQLException {
        Context instance = new Context();
        UUID groupID1 = UUID.randomUUID();
        UUID groupID2 = UUID.randomUUID();
        instance.setSpecialGroup(groupID1);
        instance.setSpecialGroup(groupID2);
        Assert.assertThat((String)"testSetSpecialGroup 0", (Object)instance.inSpecialGroup(groupID1), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((String)"testSetSpecialGroup 1", (Object)instance.inSpecialGroup(groupID2), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((String)"testSetSpecialGroup 2", (Object)instance.inSpecialGroup(UUID.randomUUID()), (Matcher)CoreMatchers.equalTo((Object)false));
        this.cleanupContext(instance);
    }

    @Test
    public void testGetSpecialGroups() throws SQLException, AuthorizeException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ContextTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        Context instance = new Context();
        Group group = this.groupService.create(instance);
        UUID groupID = group.getID();
        instance.setSpecialGroup(groupID);
        Group adminGroup = this.groupService.findByName(instance, "Administrator");
        UUID adminGroupID = adminGroup.getID();
        instance.setSpecialGroup(adminGroupID);
        List specialGroups = instance.getSpecialGroups();
        Assert.assertThat((String)"testGetSpecialGroup 0", (Object)specialGroups.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((String)"testGetSpecialGroup 1", specialGroups.get(0), (Matcher)CoreMatchers.equalTo((Object)group));
        Assert.assertThat((String)"testGetSpecialGroup 1", specialGroups.get(1), (Matcher)CoreMatchers.equalTo((Object)adminGroup));
        this.cleanupContext(instance);
    }

    @Test
    public void testFinalize() throws Throwable {
        Context instance = new Context();
        instance.finalize();
        Assert.assertThat((String)"testSetSpecialGroup 0", (Object)instance.isValid(), (Matcher)CoreMatchers.equalTo((Object)false));
        this.cleanupContext(instance);
    }
}

