/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import org.apache.commons.codec.DecoderException;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EPersonTest
extends AbstractUnitTest {
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    private static final Logger log = Logger.getLogger(EPersonTest.class);

    @Override
    @Before
    public void init() {
        super.init();
        this.context.turnOffAuthorisationSystem();
        try {
            EPerson eperson = this.ePersonService.create(this.context);
            eperson.setEmail("kevin@dspace.org");
            eperson.setFirstName(this.context, "Kevin");
            eperson.setLastName(this.context, "Van de Velde");
            eperson.setNetid("1985");
            eperson.setPassword("test");
            this.ePersonService.update(this.context, (DSpaceObject)eperson);
        }
        catch (SQLException | AuthorizeException ex) {
            log.error((Object)"Error in init", ex);
            Assert.fail((String)("Error in init: " + ex.getMessage()));
        }
        finally {
            this.context.restoreAuthSystemState();
        }
    }

    @Override
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            EPerson testPerson = this.ePersonService.findByEmail(this.context, "kevin@dspace.org");
            if (testPerson != null) {
                this.ePersonService.delete(this.context, (DSpaceObject)testPerson);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error in destroy", (Throwable)ex);
            Assert.fail((String)("Error in destroy: " + ex.getMessage()));
        }
        super.destroy();
    }

    @Test
    public void testCheckPassword() throws SQLException, DecoderException {
        EPerson eperson = this.ePersonService.findByEmail(this.context, "kevin@dspace.org");
        this.ePersonService.checkPassword(this.context, eperson, "test");
    }

    @Test
    public void testGetType() throws SQLException {
        System.out.println("getType");
        int expResult = 7;
        int result = this.eperson.getType();
        Assert.assertEquals((String)"Should return Constants.EPERSON", (long)expResult, (long)result);
    }
}

