/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.DecoderException;
import org.dspace.AbstractDSpaceTest;
import org.dspace.eperson.PasswordHash;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PasswordHashTest
extends AbstractDSpaceTest {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testConstructors() throws DecoderException {
        PasswordHash h3 = new PasswordHash(null, (byte[])null, (byte[])null);
        Assert.assertNull((String)"Null algorithm", (Object)h3.getAlgorithm());
        Assert.assertNull((String)"Null salt", (Object)h3.getSalt());
        Assert.assertNull((String)"Null hash", (Object)h3.getHash());
        Assert.assertFalse((String)"Match null string?", (boolean)h3.matches(null));
        Assert.assertFalse((String)"Match non-null string?", (boolean)h3.matches("not null"));
        h3 = new PasswordHash(null, (String)null, (String)null);
        Assert.assertNull((String)"Null algorithm", (Object)h3.getAlgorithm());
        Assert.assertNull((String)"Null salt", (Object)h3.getSalt());
        Assert.assertNull((String)"Null hash", (Object)h3.getHash());
        Assert.assertFalse((String)"Match null string?", (boolean)h3.matches(null));
        Assert.assertFalse((String)"Match non-null string?", (boolean)h3.matches("not null"));
        String password = "I've got a secret.";
        PasswordHash h1 = new PasswordHash(password);
        Assert.assertEquals((Object)"SHA-512", (Object)h1.getAlgorithm());
        Assert.assertFalse((String)"Match against a different string", (boolean)h1.matches("random rubbish"));
        Assert.assertTrue((String)"Match against the correct string", (boolean)h1.matches(password));
        h3 = new PasswordHash(h1.getAlgorithm(), h1.getSalt(), h1.getHash());
        Assert.assertTrue((String)"Match a duplicate original made from getter values", (boolean)h3.matches(password));
    }

    @Test
    public void testMatches() throws NoSuchAlgorithmException {
        System.out.println("matches");
        String secret = "Clark Kent is Superman";
        MessageDigest digest = MessageDigest.getInstance("MD5");
        PasswordHash hash = new PasswordHash(null, null, digest.digest("Clark Kent is Superman".getBytes()));
        boolean result = hash.matches("Clark Kent is Superman");
        Assert.assertTrue((String)"Old unsalted 1-trip MD5 hash", (boolean)result);
    }
}

