/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle.dao.impl;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.dao.HandleDAO;
import org.dspace.utils.DSpace;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersioningService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HandleDAOImplTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(HandleDAOImplTest.class);
    private Item item1;
    private Item item2;
    private Item item3;
    private Item item4;
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected VersioningService versioningService = VersionServiceFactory.getInstance().getVersionService();
    private HandleDAO handleDAO = (HandleDAO)new DSpace().getServiceManager().getServicesByType(HandleDAO.class).get(0);
    private Community owningCommunity;
    private static final String HANDLE_PREFIX = "123456789";
    private static final String SUFFIX_1 = "11";
    private static final String SUFFIX_2 = "11.2";
    private static final String SUFFIX_3 = "33";
    private static final String SUFFIX_4 = "44";

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            Collection collection = this.collectionService.create(this.context, this.owningCommunity);
            WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, collection, false);
            this.item1 = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem, "123456789/11");
            this.item1.setSubmitter(this.context.getCurrentUser());
            this.itemService.update(this.context, (DSpaceObject)this.item1);
            this.item2 = this.versioningService.createNewVersion(this.context, this.item1).getItem();
            workspaceItem = this.workspaceItemService.create(this.context, collection, false);
            this.item3 = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem, "123456789/33");
            this.item3.setSubmitter(this.context.getCurrentUser());
            this.itemService.update(this.context, (DSpaceObject)this.item3);
            workspaceItem = this.workspaceItemService.create(this.context, collection, false);
            this.item4 = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem, "hdl:custom-prefix/44");
            this.item4.setSubmitter(this.context.getCurrentUser());
            this.itemService.update(this.context, (DSpaceObject)this.item4);
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (IOException ex) {
            log.error((Object)"Failed to assign handle", (Throwable)ex);
            Assert.fail((String)("Failed to assign handle: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = (Community)this.context.reloadEntity((ReloadableEntity)this.owningCommunity);
            ContentServiceFactory.getInstance().getCommunityService().delete(this.context, (DSpaceObject)this.owningCommunity);
            this.owningCommunity = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.item1 = null;
        this.item2 = null;
        this.item3 = null;
        this.item4 = null;
        super.destroy();
    }

    @Test
    public void updateHandlesWithNewPrefix() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String newPrefix = "987654321";
        this.handleDAO.updateHandlesWithNewPrefix(this.context, newPrefix, HANDLE_PREFIX);
        this.context.commit();
        Assert.assertEquals((Object)(newPrefix + "/" + SUFFIX_1), (Object)((Item)this.itemService.find(this.context, this.item1.getID())).getHandle());
        Assert.assertEquals((Object)(newPrefix + "/" + SUFFIX_2), (Object)((Item)this.itemService.find(this.context, this.item2.getID())).getHandle());
        Assert.assertEquals((Object)(newPrefix + "/" + SUFFIX_3), (Object)((Item)this.itemService.find(this.context, this.item3.getID())).getHandle());
        Assert.assertEquals((Object)"hdl:custom-prefix/44", (Object)((Item)this.itemService.find(this.context, this.item4.getID())).getHandle());
        this.context.restoreAuthSystemState();
    }
}

