/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.EZIDIdentifierProvider;
import org.dspace.identifier.ezid.DateToYear;
import org.dspace.identifier.ezid.Transform;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EZIDIdentifierProviderTest
extends AbstractUnitTest {
    private static final String TEST_SHOULDER = "10.5072/FK2";
    private static final Map<String, String> aCrosswalk = new HashMap<String, String>();
    private static final Map<String, Transform> crosswalkTransforms;
    private static ConfigurationService config;
    private static Community community;
    private static Collection collection;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    private static Item item;

    private void dumpMetadata(Item eyetem) {
        List metadata = this.itemService.getMetadata((DSpaceObject)eyetem, "dc", "*", "*", "*");
        for (MetadataValue metadatum : metadata) {
            System.out.printf("Metadata:  %s.%s.%s(%s) = %s\n", metadatum.getMetadataField().getMetadataSchema().getName(), metadatum.getMetadataField().getElement(), metadatum.getMetadataField().getQualifier(), metadatum.getLanguage(), metadatum.getValue());
        }
    }

    private Item newItem() throws SQLException, AuthorizeException, IOException, WorkflowException {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wsItem = this.workspaceItemService.create(this.context, collection, false);
        WorkflowItem wfItem = WorkflowServiceFactory.getInstance().getWorkflowService().start(this.context, wsItem);
        item = wfItem.getItem();
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "contributor", "author", null, "Author, A. N.");
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "title", null, null, "A Test Object");
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "publisher", null, null, "DSpace Test Harness");
        this.itemService.update(this.context, (DSpaceObject)item);
        this.context.restoreAuthSystemState();
        return item;
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        config = DSpaceServicesFactory.getInstance().getConfigurationService();
        config.setProperty("identifier.doi.ezid.shoulder", (Object)TEST_SHOULDER);
        config.setProperty("identifier.doi.ezid.user", (Object)"apitest");
        config.setProperty("identifier.doi.ezid.password", (Object)"apitest");
        config.setProperty("mail.server.disabled", (Object)"true");
        EZIDIdentifierProvider instance = new EZIDIdentifierProvider();
        instance.setConfigurationService(config);
        instance.setCrosswalk(aCrosswalk);
        instance.setCrosswalkTransform(crosswalkTransforms);
        instance.setItemService(ContentServiceFactory.getInstance().getItemService());
        DSpaceServicesFactory.getInstance().getServiceManager().registerServiceNoAutowire(EZIDIdentifierProvider.class.getName(), (Object)instance);
        Assert.assertNotNull((Object)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(EZIDIdentifierProvider.class.getName(), EZIDIdentifierProvider.class));
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        DSpaceServicesFactory.getInstance().getServiceManager().unregisterService(EZIDIdentifierProvider.class.getName());
        System.out.print("Tearing down\n\n");
    }

    @Before
    public void setUp() throws Exception {
        this.context.turnOffAuthorisationSystem();
        community = this.communityService.create(community, this.context);
        this.communityService.setMetadata(this.context, community, "name", "A Test Community");
        this.communityService.update(this.context, (DSpaceObject)community);
        collection = this.collectionService.create(this.context, community);
        this.collectionService.setMetadata(this.context, collection, "name", "A Test Collection");
        this.collectionService.update(this.context, (DSpaceObject)collection);
    }

    @After
    public void tearDown() throws SQLException {
        this.context.restoreAuthSystemState();
        this.dumpMetadata(item);
    }

    @Test
    public void testSupports_Class() {
        System.out.println("supports Class");
        EZIDIdentifierProvider instance = (EZIDIdentifierProvider)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(EZIDIdentifierProvider.class.getName(), EZIDIdentifierProvider.class);
        Class<DOI> identifier = DOI.class;
        boolean result = instance.supports(identifier);
        Assert.assertTrue((String)"DOI is supported", (boolean)result);
    }

    @Test
    public void testSupports_String() {
        System.out.println("supports String");
        EZIDIdentifierProvider instance = (EZIDIdentifierProvider)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(EZIDIdentifierProvider.class.getName(), EZIDIdentifierProvider.class);
        String identifier = "doi:10.5072/FK2";
        boolean result = instance.supports(identifier);
        Assert.assertTrue((String)(identifier + " is supported"), (boolean)result);
    }

    @Test
    public void testCrosswalkMetadata() throws Exception {
        try {
            System.out.println("crosswalkMetadata");
            EZIDIdentifierProvider instance = (EZIDIdentifierProvider)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(EZIDIdentifierProvider.class.getName(), EZIDIdentifierProvider.class);
            Item dso = this.newItem();
            String handle = dso.getHandle();
            Map metadata = instance.crosswalkMetadata(this.context, (DSpaceObject)dso);
            String target = (String)metadata.get("_target");
            Assert.assertEquals((String)"Generates correct _target metadatum", (Object)(config.getProperty("dspace.url") + "/handle/" + handle), (Object)target);
            Assert.assertTrue((String)"Has title", (boolean)metadata.containsKey("datacite.title"));
            Assert.assertTrue((String)"Has publication year", (boolean)metadata.containsKey("datacite.publicationyear"));
            Assert.assertTrue((String)"Has publisher", (boolean)metadata.containsKey("datacite.publisher"));
            Assert.assertTrue((String)"Has creator", (boolean)metadata.containsKey("datacite.creator"));
            System.out.println("Results:");
            for (Map.Entry metadatum : metadata.entrySet()) {
                System.out.printf("  %s : %s\n", metadatum.getKey(), metadatum.getValue());
            }
        }
        catch (NullPointerException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            System.out.println(sw.toString());
            Logger.getLogger(EZIDIdentifierProviderTest.class).fatal((Object)"Caught NPE", (Throwable)ex);
            throw ex;
        }
    }

    static {
        aCrosswalk.put("datacite.creator", "dc.contributor.author");
        aCrosswalk.put("datacite.title", "dc.title");
        aCrosswalk.put("datacite.publisher", "dc.publisher");
        aCrosswalk.put("datacite.publicationyear", "dc.date.issued");
        crosswalkTransforms = new HashMap<String, Transform>();
        crosswalkTransforms.put("datacite.publicationyear", (Transform)new DateToYear());
        config = null;
    }
}

