/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.AbstractDSpaceTest;
import org.dspace.AbstractIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.factory.BasicWorkflowServiceFactory;
import org.dspace.workflowbasic.service.BasicWorkflowItemService;
import org.dspace.workflowbasic.service.BasicWorkflowService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicWorkflowAuthorizationIT
extends AbstractIntegrationTest {
    private static final Logger log = Logger.getLogger(BasicWorkflowAuthorizationIT.class);
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected BasicWorkflowItemService basicWorkflowItemService = BasicWorkflowServiceFactory.getInstance().getBasicWorkflowItemService();
    protected BasicWorkflowService basicWorkflowService = BasicWorkflowServiceFactory.getInstance().getBasicWorkflowService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected Community owningCommunity = null;
    protected Collection collection = null;
    protected Group group = null;
    protected EPerson member = null;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.configurationService.setProperty("workflow.notify.returned.tasks", (Object)false);
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            this.member = this.ePersonService.create(this.context);
            this.group = this.groupService.create(this.context);
            this.groupService.addMember(this.context, this.group, this.member);
            this.groupService.update(this.context, (DSpaceObject)this.group);
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        finally {
            this.context.restoreAuthSystemState();
        }
    }

    @Override
    @After
    public void destroy() {
        block16: {
            try {
                this.context.turnOffAuthorisationSystem();
                if (this.collection != null) {
                    try {
                        this.collectionService.delete(this.context, (DSpaceObject)this.collection);
                    }
                    catch (Exception e) {
                        log.error((Object)"deleting collection", (Throwable)e);
                    }
                    this.collection = null;
                }
                if (this.owningCommunity != null) {
                    try {
                        this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
                    }
                    catch (Exception e) {
                        log.error((Object)"deleting community", (Throwable)e);
                    }
                    this.owningCommunity = null;
                }
                if (this.member == null) break block16;
                if (this.group != null) {
                    try {
                        this.groupService.removeMember(this.context, this.group, this.member);
                    }
                    catch (Exception e) {
                        log.error((Object)"detaching group relationship", (Throwable)e);
                    }
                    try {
                        this.groupService.delete(this.context, (DSpaceObject)this.group);
                    }
                    catch (Exception e) {
                        log.error((Object)"detaching group relationship", (Throwable)e);
                    }
                    this.group = null;
                }
                try {
                    this.ePersonService.delete(this.context, (DSpaceObject)this.member);
                }
                catch (Exception e) {
                    log.error((Object)"deleting user", (Throwable)e);
                }
            }
            finally {
                this.context.restoreAuthSystemState();
            }
        }
        super.destroy();
    }

    private void setWorkflowGroup(Collection collection, Context context, int step, Group group) throws SQLException, AuthorizeException {
        collection.setWorkflowGroup(context, step, group);
    }

    @Test
    public void testsetWorkflowGroupSetsPermission() throws SQLException, AuthorizeException {
        int step = 1;
        try {
            this.context.turnOffAuthorisationSystem();
            this.setWorkflowGroup(this.collection, this.context, step, this.group);
            this.collectionService.update(this.context, (DSpaceObject)this.collection);
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        Assert.assertThat((String)"testsetWorkflowGroupSetsPermission 0", (Object)this.collectionService.getWorkflowGroup(this.collection, step), (Matcher)CoreMatchers.equalTo((Object)this.group));
        Assert.assertTrue((boolean)this.groupService.isDirectMember(this.group, this.member));
        Assert.assertTrue((String)"testsetWorkflowGroupSetsPermission 1", (boolean)this.authorizeService.authorizeActionBoolean(this.context, this.member, (DSpaceObject)this.collection, 5, true));
    }

    @Test
    public void testsetWorkflowGroupRevokesPermission() throws SQLException, AuthorizeException {
        int step = 1;
        try {
            this.context.turnOffAuthorisationSystem();
            this.setWorkflowGroup(this.collection, this.context, step, this.group);
            this.collectionService.update(this.context, (DSpaceObject)this.collection);
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        Assert.assertThat((String)"testsetWorkflowGroupRevokesPermission 0", (Object)this.collectionService.getWorkflowGroup(this.collection, step), (Matcher)CoreMatchers.equalTo((Object)this.group));
        Assert.assertTrue((String)"testsetWorkflowGroupRevokesPermission 1", (boolean)this.authorizeService.authorizeActionBoolean(this.context, this.member, (DSpaceObject)this.collection, 5, true));
        try {
            this.context.turnOffAuthorisationSystem();
            this.setWorkflowGroup(this.collection, this.context, step, null);
            this.collectionService.update(this.context, (DSpaceObject)this.collection);
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        Assert.assertThat((String)"testsetWorkflowGroupRevokesPermission 2", (Object)this.collectionService.getWorkflowGroup(this.collection, step), (Matcher)CoreMatchers.nullValue());
        Assert.assertFalse((String)"testsetWorkflowGroupRevokesPermission 3", (boolean)this.authorizeService.authorizeActionBoolean(this.context, this.member, (DSpaceObject)this.collection, 5, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReviewerPermissions() throws SQLException, AuthorizeException, IOException, WorkflowException {
        BasicWorkflowItem wfi = null;
        try {
            this.context.turnOffAuthorisationSystem();
            this.setWorkflowGroup(this.collection, this.context, 1, this.group);
            this.collectionService.update(this.context, (DSpaceObject)this.collection);
            WorkspaceItem wsi = this.workspaceItemService.create(this.context, this.collection, false);
            Item item = wsi.getItem();
            Bundle bundle = this.bundleService.create(this.context, item, "ORIGINAL");
            File f = new File(AbstractDSpaceTest.testProps.get("test.bitstream").toString());
            Bitstream bs = this.bitstreamService.create(this.context, bundle, (InputStream)new FileInputStream(f));
            this.bundleService.update(this.context, (DSpaceObject)bundle);
            this.itemService.update(this.context, (DSpaceObject)item);
            this.workspaceItemService.update(this.context, (InProgressSubmission)wsi);
            wfi = (BasicWorkflowItem)this.basicWorkflowService.startWithoutNotify(this.context, wsi);
            this.basicWorkflowItemService.update(this.context, (InProgressSubmission)wfi);
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        wfi = (BasicWorkflowItem)this.basicWorkflowItemService.find(this.context, wfi.getID().intValue());
        this.basicWorkflowService.claim(this.context, wfi, this.member);
        Item item = wfi.getItem();
        int i = 0;
        for (int action : new int[]{0, 1, 3, 4, 2}) {
            Assert.assertTrue((String)("testReviewerPermissions 1-" + i++), (boolean)this.authorizeService.authorizeActionBoolean(this.context, this.member, (DSpaceObject)item, action, false));
        }
        Bundle bundle = (Bundle)this.itemService.getBundles(item, "ORIGINAL").get(0);
        Bitstream bitstream = (Bitstream)bundle.getBitstreams().get(0);
        Assert.assertTrue((String)"testReviewerPermissions 2-1", (boolean)this.authorizeService.authorizeActionBoolean(this.context, this.member, (DSpaceObject)bundle, 0, false));
        Assert.assertTrue((String)("testReviewerPermissions 2-2" + i++), (boolean)this.authorizeService.authorizeActionBoolean(this.context, this.member, (DSpaceObject)bitstream, 0, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=AuthorizeException.class)
    public void testNonWorkflowGroupMemberCannotClaimTask() throws SQLException, AuthorizeException, IOException, WorkflowException {
        BasicWorkflowItem wfi = null;
        EPerson someone = null;
        try {
            this.context.turnOffAuthorisationSystem();
            someone = this.ePersonService.create(this.context);
            this.setWorkflowGroup(this.collection, this.context, 1, this.group);
            this.collectionService.update(this.context, (DSpaceObject)this.collection);
            WorkspaceItem wsi = this.workspaceItemService.create(this.context, this.collection, false);
            Item item = wsi.getItem();
            Bundle bundle = this.bundleService.create(this.context, item, "ORIGINAL");
            File f = new File(AbstractDSpaceTest.testProps.get("test.bitstream").toString());
            Bitstream bs = this.bitstreamService.create(this.context, bundle, (InputStream)new FileInputStream(f));
            this.bundleService.update(this.context, (DSpaceObject)bundle);
            this.itemService.update(this.context, (DSpaceObject)item);
            this.workspaceItemService.update(this.context, (InProgressSubmission)wsi);
            wfi = (BasicWorkflowItem)this.basicWorkflowService.startWithoutNotify(this.context, wsi);
            this.basicWorkflowItemService.update(this.context, (InProgressSubmission)wfi);
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        wfi = (BasicWorkflowItem)this.basicWorkflowItemService.find(this.context, wfi.getID().intValue());
        this.basicWorkflowService.claim(this.context, wfi, someone);
        Assert.fail((String)"Someone, not part of a workflow step group was able to claim a task without an AUthorizeException.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=AuthorizeException.class)
    public void testNonWorkflowGroupSubmitterCannotClaimTask() throws SQLException, AuthorizeException, IOException, WorkflowException {
        BasicWorkflowItem wfi = null;
        EPerson submitter = null;
        try {
            this.context.turnOffAuthorisationSystem();
            submitter = this.ePersonService.create(this.context);
            this.setWorkflowGroup(this.collection, this.context, 1, this.group);
            this.collectionService.update(this.context, (DSpaceObject)this.collection);
            WorkspaceItem wsi = this.workspaceItemService.create(this.context, this.collection, false);
            Item item = wsi.getItem();
            item.setSubmitter(submitter);
            Bundle bundle = this.bundleService.create(this.context, item, "ORIGINAL");
            File f = new File(AbstractDSpaceTest.testProps.get("test.bitstream").toString());
            Bitstream bs = this.bitstreamService.create(this.context, bundle, (InputStream)new FileInputStream(f));
            this.bundleService.update(this.context, (DSpaceObject)bundle);
            this.itemService.update(this.context, (DSpaceObject)item);
            this.workspaceItemService.update(this.context, (InProgressSubmission)wsi);
            wfi = (BasicWorkflowItem)this.basicWorkflowService.startWithoutNotify(this.context, wsi);
            this.basicWorkflowItemService.update(this.context, (InProgressSubmission)wfi);
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        wfi = (BasicWorkflowItem)this.basicWorkflowItemService.find(this.context, wfi.getID().intValue());
        this.basicWorkflowService.claim(this.context, wfi, submitter);
        Assert.fail((String)"A submitter was able to claim a task without being a member of the appropriate workflow step group. Expected: AuthorizeException.");
    }
}

