/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dspace.AbstractDSpaceTest;
import org.dspace.AbstractIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflowbasic.BasicWorkflowAuthorizationIT;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.factory.BasicWorkflowServiceFactory;
import org.dspace.workflowbasic.service.BasicWorkflowItemService;
import org.dspace.workflowbasic.service.BasicWorkflowService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicWorkflowAuthorizationRolesIT
extends AbstractIntegrationTest {
    private static final Logger log = Logger.getLogger(BasicWorkflowAuthorizationIT.class);
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected BasicWorkflowItemService basicWorkflowItemService = BasicWorkflowServiceFactory.getInstance().getBasicWorkflowItemService();
    protected BasicWorkflowService basicWorkflowService = BasicWorkflowServiceFactory.getInstance().getBasicWorkflowService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected Community owningCommunity = null;
    protected Collection collection = null;
    protected Item item = null;
    protected BasicWorkflowItem wfi = null;
    protected Group mgroup = null;
    protected EPerson member = null;
    protected WorkspaceItem wsi = null;
    protected HashMap<ROLE, Group> roleGroups = new HashMap();
    protected HashMap<ROLE, EPerson> roleEPersons = new HashMap();

    public BasicWorkflowAuthorizationRolesIT() {
        this.roleGroups.clear();
        this.roleEPersons.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.configurationService.setProperty("workflow.notify.returned.tasks", (Object)false);
            this.context.turnOffAuthorisationSystem();
            long date = new Date().getTime();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            this.member = this.ePersonService.create(this.context);
            this.member.setEmail(String.format("wf-member-%d@example.org", date));
            this.member.setFirstName(this.context, "Member");
            this.ePersonService.update(this.context, (DSpaceObject)this.member);
            this.mgroup = this.groupService.create(this.context);
            this.groupService.addMember(this.context, this.mgroup, this.member);
            this.groupService.setName(this.mgroup, String.format("Member Group %d", date));
            this.groupService.update(this.context, (DSpaceObject)this.mgroup);
            for (ROLE role : ROLE.values()) {
                EPerson person = this.ePersonService.create(this.context);
                person.setFirstName(this.context, String.format("%d", date));
                person.setLastName(this.context, String.format("Role %s", role.toString()));
                person.setEmail(String.format("basicwf-test-%s-%d@example.org", role.toString(), date));
                this.ePersonService.update(this.context, (DSpaceObject)person);
                this.roleEPersons.put(role, person);
                Group pgroup = this.groupService.create(this.context);
                this.roleGroups.put(role, pgroup);
                this.groupService.setName(pgroup, String.format("Group %s %d", role.toString(), date));
                this.groupService.addMember(this.context, pgroup, person);
                this.groupService.update(this.context, (DSpaceObject)pgroup);
                log.info((Object)String.format("Create ROLE %s GROUP %s PERSON %s", role.toString(), pgroup.getName(), person.getFullName()));
            }
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        finally {
            this.context.restoreAuthSystemState();
        }
    }

    private void contextReload() {
        try {
            if (this.context.isValid()) {
                this.context.commit();
            } else {
                this.context.abort();
            }
            this.context = new Context();
            this.owningCommunity = (Community)this.context.reloadEntity((ReloadableEntity)this.owningCommunity);
            this.collection = (Collection)this.context.reloadEntity((ReloadableEntity)this.collection);
            this.member = (EPerson)this.context.reloadEntity((ReloadableEntity)this.member);
            this.mgroup = (Group)this.context.reloadEntity((ReloadableEntity)this.mgroup);
            if (this.item != null) {
                UUID itemid = this.item.getID();
                this.context.uncacheEntity((ReloadableEntity)this.item);
                this.item = (Item)this.itemService.find(this.context, itemid);
            }
            this.wsi = (WorkspaceItem)this.context.reloadEntity((ReloadableEntity)this.wsi);
            if (this.wfi != null) {
                int wfid = this.wfi.getID();
                this.context.uncacheEntity((ReloadableEntity)this.wfi);
                this.wfi = (BasicWorkflowItem)this.basicWorkflowItemService.find(this.context, wfid);
            }
            for (ROLE role : ROLE.values()) {
                EPerson eperson = this.roleEPersons.get((Object)role);
                eperson = (EPerson)this.ePersonService.find(this.context, eperson.getID());
                Assert.assertNotNull((Object)eperson);
                this.roleEPersons.put(role, eperson);
                this.roleGroups.put(role, (Group)this.context.reloadEntity((ReloadableEntity)this.roleGroups.get((Object)role)));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error reloading context", (Throwable)e);
        }
    }

    @Override
    @After
    public void destroy() {
        try {
            super.destroy();
        }
        catch (Exception e) {
            log.error((Object)"Error in super destroy", (Throwable)e);
        }
    }

    private void setupItemAndStartWorkflow() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        this.context.setCurrentUser(this.roleEPersons.get((Object)ROLE.SUB));
        this.wsi = this.workspaceItemService.create(this.context, this.collection, false);
        this.item = this.wsi.getItem();
        Bundle bundle = this.bundleService.create(this.context, this.item, "ORIGINAL");
        File f = new File(AbstractDSpaceTest.testProps.get("test.bitstream").toString());
        this.bitstreamService.create(this.context, bundle, (InputStream)new FileInputStream(f));
        this.bundleService.update(this.context, (DSpaceObject)bundle);
        this.itemService.update(this.context, (DSpaceObject)this.item);
        this.workspaceItemService.update(this.context, (InProgressSubmission)this.wsi);
        this.wfi = (BasicWorkflowItem)this.basicWorkflowService.startWithoutNotify(this.context, this.wsi);
        this.basicWorkflowItemService.update(this.context, (InProgressSubmission)this.wfi);
    }

    private void setWorkflowGroup(Context context, int step, Group group) throws SQLException, AuthorizeException {
        this.collection.setWorkflowGroup(context, step, group);
    }

    private void setStepPermissions(ROLE step1, ROLE step2, ROLE step3) throws SQLException, AuthorizeException {
        Group group;
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.roleGroups.get((Object)ROLE.ADMIN));
        Group last = null;
        if (step1 != null) {
            group = this.roleGroups.get((Object)step1);
            this.setWorkflowGroup(this.context, 1, group);
            last = group;
        }
        if (step2 != null) {
            group = this.roleGroups.get((Object)step2);
            this.setWorkflowGroup(this.context, 2, group);
            last = group;
        }
        if (step3 != null) {
            group = this.roleGroups.get((Object)step3);
            this.setWorkflowGroup(this.context, 3, group);
            last = group;
        }
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 3, last);
        this.collectionService.update(this.context, (DSpaceObject)this.collection);
    }

    @Test
    public void testsetWorkflowWithStep1AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP1, false);
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP1);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep1AllRolesClaim() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP1, false);
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP1, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep1ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP1, false);
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP1, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep1Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP1, false);
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP1, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep2AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP2, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP2);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep2AllRolesClaim() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP2, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP2, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep2ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP2, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP2, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep2Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP2, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP2, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep3AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP3, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep3AllRolesClaim() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP3, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep3ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP3, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithStep3Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP3, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps12AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP2);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps12ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP2, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps12Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowStep3());
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.SUB, true);
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP2, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps13AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps13ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps13Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowStep2());
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.SUB, true);
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps23AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP2);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps23ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP2, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps23Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowStep1());
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.SUB, true);
            this.attemptItemAdvance(ROLE.STEP2, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps123AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP2);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps123ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP2, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    @Test
    public void testsetWorkflowWithSteps123Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException, WorkflowException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowStep1(), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowStep2(), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowStep3(), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.SUB, true);
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.SUB, true);
            this.attemptItemAdvance(ROLE.STEP2, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    public void attemptItemClaim(ROLE roleValid) throws SQLException, AuthorizeException, IOException {
        for (ROLE role : ROLE.values()) {
            if (role == ROLE.ADMIN || role == roleValid) continue;
            this.attemptItemClaim(role, true);
        }
        if (roleValid != null) {
            this.attemptItemClaim(roleValid, false);
        }
    }

    public void attemptItemAdvance(ROLE roleValid) throws SQLException, AuthorizeException, IOException {
        for (ROLE role : ROLE.values()) {
            if (role == ROLE.ADMIN || role == roleValid) continue;
            this.attemptItemAdvance(role, true);
        }
        if (roleValid != null) {
            this.attemptItemAdvance(roleValid, false);
        }
    }

    public void attemptItemAdvanceFinal(ROLE roleValid) throws SQLException, AuthorizeException, IOException {
        for (ROLE role : ROLE.values()) {
            if (role == ROLE.ADMIN || role == roleValid) continue;
            this.attemptItemAdvanceFinal(role, true);
        }
        if (roleValid != null) {
            this.attemptItemAdvanceFinal(roleValid, false);
        }
    }

    public void attemptItemClaim(ROLE role, boolean expectAuthFail) throws SQLException, AuthorizeException, IOException {
        EPerson eperson = this.roleEPersons.get((Object)role);
        this.context.setCurrentUser(eperson);
        int state = this.wfi.getState();
        if (expectAuthFail) {
            try {
                this.basicWorkflowService.claim(this.context, this.wfi, eperson);
            }
            catch (AuthorizeException e) {
                this.context.abort();
            }
            catch (Exception e) {
                this.context.abort();
            }
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (state != this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is able to claim task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertEquals((long)state, (long)this.wfi.getState());
            Assert.assertNull((Object)this.wfi.getOwner());
        } else {
            this.basicWorkflowService.claim(this.context, this.wfi, eperson);
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (state == this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is unable to claim task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertNotEquals((long)state, (long)this.wfi.getState());
            Assert.assertNotNull((Object)this.wfi.getOwner());
        }
        Assert.assertFalse((boolean)this.wfi.getItem().isArchived());
    }

    public void attemptItemUnclaim(ROLE role, boolean expectAuthFail) throws SQLException, AuthorizeException, IOException {
        EPerson eperson = this.roleEPersons.get((Object)role);
        this.context.setCurrentUser(eperson);
        int state = this.wfi.getState();
        if (expectAuthFail) {
            try {
                this.basicWorkflowService.unclaim(this.context, this.wfi, eperson);
            }
            catch (AuthorizeException e) {
                this.context.abort();
            }
            catch (Exception e) {
                this.context.abort();
            }
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (state != this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is able to unclaim task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertEquals((long)state, (long)this.wfi.getState());
            Assert.assertNotNull((Object)this.wfi.getOwner());
        } else {
            this.basicWorkflowService.unclaim(this.context, this.wfi, eperson);
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (state == this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is unable to unclaim task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertNotEquals((long)state, (long)this.wfi.getState());
            Assert.assertNull((Object)this.wfi.getOwner());
        }
        Assert.assertFalse((boolean)this.wfi.getItem().isArchived());
    }

    public void attemptItemAdvance(ROLE role, boolean expectAuthFail) throws SQLException, AuthorizeException, IOException {
        EPerson eperson = this.roleEPersons.get((Object)role);
        this.context.setCurrentUser(eperson);
        int state = this.wfi.getState();
        EPerson owner = this.wfi.getOwner();
        if (expectAuthFail) {
            try {
                this.basicWorkflowService.advance(this.context, this.wfi, eperson);
            }
            catch (AuthorizeException e) {
                this.context.abort();
            }
            catch (Exception e) {
                this.context.abort();
            }
            this.contextReload();
            owner = (EPerson)this.ePersonService.find(this.context, owner.getID());
            eperson = this.roleEPersons.get((Object)role);
            if (state != this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is able to advance task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertEquals((long)state, (long)this.wfi.getState());
            Assert.assertEquals((Object)owner, (Object)this.wfi.getOwner());
        } else {
            this.basicWorkflowService.advance(this.context, this.wfi, eperson);
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (state == this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is unable to advance task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertNotEquals((long)state, (long)this.wfi.getState());
            Assert.assertNull((Object)this.wfi.getOwner());
        }
        Assert.assertFalse((boolean)this.wfi.getItem().isArchived());
    }

    public void attemptItemAdvanceFinal(ROLE role, boolean expectAuthFail) throws SQLException, AuthorizeException, IOException {
        EPerson eperson = this.roleEPersons.get((Object)role);
        this.context.setCurrentUser(eperson);
        int state = this.wfi.getState();
        EPerson owner = this.wfi.getOwner();
        if (expectAuthFail) {
            try {
                this.basicWorkflowService.advance(this.context, this.wfi, eperson);
            }
            catch (AuthorizeException e) {
                this.context.abort();
            }
            catch (Exception e) {
                this.context.abort();
            }
            this.contextReload();
            owner = (EPerson)this.ePersonService.find(this.context, owner.getID());
            eperson = this.roleEPersons.get((Object)role);
            if (this.wfi == null) {
                log.error((Object)String.format("USER[%-20s] is able to advance task to completion from state %d (unexpected)", eperson.getFullName(), state), (Throwable)new Exception());
            }
            Assert.assertNotNull((Object)this.wfi);
            Assert.assertEquals((long)state, (long)this.wfi.getState());
            Assert.assertEquals((Object)owner, (Object)this.wfi.getOwner());
            Assert.assertFalse((boolean)this.wfi.getItem().isArchived());
        } else {
            this.basicWorkflowService.advance(this.context, this.wfi, eperson);
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (this.wfi != null) {
                log.error((Object)String.format("USER[%-20s] is unable to advance task to completion from state %d (unexpected)", eperson.getFullName(), state), (Throwable)new Exception());
            }
            Assert.assertNull((Object)this.wfi);
            Assert.assertTrue((boolean)this.item.isArchived());
        }
    }

    protected static enum ROLE {
        ADMIN,
        SUB,
        STEP1,
        STEP2,
        STEP3;

    }
}

