/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import org.dspace.app.itemupdate.DtoMetadata;
import org.dspace.app.itemupdate.ItemArchive;
import org.dspace.app.itemupdate.ItemUpdate;
import org.dspace.app.itemupdate.MetadataUtilities;
import org.dspace.app.itemupdate.UpdateMetadataAction;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;

public class DeleteMetadataAction
extends UpdateMetadataAction {
    @Override
    public void execute(Context context, ItemArchive itarch, boolean isTest, boolean suppressUndo) throws AuthorizeException, ParseException, SQLException {
        Item item = itarch.getItem();
        for (String f : this.targetFields) {
            DtoMetadata dummy = DtoMetadata.create(f, "*", "");
            List<MetadataValue> ardcv = itemService.getMetadataByMetadataString(item, f);
            ItemUpdate.pr("Metadata to be deleted: ");
            for (MetadataValue dcv : ardcv) {
                ItemUpdate.pr("  " + MetadataUtilities.getDCValueString(dcv));
            }
            if (isTest) continue;
            if (!suppressUndo) {
                for (MetadataValue dcv : ardcv) {
                    MetadataField metadataField = dcv.getMetadataField();
                    MetadataSchema metadataSchema = metadataField.getMetadataSchema();
                    itarch.addUndoMetadataField(DtoMetadata.create(metadataSchema.getName(), metadataField.getElement(), metadataField.getQualifier(), dcv.getLanguage(), dcv.getValue()));
                }
            }
            itemService.clearMetadata(context, item, dummy.schema, dummy.element, dummy.qualifier, "*");
        }
    }
}

