/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.xmlbeans.XmlException;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.content.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiWordFilter
extends MediaFilter {
    private static final Logger LOG = LoggerFactory.getLogger(PoiWordFilter.class);

    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".txt";
    }

    @Override
    public String getBundleName() {
        return "TEXT";
    }

    @Override
    public String getFormatString() {
        return "Text";
    }

    @Override
    public String getDescription() {
        return "Extracted text";
    }

    @Override
    public InputStream getDestinationStream(Item currentItem, InputStream source, boolean verbose) throws Exception {
        String text;
        try {
            POITextExtractor extractor = ExtractorFactory.createExtractor((InputStream)source);
            text = extractor.getText();
        }
        catch (IOException | OpenXML4JException | XmlException e) {
            System.err.format("Invalid File Format:  %s%n", e.getMessage());
            LOG.error("Unable to parse the bitstream:  ", e);
            throw e;
        }
        if (verbose) {
            System.out.println(text);
        }
        return new ByteArrayInputStream(text.getBytes());
    }
}

