/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.PersonAuthorityValue;
import org.dspace.authority.orcid.Orcid;
import org.dspace.authority.orcid.model.Bio;
import org.dspace.authority.orcid.model.BioExternalIdentifier;
import org.dspace.authority.orcid.model.BioName;
import org.dspace.authority.orcid.model.BioResearcherUrl;

public class OrcidAuthorityValue
extends PersonAuthorityValue {
    private static Logger log = Logger.getLogger(OrcidAuthorityValue.class);
    private String orcid_id;
    private Map<String, List<String>> otherMetadata = new HashMap<String, List<String>>();
    private boolean update;

    public OrcidAuthorityValue() {
    }

    public OrcidAuthorityValue(SolrDocument document) {
        super(document);
    }

    public String getOrcid_id() {
        return this.orcid_id;
    }

    public void setOrcid_id(String orcid_id) {
        this.orcid_id = orcid_id;
    }

    public Map<String, List<String>> getOtherMetadata() {
        return this.otherMetadata;
    }

    public void addOtherMetadata(String label, String data) {
        List<String> strings = this.otherMetadata.get(label);
        if (strings == null) {
            strings = new ArrayList<String>();
        }
        strings.add(data);
        this.otherMetadata.put(label, strings);
    }

    @Override
    public SolrInputDocument getSolrInputDocument() {
        SolrInputDocument doc = super.getSolrInputDocument();
        if (StringUtils.isNotBlank((String)this.getOrcid_id())) {
            doc.addField("orcid_id", (Object)this.getOrcid_id());
        }
        for (String t : this.otherMetadata.keySet()) {
            List<String> data = this.otherMetadata.get(t);
            for (String data_entry : data) {
                doc.addField("label_" + t, (Object)data_entry);
            }
        }
        return doc;
    }

    @Override
    public void setValues(SolrDocument document) {
        super.setValues(document);
        this.orcid_id = String.valueOf(document.getFieldValue("orcid_id"));
        this.otherMetadata = new HashMap<String, List<String>>();
        for (String fieldName : document.getFieldNames()) {
            String labelPrefix;
            if (!fieldName.startsWith(labelPrefix = "label_")) continue;
            String label = fieldName.substring(labelPrefix.length());
            ArrayList<String> list = new ArrayList<String>();
            Collection fieldValues = document.getFieldValues(fieldName);
            for (Object o : fieldValues) {
                list.add(String.valueOf(o));
            }
            this.otherMetadata.put(label, list);
        }
    }

    public static OrcidAuthorityValue create() {
        OrcidAuthorityValue orcidAuthorityValue = new OrcidAuthorityValue();
        orcidAuthorityValue.setId(UUID.randomUUID().toString());
        orcidAuthorityValue.updateLastModifiedDate();
        orcidAuthorityValue.setCreationDate(new Date());
        return orcidAuthorityValue;
    }

    public static OrcidAuthorityValue create(Bio bio) {
        OrcidAuthorityValue authority = OrcidAuthorityValue.create();
        authority.setValues(bio);
        return authority;
    }

    public boolean setValues(Bio bio) {
        BioName name = bio.getName();
        if (this.updateValue(bio.getOrcid(), this.getOrcid_id())) {
            this.setOrcid_id(bio.getOrcid());
        }
        if (this.updateValue(name.getFamilyName(), this.getLastName())) {
            this.setLastName(name.getFamilyName());
        }
        if (this.updateValue(name.getGivenNames(), this.getFirstName())) {
            this.setFirstName(name.getGivenNames());
        }
        if (StringUtils.isNotBlank((String)name.getCreditName()) && !this.getNameVariants().contains(name.getCreditName())) {
            this.addNameVariant(name.getCreditName());
            this.update = true;
        }
        for (String otherName : name.getOtherNames()) {
            if (this.getNameVariants().contains(otherName)) continue;
            this.addNameVariant(otherName);
            this.update = true;
        }
        if (this.updateOtherMetadata("country", bio.getCountry())) {
            this.addOtherMetadata("country", bio.getCountry());
        }
        for (String keyword : bio.getKeywords()) {
            if (!this.updateOtherMetadata("keyword", keyword)) continue;
            this.addOtherMetadata("keyword", keyword);
        }
        for (BioExternalIdentifier externalIdentifier : bio.getBioExternalIdentifiers()) {
            if (!this.updateOtherMetadata("external_identifier", externalIdentifier.toString())) continue;
            this.addOtherMetadata("external_identifier", externalIdentifier.toString());
        }
        for (BioResearcherUrl researcherUrl : bio.getResearcherUrls()) {
            if (!this.updateOtherMetadata("researcher_url", researcherUrl.toString())) continue;
            this.addOtherMetadata("researcher_url", researcherUrl.toString());
        }
        if (this.updateOtherMetadata("biography", bio.getBiography())) {
            this.addOtherMetadata("biography", bio.getBiography());
        }
        this.setValue(this.getName());
        if (this.update) {
            this.update();
        }
        boolean result = this.update;
        this.update = false;
        return result;
    }

    private boolean updateOtherMetadata(String label, String data) {
        boolean update;
        List<String> strings = this.getOtherMetadata().get(label);
        if (strings == null) {
            update = StringUtils.isNotBlank((String)data);
        } else {
            boolean bl = update = !strings.contains(data);
        }
        if (update) {
            this.update = true;
        }
        return update;
    }

    private boolean updateValue(String incoming, String resident) {
        boolean update;
        boolean bl = update = StringUtils.isNotBlank((String)incoming) && !incoming.equals(resident);
        if (update) {
            this.update = true;
        }
        return update;
    }

    @Override
    public Map<String, String> choiceSelectMap() {
        Map<String, String> map = super.choiceSelectMap();
        map.put("orcid", this.getOrcid_id());
        return map;
    }

    @Override
    public String getAuthorityType() {
        return "orcid";
    }

    @Override
    public String generateString() {
        String generateString = "will be generated::" + this.getAuthorityType() + "::";
        if (StringUtils.isNotBlank((String)this.getOrcid_id())) {
            generateString = generateString + this.getOrcid_id();
        }
        return generateString;
    }

    @Override
    public AuthorityValue newInstance(String info) {
        AuthorityValue authorityValue = null;
        if (StringUtils.isNotBlank((String)info)) {
            Orcid orcid = Orcid.getOrcid();
            authorityValue = orcid.queryAuthorityID(info);
        } else {
            authorityValue = OrcidAuthorityValue.create();
        }
        return authorityValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrcidAuthorityValue that = (OrcidAuthorityValue)o;
        return !(this.orcid_id != null ? !this.orcid_id.equals(that.orcid_id) : that.orcid_id != null);
    }

    public int hashCode() {
        return this.orcid_id != null ? this.orcid_id.hashCode() : 0;
    }

    @Override
    public boolean hasTheSameInformationAs(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.hasTheSameInformationAs(o)) {
            return false;
        }
        OrcidAuthorityValue that = (OrcidAuthorityValue)o;
        if (this.orcid_id != null ? !this.orcid_id.equals(that.orcid_id) : that.orcid_id != null) {
            return false;
        }
        for (String key : this.otherMetadata.keySet()) {
            if (this.otherMetadata.get(key) != null) {
                List<String> metadata = this.otherMetadata.get(key);
                List<String> otherMetadata = that.otherMetadata.get(key);
                if (otherMetadata == null) {
                    return false;
                }
                HashSet<String> metadataSet = new HashSet<String>(metadata);
                HashSet<String> otherMetadataSet = new HashSet<String>(otherMetadata);
                if (metadataSet.equals(otherMetadataSet)) continue;
                return false;
            }
            if (that.otherMetadata.get(key) == null) continue;
            return false;
        }
        return true;
    }
}

