/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authority.orcid.model.Citation;
import org.dspace.authority.orcid.model.CitationType;
import org.dspace.authority.orcid.model.Contributor;
import org.dspace.authority.orcid.model.ContributorAttribute;
import org.dspace.authority.orcid.model.ContributorAttributeRole;
import org.dspace.authority.orcid.model.ContributorAttributeSequence;
import org.dspace.authority.orcid.model.Work;
import org.dspace.authority.orcid.model.WorkExternalIdentifier;
import org.dspace.authority.orcid.model.WorkExternalIdentifierType;
import org.dspace.authority.orcid.model.WorkTitle;
import org.dspace.authority.orcid.model.WorkType;
import org.dspace.authority.orcid.xml.Converter;
import org.dspace.authority.orcid.xml.XMLErrors;
import org.dspace.authority.util.EnumUtils;
import org.dspace.authority.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLtoWork
extends Converter {
    private static Logger log = Logger.getLogger(XMLtoWork.class);
    protected String ORCID_WORKS = "//orcid-works";
    protected String ORCID_WORK = this.ORCID_WORKS + "/orcid-work";
    protected String WORK_TITLE = "work-title";
    protected String TITLE = this.WORK_TITLE + "/title";
    protected String SUBTITLE = this.WORK_TITLE + "/subtitle";
    protected String TRANSLATED_TITLES = this.WORK_TITLE + "/translated-title";
    protected String TRANSLATED_TITLES_LANGUAGE = "@language-code";
    protected String SHORT_DESCRIPTION = "short-description";
    protected String WORK_CITATION = "work-citation";
    protected String CITATION_TYPE = this.WORK_CITATION + "/work-citation-type";
    protected String CITATION = this.WORK_CITATION + "/citation";
    protected String WORK_TYPE = "work-type";
    protected String PUBLICATION_DATE = "publication-date";
    protected String YEAR = this.PUBLICATION_DATE + "/year";
    protected String MONTH = this.PUBLICATION_DATE + "/month";
    protected String DAY = this.PUBLICATION_DATE + "/day";
    protected String WORK_EXTERNAL_IDENTIFIERS = "work-external-identifiers";
    protected String WORK_EXTERNAL_IDENTIFIER = this.WORK_EXTERNAL_IDENTIFIERS + "/work-external-identifier";
    protected String WORK_EXTERNAL_IDENTIFIER_TYPE = "work-external-identifier-type";
    protected String WORK_EXTERNAL_IDENTIFIER_ID = "work-external-identifier-id";
    protected String URL = "url";
    protected String WORK_CONTRIBUTOR = "work-contributors";
    protected String CONTRIBUTOR = this.WORK_CONTRIBUTOR + "/contributor";
    protected String CONTRIBUTOR_ORCID = "contributor-orcid";
    protected String CREDIT_NAME = "credit-name";
    protected String CONTRIBUTOR_EMAIL = "contributor-email";
    protected String CONTRIBUTOR_ATTRIBUTES = "contributor-attributes";
    protected String CONTRIBUTOR_SEQUENCE = "contributor-sequence";
    protected String CONTRIBUTOR_ROLE = "contributor-role";
    protected String WORK_SOURCE = "work-source";

    public List<Work> convert(Document document) {
        ArrayList<Work> result = new ArrayList<Work>();
        if (XMLErrors.check(document)) {
            try {
                Iterator<Node> iterator = XMLUtils.getNodeListIterator(document, this.ORCID_WORK);
                while (iterator.hasNext()) {
                    Work work = this.convertWork(iterator.next());
                    result.add(work);
                }
            }
            catch (XPathExpressionException e) {
                log.error((Object)"Error in xpath syntax", (Throwable)e);
            }
        } else {
            this.processError(document);
        }
        return result;
    }

    protected Work convertWork(Node node) throws XPathExpressionException {
        Work work = new Work();
        this.setTitle(node, work);
        this.setDescription(node, work);
        this.setCitation(node, work);
        this.setWorkType(node, work);
        this.setPublicationDate(node, work);
        this.setExternalIdentifiers(node, work);
        this.setUrl(node, work);
        this.setContributors(node, work);
        this.setWorkSource(node, work);
        return work;
    }

    protected void setWorkSource(Node node, Work work) throws XPathExpressionException {
        String workSource = XMLUtils.getTextContent(node, this.WORK_SOURCE);
        work.setWorkSource(workSource);
    }

    protected void setContributors(Node node, Work work) throws XPathExpressionException {
        HashSet<Contributor> contributors = new HashSet<Contributor>();
        Iterator<Node> iterator = XMLUtils.getNodeListIterator(node, this.CONTRIBUTOR);
        while (iterator.hasNext()) {
            Node nextContributorNode = iterator.next();
            String orcid = XMLUtils.getTextContent(nextContributorNode, this.CONTRIBUTOR_ORCID);
            String creditName = XMLUtils.getTextContent(nextContributorNode, this.CREDIT_NAME);
            String email = XMLUtils.getTextContent(nextContributorNode, this.CONTRIBUTOR_EMAIL);
            HashSet<ContributorAttribute> contributorAttributes = new HashSet<ContributorAttribute>();
            NodeList attributeNodes = XMLUtils.getNodeList(nextContributorNode, this.CONTRIBUTOR_ATTRIBUTES);
            Iterator<Node> attributesIterator = XMLUtils.getNodeListIterator(attributeNodes);
            while (attributesIterator.hasNext()) {
                Node nextAttribute = attributesIterator.next();
                String roleText = XMLUtils.getTextContent(nextAttribute, this.CONTRIBUTOR_ROLE);
                ContributorAttributeRole role = EnumUtils.lookup(ContributorAttributeRole.class, roleText);
                String sequenceText = XMLUtils.getTextContent(nextAttribute, this.CONTRIBUTOR_SEQUENCE);
                ContributorAttributeSequence sequence = EnumUtils.lookup(ContributorAttributeSequence.class, sequenceText);
                ContributorAttribute attribute = new ContributorAttribute(role, sequence);
                contributorAttributes.add(attribute);
            }
            Contributor contributor = new Contributor(orcid, creditName, email, contributorAttributes);
            contributors.add(contributor);
        }
        work.setContributors(contributors);
    }

    protected void setUrl(Node node, Work work) throws XPathExpressionException {
        String url = XMLUtils.getTextContent(node, this.URL);
        work.setUrl(url);
    }

    protected void setExternalIdentifiers(Node node, Work work) throws XPathExpressionException {
        Iterator<Node> iterator = XMLUtils.getNodeListIterator(node, this.WORK_EXTERNAL_IDENTIFIER);
        while (iterator.hasNext()) {
            Node work_external_identifier = iterator.next();
            String typeText = XMLUtils.getTextContent(work_external_identifier, this.WORK_EXTERNAL_IDENTIFIER_TYPE);
            WorkExternalIdentifierType type = EnumUtils.lookup(WorkExternalIdentifierType.class, typeText);
            String id = XMLUtils.getTextContent(work_external_identifier, this.WORK_EXTERNAL_IDENTIFIER_ID);
            WorkExternalIdentifier externalID = new WorkExternalIdentifier(type, id);
            work.setWorkExternalIdentifier(externalID);
        }
    }

    protected void setPublicationDate(Node node, Work work) throws XPathExpressionException {
        String year = XMLUtils.getTextContent(node, this.YEAR);
        String month = XMLUtils.getTextContent(node, this.MONTH);
        String day = XMLUtils.getTextContent(node, this.DAY);
        String publicationDate = year;
        if (StringUtils.isNotBlank((String)month)) {
            publicationDate = publicationDate + "-" + month;
            if (StringUtils.isNotBlank((String)day)) {
                publicationDate = publicationDate + "-" + day;
            }
        }
        work.setPublicationDate(publicationDate);
    }

    protected void setWorkType(Node node, Work work) throws XPathExpressionException {
        String workTypeText = XMLUtils.getTextContent(node, this.WORK_TYPE);
        WorkType workType = EnumUtils.lookup(WorkType.class, workTypeText);
        work.setWorkType(workType);
    }

    protected void setCitation(Node node, Work work) throws XPathExpressionException {
        String typeText = XMLUtils.getTextContent(node, this.CITATION_TYPE);
        CitationType type = EnumUtils.lookup(CitationType.class, typeText);
        String citationtext = XMLUtils.getTextContent(node, this.CITATION);
        Citation citation = new Citation(type, citationtext);
        work.setCitation(citation);
    }

    protected void setDescription(Node node, Work work) throws XPathExpressionException {
        String description = null;
        description = XMLUtils.getTextContent(node, this.SHORT_DESCRIPTION);
        work.setDescription(description);
    }

    protected void setTitle(Node node, Work work) throws XPathExpressionException {
        String title = XMLUtils.getTextContent(node, this.TITLE);
        String subtitle = XMLUtils.getTextContent(node, this.SUBTITLE);
        HashMap<String, String> translatedTitles = new HashMap<String, String>();
        NodeList nodeList = XMLUtils.getNodeList(node, this.TRANSLATED_TITLES);
        Iterator<Node> iterator = XMLUtils.getNodeListIterator(nodeList);
        while (iterator.hasNext()) {
            Node languageNode = iterator.next();
            String language = XMLUtils.getTextContent(languageNode, this.TRANSLATED_TITLES_LANGUAGE);
            String translated_title = XMLUtils.getTextContent(languageNode, ".");
            translatedTitles.put(language, translated_title);
        }
        WorkTitle workTitle = new WorkTitle(title, subtitle, translatedTitles);
        work.setWorkTitle(workTitle);
    }
}

